/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.amber.type;

import com.caucho.amber.type.DoubleType;
import com.caucho.amber.type.PrimitiveType;
import com.caucho.amber.type.Type;
import com.caucho.java.JavaWriter;
import com.caucho.util.L10N;
import com.rc.retroweaver.runtime.ClassLiteral;
import java.io.IOException;

public class PrimitiveDoubleType
extends PrimitiveType {
    private static final L10N L = new L10N(ClassLiteral.getClass((String)"com/caucho/amber/type/PrimitiveDoubleType"));
    private static final PrimitiveDoubleType DOUBLE_TYPE = new PrimitiveDoubleType();

    private PrimitiveDoubleType() {
    }

    public static PrimitiveDoubleType create() {
        return DOUBLE_TYPE;
    }

    public String getName() {
        return "double";
    }

    public Type getForeignType() {
        return DoubleType.create();
    }

    public int generateLoad(JavaWriter out, String rs, String indexVar, int index) throws IOException {
        out.print(rs + ".getDouble(" + indexVar + " + " + index + ")");
        return index + 1;
    }

    public void generateSet(JavaWriter out, String pstmt, String index, String value) throws IOException {
        out.println(pstmt + ".setDouble(" + index + "++, " + value + ");");
    }

    public void generateSetNull(JavaWriter out, String pstmt, String index) throws IOException {
        out.println(pstmt + ".setNull(" + index + "++, java.sql.Types.DOUBLE);");
    }

    public String toObject(String value) {
        return "new Double(" + value + ")";
    }

    public String generateCastFromObject(String value) {
        return "((Number) " + value + ").doubleValue()";
    }
}

