/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.amber.type;

import com.caucho.amber.type.FloatType;
import com.caucho.amber.type.PrimitiveType;
import com.caucho.amber.type.Type;
import com.caucho.java.JavaWriter;
import com.caucho.util.L10N;
import com.rc.retroweaver.runtime.ClassLiteral;
import java.io.IOException;

public class PrimitiveFloatType
extends PrimitiveType {
    private static final L10N L = new L10N(ClassLiteral.getClass((String)"com/caucho/amber/type/PrimitiveFloatType"));
    private static final PrimitiveFloatType FLOAT_TYPE = new PrimitiveFloatType();

    private PrimitiveFloatType() {
    }

    public static PrimitiveFloatType create() {
        return FLOAT_TYPE;
    }

    public String getName() {
        return "float";
    }

    public Type getForeignType() {
        return FloatType.create();
    }

    public int generateLoad(JavaWriter out, String rs, String indexVar, int index) throws IOException {
        out.print(rs + ".getFloat(" + indexVar + " + " + index + ")");
        return index + 1;
    }

    public void generateSet(JavaWriter out, String pstmt, String index, String value) throws IOException {
        out.println(pstmt + ".setFloat(" + index + "++, " + value + ");");
    }

    public void generateSetNull(JavaWriter out, String pstmt, String index) throws IOException {
        out.println(pstmt + ".setNull(" + index + "++, java.sql.Types.REAL);");
    }

    public String toObject(String value) {
        return "new Float(" + value + ")";
    }

    public String generateCastFromObject(String value) {
        return "((Number) " + value + ").floatValue()";
    }
}

