/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.amber.type;

import com.caucho.amber.AmberManager;
import com.caucho.amber.type.LongType;
import com.caucho.amber.type.PrimitiveType;
import com.caucho.amber.type.Type;
import com.caucho.java.JavaWriter;
import com.caucho.util.L10N;
import com.rc.retroweaver.runtime.ClassLiteral;
import java.io.IOException;

public class PrimitiveLongType
extends PrimitiveType {
    private static final L10N L = new L10N(ClassLiteral.getClass((String)"com/caucho/amber/type/PrimitiveLongType"));
    private static final PrimitiveLongType LONG_TYPE = new PrimitiveLongType();

    private PrimitiveLongType() {
    }

    public static PrimitiveLongType create() {
        return LONG_TYPE;
    }

    public String getName() {
        return "long";
    }

    public Type getForeignType() {
        return LongType.create();
    }

    public String generateCreateTableSQL(AmberManager manager, int length) {
        return manager.getCreateTableSQL(-5, length);
    }

    public int generateLoad(JavaWriter out, String rs, String indexVar, int index) throws IOException {
        out.print(rs + ".getLong(" + indexVar + " + " + index + ")");
        return index + 1;
    }

    public int generateLoadForeign(JavaWriter out, String rs, String indexVar, int index) throws IOException {
        out.print("com.caucho.amber.type.PrimitiveLongType.toForeignLong(" + rs + ".getLong(" + indexVar + " + " + index + "), " + rs + ".wasNull())");
        return index + 1;
    }

    public void generateSet(JavaWriter out, String pstmt, String index, String value) throws IOException {
        out.println(pstmt + ".setLong(" + index + "++, " + value + ");");
    }

    public void generateSetNull(JavaWriter out, String pstmt, String index) throws IOException {
        out.println(pstmt + ".setNull(" + index + "++, java.sql.Types.BIGINT);");
    }

    public String toObject(String value) {
        return "new Long(" + value + ")";
    }

    public String generateCastFromObject(String value) {
        return "((Number) " + value + ").longValue()";
    }

    public static Long toForeignLong(long value, boolean wasNull) {
        if (wasNull || value == 0L) {
            return null;
        }
        return new Long(value);
    }
}

