/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.amber.type;

import com.caucho.amber.AmberManager;
import com.caucho.amber.type.PrimitiveType;
import com.caucho.amber.type.ShortType;
import com.caucho.amber.type.Type;
import com.caucho.java.JavaWriter;
import com.caucho.util.L10N;
import com.rc.retroweaver.runtime.ClassLiteral;
import java.io.IOException;

public class PrimitiveShortType
extends PrimitiveType {
    private static final L10N L = new L10N(ClassLiteral.getClass((String)"com/caucho/amber/type/PrimitiveShortType"));
    private static final PrimitiveShortType SHORT_TYPE = new PrimitiveShortType();

    private PrimitiveShortType() {
    }

    public static PrimitiveShortType create() {
        return SHORT_TYPE;
    }

    public String getName() {
        return "short";
    }

    public Type getForeignType() {
        return ShortType.create();
    }

    public String generateCreateTableSQL(AmberManager manager, int length) {
        return manager.getCreateTableSQL(5, length);
    }

    public int generateLoad(JavaWriter out, String rs, String indexVar, int index) throws IOException {
        out.print(rs + ".getShort(" + indexVar + " + " + index + ")");
        return index + 1;
    }

    public void generateSet(JavaWriter out, String pstmt, String index, String value) throws IOException {
        out.println(pstmt + ".setShort(" + index + "++, " + value + ");");
    }

    public void generateSetNull(JavaWriter out, String pstmt, String index) throws IOException {
        out.println(pstmt + ".setNull(" + index + "++, java.sql.Types.SMALLINT);");
    }

    public String toObject(String value) {
        return "new Short(" + value + ")";
    }

    public String generateCastFromObject(String value) {
        return "((Number) " + value + ").shortValue()";
    }

    public Object toObject(long value) {
        return new Short((short)value);
    }
}

