/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.bytecode;

import com.caucho.bytecode.Analyzer;
import com.caucho.bytecode.Attribute;
import com.caucho.bytecode.CodeAttribute;
import com.caucho.bytecode.CodeVisitor;
import com.caucho.bytecode.JavaClass;
import com.caucho.log.Log;
import com.caucho.util.ByteBuffer;
import com.caucho.util.IntArray;
import com.caucho.util.L10N;
import com.rc.retroweaver.runtime.ClassLiteral;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;

public class CodeEnhancer
extends CodeVisitor {
    private static final Logger log = Log.open(ClassLiteral.getClass((String)"com/caucho/bytecode/CodeEnhancer"));
    private static final L10N L = new L10N(ClassLiteral.getClass((String)"com/caucho/bytecode/CodeEnhancer"));
    private ByteBuffer _code;
    private ArrayList<Jump> _jumps;
    private boolean _changeLength;
    private IntArray _pendingTargets;
    private IntArray _completedTargets;

    public CodeEnhancer() {
    }

    public CodeEnhancer(JavaClass javaClass, CodeAttribute code) {
        this.init(javaClass, code);
    }

    public void init(JavaClass javaClass, CodeAttribute codeAttr) {
        super.init(javaClass, codeAttr);
        this._code = new ByteBuffer();
        byte[] codeBuffer = codeAttr.getCode();
        this._code.add(codeBuffer, 0, codeBuffer.length);
        this._changeLength = false;
    }

    public void analyze(Analyzer analyzer, boolean allowFlow) throws Exception {
        this._pendingTargets = new IntArray();
        this._completedTargets = new IntArray();
        this.analyzeImpl(analyzer, allowFlow, this._pendingTargets, this._completedTargets);
    }

    public byte[] getCode() {
        return this._code.getBuffer();
    }

    public int getLength() {
        return this._code.getLength();
    }

    public void addByte(int offset, int value) {
        this.insertCode(offset, 1);
        this._code.add(offset, value);
    }

    public void setByte(int offset, int value) {
        this._code.set(offset, value);
    }

    public void add(int offset, byte[] buffer, int bufOffset, int length) {
        this.insertCode(offset, length);
        this._code.add(offset, buffer, bufOffset, length);
    }

    public void remove(int offset, int count) {
        this.removeCode(offset, count);
        this._code.remove(offset, count);
    }

    protected void insertCode(int offset, int count) {
        int i;
        if (this._jumps == null) {
            this.analyzeJumps();
        }
        if (offset <= this._offset) {
            this._offset += count;
        }
        for (int i2 = 0; i2 < this._jumps.size(); ++i2) {
            Jump jump = this._jumps.get(i2);
            jump.insert(this, offset, count);
        }
        ArrayList<CodeAttribute.ExceptionItem> exns = this.getExceptions();
        for (i = 0; i < exns.size(); ++i) {
            CodeAttribute.ExceptionItem exn = exns.get(i);
            if (offset <= exn.getStart()) {
                exn.setStart(exn.getStart() + count);
            }
            if (offset <= exn.getEnd()) {
                exn.setEnd(exn.getEnd() + count);
            }
            if (offset > exn.getHandler()) continue;
            exn.setHandler(exn.getHandler() + count);
        }
        if (this._pendingTargets != null) {
            for (i = this._pendingTargets.size() - 1; i >= 0; --i) {
                int target = this._pendingTargets.get(i);
                if (offset > target) continue;
                this._pendingTargets.set(i, target + count);
            }
            for (i = this._completedTargets.size() - 1; i >= 0; --i) {
                int target = this._completedTargets.get(i);
                if (offset > target) continue;
                this._completedTargets.set(i, target + count);
            }
        }
    }

    protected void removeCode(int offset, int count) {
        int i;
        if (this._jumps == null) {
            this.analyzeJumps();
        }
        if (offset + count < this._offset) {
            this._offset -= count;
        } else if (offset <= this._offset) {
            this._offset = offset;
        }
        for (int i2 = 0; i2 < this._jumps.size(); ++i2) {
            Jump jump = this._jumps.get(i2);
            jump.remove(this, offset, count);
        }
        ArrayList<CodeAttribute.ExceptionItem> exns = this.getExceptions();
        for (i = 0; i < exns.size(); ++i) {
            CodeAttribute.ExceptionItem exn = exns.get(i);
            exn.setStart(this.remove(exn.getStart(), offset, count));
            exn.setEnd(this.remove(exn.getEnd(), offset, count));
            exn.setHandler(this.remove(exn.getHandler(), offset, count));
        }
        if (this._pendingTargets != null) {
            for (i = this._pendingTargets.size() - 1; i >= 0; --i) {
                int target = this._pendingTargets.get(i);
                this._pendingTargets.set(i, this.remove(target, offset, count));
            }
            for (i = this._completedTargets.size() - 1; i >= 0; --i) {
                int target = this._completedTargets.get(i);
                this._completedTargets.set(i, this.remove(target, offset, count));
            }
        }
    }

    protected void analyzeJumps() {
        this._jumps = new ArrayList();
        this._changeLength = true;
        JumpAnalyzer analyzer = new JumpAnalyzer();
        CodeVisitor visitor = new CodeVisitor(this.getJavaClass(), this.getCodeAttribute());
        try {
            visitor.analyze(analyzer);
        }
        catch (Exception e) {
            log.log(Level.WARNING, e.toString(), e);
        }
    }

    public void update() {
        byte[] code = new byte[this._code.size()];
        System.arraycopy(this._code.getBuffer(), 0, code, 0, this._code.size());
        this._codeAttr.setCode(code);
        if (this._changeLength) {
            ArrayList<Attribute> attrList = this.getCodeAttribute().getAttributes();
            for (int i = attrList.size() - 1; i >= 0; --i) {
                Attribute attr = attrList.get(i);
                if (!attr.getName().equals("LineNumberTable")) continue;
                attrList.remove(i);
            }
        }
    }

    private int remove(int pc, int offset, int count) {
        if (pc < offset) {
            return pc;
        }
        if (pc < offset + count) {
            return offset;
        }
        return pc - count;
    }

    class JumpAnalyzer
    extends Analyzer {
        JumpAnalyzer() {
        }

        public void analyze(CodeVisitor visitor) throws Exception {
            if (!visitor.isBranch()) {
                return;
            }
            int src = visitor.getOffset();
            int offset = visitor.getShortArg(1);
            CodeEnhancer.this._jumps.add(new Jump(src, offset));
        }
    }

    static class Jump {
        private int _src;
        private int _delta;

        Jump(int src, int delta) {
            this._src = src;
            this._delta = delta;
        }

        void insert(CodeEnhancer enhancer, int offset, int count) {
            if (offset <= this._src && offset <= this._src + this._delta) {
                this._src += count;
            } else if (this._src < offset && offset < this._src + this._delta) {
                this._delta += count;
                enhancer.setShort(this._src + 1, this._delta);
            } else if (this._src + this._delta <= offset && offset <= this._src) {
                this._delta -= count;
                enhancer.setShort(this._src + 1, this._delta);
                this._src += count;
            }
        }

        void remove(CodeEnhancer enhancer, int offset, int count) {
            if (offset <= this._src && offset <= this._src + this._delta) {
                this._src -= count;
            } else if (this._src < offset && offset < this._src + this._delta) {
                this._delta -= count;
                enhancer.setShort(this._src + 1, this._delta);
            } else if (this._src + this._delta <= offset && offset <= this._src) {
                this._delta += count;
                enhancer.setShort(this._src + 1, this._delta);
                this._src -= count;
            }
        }
    }
}

