/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.bytecode;

import com.caucho.bytecode.ByteCodeWriter;
import com.caucho.bytecode.ConstantPool;
import com.caucho.bytecode.ConstantPoolEntry;
import com.caucho.log.Log;
import com.rc.retroweaver.runtime.ClassLiteral;
import java.io.IOException;
import java.util.logging.Logger;

public class StringConstant
extends ConstantPoolEntry {
    private static final Logger log = Log.open(ClassLiteral.getClass((String)"com/caucho/bytecode/StringConstant"));
    private int _stringIndex;

    StringConstant(ConstantPool pool, int index, int stringIndex) {
        super(pool, index);
        this._stringIndex = stringIndex;
    }

    public String getString() {
        return this.getConstantPool().getUtf8(this._stringIndex).getValue();
    }

    void write(ByteCodeWriter out) throws IOException {
        out.write(8);
        out.writeShort(this._stringIndex);
    }

    public int export(ConstantPool target) {
        return target.addString(this.getString()).getIndex();
    }

    public String toString() {
        return "StringConstant[" + this.getString() + "]";
    }
}

