/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.config;

import com.caucho.config.ConfigException;
import com.caucho.config.TypeBuilder;
import com.caucho.config.TypeBuilderFactory;
import com.caucho.el.ELParser;
import com.caucho.el.Expr;
import com.caucho.util.L10N;
import com.rc.retroweaver.runtime.ClassLiteral;
import javax.servlet.jsp.el.ELException;

public abstract class AttributeBuilder {
    static L10N L = new L10N(ClassLiteral.getClass((String)"com/caucho/config/AttributeBuilder"));

    protected AttributeBuilder() {
    }

    public boolean isPrimitive() {
        return false;
    }

    public void setString(Object bean, String value) throws Exception {
        throw new UnsupportedOperationException(String.valueOf(this));
    }

    public TypeBuilder getBuilder() throws Exception {
        return null;
    }

    public TypeBuilder getBuilder(Class subClass) throws Exception {
        return this.getBuilder();
    }

    public TypeBuilder getBuilder(String className) throws Exception {
        if (className == null) {
            return this.getBuilder();
        }
        TypeBuilder builder = this.getBuilder();
        if (builder == null) {
            return null;
        }
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        Class<?> subClass = Class.forName(className, false, loader);
        if (this.getBuilder().getType() == null) {
            throw new ConfigException(L.l("builder `{0}' has no type.", this.getBuilder()));
        }
        if (!this.getBuilder().getType().isAssignableFrom(subClass)) {
            throw new ConfigException(L.l("`{0}' must be a subclass of `{1}'.", (Object)subClass.getName(), this.getBuilder().getType().getName()));
        }
        return this.getBuilder(subClass);
    }

    public Object create(Object parent, TypeBuilder typeBuilder) throws Exception {
        Object child = typeBuilder.create();
        try {
            this.getBuilder().setAttribute(child, "parent", parent);
        }
        catch (Exception e) {
            // empty catch block
        }
        return child;
    }

    public void setChild(Object bean, Object child) throws Exception {
        throw new UnsupportedOperationException(String.valueOf(this));
    }

    public static String evalString(String exprString) throws ELException {
        if (exprString.indexOf("${") >= 0) {
            ELParser parser = new ELParser(exprString);
            parser.setCheckEscape(true);
            Expr expr = parser.parse();
            return expr.evalString(TypeBuilderFactory.getEnvironment());
        }
        return exprString;
    }

    public static boolean evalBoolean(String exprString) throws ELException {
        if (exprString.indexOf("${") >= 0) {
            ELParser parser = new ELParser(exprString);
            parser.setCheckEscape(true);
            Expr expr = parser.parse();
            return expr.evalBoolean(TypeBuilderFactory.getEnvironment());
        }
        return Expr.toBoolean(exprString, null);
    }

    public static long evalLong(String exprString) throws ELException {
        if (exprString.indexOf("${") >= 0) {
            ELParser parser = new ELParser(exprString);
            parser.setCheckEscape(true);
            Expr expr = parser.parse();
            return expr.evalLong(TypeBuilderFactory.getEnvironment());
        }
        return Expr.toLong(exprString, null);
    }

    public static double evalDouble(String exprString) throws ELException {
        if (exprString.indexOf("${") >= 0) {
            ELParser parser = new ELParser(exprString);
            parser.setCheckEscape(true);
            Expr expr = parser.parse();
            return expr.evalDouble(TypeBuilderFactory.getEnvironment());
        }
        return Expr.toDouble(exprString, null);
    }

    public static Object evalObject(String exprString) throws ELException {
        if (exprString.indexOf("${") >= 0) {
            ELParser parser = new ELParser(exprString);
            parser.setCheckEscape(true);
            Expr expr = parser.parse();
            if (expr != null) {
                return expr.evalObject(TypeBuilderFactory.getEnvironment());
            }
            return exprString;
        }
        return exprString;
    }
}

