/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.config.types;

import com.caucho.config.ConfigException;
import com.caucho.el.EL;
import com.caucho.util.CharBuffer;
import com.caucho.util.L10N;
import com.rc.retroweaver.runtime.ClassLiteral;
import java.lang.reflect.Constructor;
import java.util.ArrayList;

public class InstantiationConfig {
    private static L10N L = new L10N(ClassLiteral.getClass((String)"com/caucho/config/types/InstantiationConfig"));
    private String _value;
    private Class _type;
    private ArrayList<Object> _args = new ArrayList();
    private int _index;

    public Class getType() {
        return this._type;
    }

    public void addText(String value) {
        this._value = value;
    }

    public void addArg(Object value) {
        this._args.add(value);
    }

    public void init() throws Exception {
        if (this._value == null) {
            throw new ConfigException(L.l("An instantiation requires the class name."));
        }
        this.parseSignature();
    }

    public Object create() throws Exception {
        Object[] args = new Object[this._args.size()];
        Class[] paramTypes = new Class[args.length];
        for (int i = 0; i < this._args.size(); ++i) {
            Object arg;
            args[i] = arg = this._args.get(i);
            paramTypes[i] = arg == null ? ClassLiteral.getClass((String)"java/lang/Object") : arg.getClass();
        }
        Constructor constructor = this.getConstructor(this._type, paramTypes);
        if (constructor == null) {
            throw new ConfigException(L.l("Can't find public constructor for `{0}'.", this._type.getName()));
        }
        return constructor.newInstance(args);
    }

    private Constructor getConstructor(Class cl, Class[] types) {
        Constructor<?>[] constructors = cl.getConstructors();
        for (int i = 0; i < constructors.length; ++i) {
            Class<?>[] args = constructors[i].getParameterTypes();
            if (args.length != types.length) continue;
            return constructors[i];
        }
        return null;
    }

    private void parseSignature() throws Exception {
        this._index = 0;
        String type = this.parseType(this.skipWhitespace(this.read()));
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        this._type = Class.forName(type, false, loader);
        int ch = this.skipWhitespace(this.read());
        if (ch < 0) {
            return;
        }
        if (ch != 40) {
            throw new ConfigException(L.l("expected `(' in constructor `{0}'", this._value));
        }
        CharBuffer cb = CharBuffer.allocate();
        ch = 44;
        while (ch == 44) {
            ch = this.skipWhitespace(this.read());
            cb.clear();
            if (ch == 39 || ch == 34) {
                int end = ch;
                ch = this.read();
                while (ch > 0 && ch != end) {
                    if (ch == 92) {
                        cb.append(this.read());
                    } else {
                        cb.append((char)ch);
                    }
                    ch = this.read();
                }
                this._args.add(cb.toString());
                continue;
            }
            if (ch == 36) {
                ch = this.read();
                if (ch != 123) {
                    throw new ConfigException(L.l("expected EL-expression at $ in `{0}'", this._value));
                }
                ch = this.read();
                while (ch > 0 && ch != 125) {
                    cb.append((char)ch);
                    ch = this.read();
                }
                this._args.add(EL.evalObject(cb.toString()));
                continue;
            }
            throw new ConfigException(L.l("expected string or EL-expression in `{0}'", this._value));
        }
    }

    private String parseType(int ch) throws ConfigException {
        CharBuffer cb = CharBuffer.allocate();
        while (Character.isJavaIdentifierPart((char)ch) || ch == 46) {
            cb.append((char)ch);
            ch = this.read();
        }
        if (cb.length() == 0) {
            throw new ConfigException(L.l("unexpected empty type in `{0}'", this._value));
        }
        String className = cb.toString();
        this.unread(ch);
        return className;
    }

    private int skipWhitespace(int ch) {
        while (Character.isWhitespace((char)ch)) {
            ch = this.read();
        }
        return ch;
    }

    private int read() {
        if (this._index < this._value.length()) {
            return this._value.charAt(this._index++);
        }
        return -1;
    }

    private void unread(int ch) {
        if (ch >= 0) {
            --this._index;
        }
    }
}

