/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.config.types;

import com.caucho.config.BeanBuilderException;
import com.caucho.config.TypeBuilder;
import com.caucho.el.ELParser;
import com.caucho.el.Expr;
import com.caucho.util.IntMap;
import com.caucho.util.L10N;
import com.rc.retroweaver.runtime.ClassLiteral;
import javax.servlet.jsp.el.ELException;

public class PrimitiveTypeBuilder
extends TypeBuilder {
    public static final int BOOLEAN_BUILDER = 1;
    public static final int BYTE_BUILDER = 2;
    public static final int CHARACTER_BUILDER = 3;
    public static final int SHORT_BUILDER = 4;
    public static final int INTEGER_BUILDER = 5;
    public static final int LONG_BUILDER = 6;
    public static final int FLOAT_BUILDER = 7;
    public static final int DOUBLE_BUILDER = 8;
    public static final int STRING_BUILDER = 9;
    static L10N L = new L10N(ClassLiteral.getClass((String)"com/caucho/config/types/PrimitiveTypeBuilder"));
    private static final IntMap _acceptedTypes = new IntMap();
    private final int _builder;

    public PrimitiveTypeBuilder(Class type) throws BeanBuilderException {
        super(type);
        if (!PrimitiveTypeBuilder.accepts(type)) {
            throw new BeanBuilderException(L.l("Unsupported type: `{0}'.", type.getName()));
        }
        this._builder = _acceptedTypes.get(type);
    }

    public Object create(String value) throws BeanBuilderException, ELException {
        if (value == null) {
            return this.createNull();
        }
        if (value.indexOf("${") >= 0) {
            Expr expr = new ELParser(value).parse();
            switch (this._builder) {
                case 1: {
                    return expr.evalBoolean(this.getEnvironment()) ? Boolean.TRUE : Boolean.FALSE;
                }
                case 2: {
                    return new Byte((byte)expr.evalLong(this.getEnvironment()));
                }
                case 3: {
                    String v = expr.evalString(this.getEnvironment());
                    if (value.length() > 1) {
                        throw new BeanBuilderException(L.l("Can't convert string `{0}' into a character.", v));
                    }
                    return new Character(v.charAt(0));
                }
                case 4: {
                    return new Short((short)expr.evalLong(this.getEnvironment()));
                }
                case 5: {
                    return new Integer((int)expr.evalLong(this.getEnvironment()));
                }
                case 6: {
                    return new Long(expr.evalLong(this.getEnvironment()));
                }
                case 7: {
                    return new Float((float)expr.evalDouble(this.getEnvironment()));
                }
                case 8: {
                    return new Double(expr.evalDouble(this.getEnvironment()));
                }
                case 9: {
                    return expr.evalString(this.getEnvironment());
                }
            }
            throw new IllegalStateException(L.l("Shouldn't happen"));
        }
        switch (this._builder) {
            case 1: {
                return Boolean.valueOf(value);
            }
            case 2: {
                return Byte.valueOf(value);
            }
            case 3: {
                if (value.length() > 1) {
                    throw new BeanBuilderException(L.l("Can't convert string `{0}' into a character.", value));
                }
                return new Character(value.charAt(0));
            }
            case 4: {
                return Short.valueOf(value);
            }
            case 5: {
                return Integer.valueOf(value);
            }
            case 6: {
                return Long.valueOf(value);
            }
            case 7: {
                return Float.valueOf(value);
            }
            case 8: {
                return Double.valueOf(value);
            }
            case 9: {
                return value;
            }
        }
        throw new IllegalStateException(L.l("Shouldn't happen"));
    }

    private Object createNull() {
        switch (this._builder) {
            case 1: {
                return Boolean.TRUE;
            }
            case 2: {
                return new Byte(0);
            }
            case 3: {
                return new Character('\u0000');
            }
            case 4: {
                return new Short(0);
            }
            case 5: {
                return new Integer(0);
            }
            case 6: {
                return new Long(0L);
            }
            case 7: {
                return new Float(0.0f);
            }
            case 8: {
                return new Double(0.0);
            }
            case 9: {
                return "";
            }
        }
        throw new IllegalStateException(L.l("Shouldn't happen"));
    }

    public static boolean accepts(Class type) {
        return _acceptedTypes.get(type) != -65536;
    }

    static {
        _acceptedTypes.put(Boolean.TYPE, 1);
        _acceptedTypes.put(ClassLiteral.getClass((String)"java/lang/Boolean"), 1);
        _acceptedTypes.put(Byte.TYPE, 2);
        _acceptedTypes.put(ClassLiteral.getClass((String)"java/lang/Byte"), 2);
        _acceptedTypes.put(Character.TYPE, 3);
        _acceptedTypes.put(ClassLiteral.getClass((String)"java/lang/Character"), 3);
        _acceptedTypes.put(Short.TYPE, 4);
        _acceptedTypes.put(ClassLiteral.getClass((String)"java/lang/Short"), 4);
        _acceptedTypes.put(Integer.TYPE, 5);
        _acceptedTypes.put(ClassLiteral.getClass((String)"java/lang/Integer"), 5);
        _acceptedTypes.put(Long.TYPE, 6);
        _acceptedTypes.put(ClassLiteral.getClass((String)"java/lang/Long"), 6);
        _acceptedTypes.put(Float.TYPE, 7);
        _acceptedTypes.put(ClassLiteral.getClass((String)"java/lang/Float"), 7);
        _acceptedTypes.put(Double.TYPE, 8);
        _acceptedTypes.put(ClassLiteral.getClass((String)"java/lang/Double"), 8);
        _acceptedTypes.put(ClassLiteral.getClass((String)"java/lang/String"), 9);
    }
}

