/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.db.jdbc;

import com.caucho.db.jdbc.AbstractResultSet;
import com.caucho.db.jdbc.StatementImpl;
import com.caucho.db.sql.SelectResult;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;

public class ResultSetImpl
extends AbstractResultSet {
    private StatementImpl _stmt;
    private SelectResult _rs;
    private int _rowNumber;

    ResultSetImpl(StatementImpl stmt, SelectResult rs) {
        this._stmt = stmt;
        this._rs = rs;
    }

    public int getRow() throws SQLException {
        if (this._rowNumber < 0) {
            throw new SQLException("can't call getRow() after close()");
        }
        return this._rowNumber;
    }

    public boolean isBeforeFirst() throws SQLException {
        return this._rowNumber == 0;
    }

    public boolean isFirst() throws SQLException {
        return this._rowNumber == 1;
    }

    public Statement getStatement() throws SQLException {
        if (this._rowNumber < 0) {
            throw new SQLException("can't call getStatement() after close()");
        }
        return this._stmt;
    }

    public ResultSetMetaData getMetaData() throws SQLException {
        if (this._rowNumber < 0) {
            throw new SQLException("can't call getMetaData() after close()");
        }
        return null;
    }

    public boolean wasNull() throws SQLException {
        return this._rs.wasNull();
    }

    public boolean next() throws SQLException {
        if (this._rs == null) {
            return false;
        }
        if (this._rs.next()) {
            return true;
        }
        this.close();
        return false;
    }

    public int findColumn(String columnName) throws SQLException {
        return this._rs.findColumnIndex(columnName);
    }

    public boolean getBoolean(int columnIndex) throws SQLException {
        String s = this.getString(columnIndex);
        return s != null && !s.equals("") && !s.equals("0") && !s.equals("n");
    }

    public Date getDate(int columnIndex) throws SQLException {
        long date = this._rs.getDate(columnIndex - 1);
        if (this.wasNull()) {
            return null;
        }
        return new Date(date);
    }

    public double getDouble(int columnIndex) throws SQLException {
        return this._rs.getDouble(columnIndex - 1);
    }

    public int getInt(int columnIndex) throws SQLException {
        return this._rs.getInt(columnIndex - 1);
    }

    public long getLong(int columnIndex) throws SQLException {
        return this._rs.getLong(columnIndex - 1);
    }

    public String getString(int columnIndex) throws SQLException {
        return this._rs.getString(columnIndex - 1);
    }

    public Time getTime(int columnIndex) throws SQLException {
        long date = this._rs.getDate(columnIndex - 1);
        if (this.wasNull()) {
            return null;
        }
        return new Time(date);
    }

    public Timestamp getTimestamp(int columnIndex) throws SQLException {
        long date = this._rs.getDate(columnIndex - 1);
        if (this.wasNull()) {
            return null;
        }
        return new Timestamp(date);
    }

    public Blob getBlob(int columnIndex) throws SQLException {
        return this._rs.getBlob(columnIndex - 1);
    }

    public Clob getClob(int columnIndex) throws SQLException {
        return this._rs.getClob(columnIndex - 1);
    }

    public void close() throws SQLException {
        SelectResult result = this._rs;
        this._rs = null;
        if (result != null) {
            result.close();
        }
    }
}

