/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.db.sql;

import com.caucho.db.sql.ColumnExpr;
import com.caucho.db.sql.Expr;
import com.caucho.db.sql.FromItem;
import com.caucho.db.sql.Query;
import com.caucho.db.sql.QueryContext;
import com.caucho.db.sql.StringExpr;
import com.caucho.log.Log;
import com.rc.retroweaver.runtime.ClassLiteral;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.logging.Logger;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class BinaryEqExpr
extends Expr {
    private static final Logger log = Log.open(ClassLiteral.getClass((String)"com/caucho/db/sql/BinaryEqExpr"));
    private ColumnExpr _column;
    private byte[] _matchBuffer;

    BinaryEqExpr(ColumnExpr left, StringExpr right) {
        this._column = left;
        try {
            this._matchBuffer = right.getValue().getBytes("UTF8");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    protected Expr bind(Query query) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Class getType() {
        return Boolean.TYPE;
    }

    @Override
    public long subCost(ArrayList<FromItem> fromList) {
        return this._column.subCost(fromList);
    }

    @Override
    public int evalBoolean(QueryContext context) throws SQLException {
        if (this._column.isNull(context)) {
            return -1;
        }
        return this._column.evalEqual(context, this._matchBuffer) ? 1 : 0;
    }

    @Override
    public String evalString(QueryContext context) throws SQLException {
        throw new SQLException("can't convert string to boolean");
    }

    public String toString() {
        return new StringBuffer().append("(").append(this._column).append(" = byte[])").toString();
    }
}

