/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.db.sql;

import com.caucho.db.sql.BinaryLongExpr;
import com.caucho.db.sql.Expr;
import com.caucho.db.sql.FromItem;
import com.caucho.db.sql.Query;
import com.caucho.db.sql.QueryContext;
import com.caucho.log.Log;
import com.rc.retroweaver.runtime.ClassLiteral;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.logging.Logger;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class BinaryExpr
extends Expr {
    private static final Logger log = Log.open(ClassLiteral.getClass((String)"com/caucho/db/sql/BinaryExpr"));
    private Expr _left;
    private Expr _right;
    private int _op;

    BinaryExpr(Expr left, Expr right, int op) {
        this._left = left;
        this._right = right;
        this._op = op;
    }

    @Override
    protected Expr bind(Query query) throws SQLException {
        Expr newLeft = this._left.bind(query);
        Expr newRight = this._right.bind(query);
        switch (this._op) {
            case 37: 
            case 42: 
            case 43: 
            case 45: 
            case 47: {
                if (!newLeft.isLong() || !newRight.isLong()) break;
                return new BinaryLongExpr(newLeft, newRight, this._op);
            }
        }
        throw new SQLException(new StringBuffer().append("can't cope: ").append(newLeft).append(" ").append(newLeft.getType()).append(" ").append(newRight).toString());
    }

    @Override
    public long subCost(ArrayList<FromItem> fromList) {
        return this._left.subCost(fromList) + this._right.subCost(fromList);
    }

    @Override
    public Class getType() {
        return ClassLiteral.getClass((String)"java/lang/Object");
    }

    @Override
    public void evalGroup(QueryContext context) throws SQLException {
        this._left.evalGroup(context);
        this._right.evalGroup(context);
    }

    public String toString() {
        switch (this._op) {
            case 43: {
                return new StringBuffer().append("(").append(this._left).append(" + ").append(this._right).append(")").toString();
            }
            case 45: {
                return new StringBuffer().append("(").append(this._left).append(" - ").append(this._right).append(")").toString();
            }
            case 42: {
                return new StringBuffer().append("(").append(this._left).append(" * ").append(this._right).append(")").toString();
            }
            case 47: {
                return new StringBuffer().append("(").append(this._left).append(" / ").append(this._right).append(")").toString();
            }
            case 37: {
                return new StringBuffer().append("(").append(this._left).append(" % ").append(this._right).append(")").toString();
            }
        }
        throw new IllegalStateException("can't compare");
    }
}

