/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.db.sql;

import com.caucho.db.sql.DoubleCmpExpr;
import com.caucho.db.sql.Expr;
import com.caucho.db.sql.FromItem;
import com.caucho.db.sql.Query;
import com.caucho.db.sql.QueryContext;
import com.caucho.log.Log;
import com.rc.retroweaver.runtime.ClassLiteral;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.logging.Logger;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class CmpExpr
extends Expr {
    private static final Logger log = Log.open(ClassLiteral.getClass((String)"com/caucho/db/sql/CmpExpr"));
    private Expr _left;
    private Expr _right;
    private int _op;

    CmpExpr(Expr left, Expr right, int op) {
        this._left = left;
        this._right = right;
        this._op = op;
    }

    @Override
    protected Expr bind(Query query) throws SQLException {
        this._left = this._left.bind(query);
        this._right = this._right.bind(query);
        switch (this._op) {
            case 157: 
            case 158: 
            case 159: 
            case 160: {
                return new DoubleCmpExpr(this._op, this._left, this._right);
            }
        }
        if (this._left.isDouble() || this._right.isDouble()) {
            return new DoubleCmpExpr(this._op, this._left, this._right);
        }
        return this;
    }

    @Override
    public Class getType() {
        return Boolean.TYPE;
    }

    @Override
    public long subCost(ArrayList<FromItem> fromList) {
        return this._left.subCost(fromList) + this._right.subCost(fromList);
    }

    @Override
    public int evalBoolean(QueryContext context) throws SQLException {
        if (this._left.isNull(context) || this._right.isNull(context)) {
            return -1;
        }
        switch (this._op) {
            case 156: {
                String leftValue = this._left.evalString(context);
                String rightValue = this._right.evalString(context);
                if (!(leftValue == rightValue || leftValue != null && leftValue.equals(rightValue))) {
                    return 1;
                }
                return 0;
            }
            case 155: {
                String leftValue = this._left.evalString(context);
                String rightValue = this._right.evalString(context);
                if (leftValue == rightValue || leftValue != null && leftValue.equals(rightValue)) {
                    return 1;
                }
                return 0;
            }
        }
        throw new SQLException("can't compare");
    }

    @Override
    public String evalString(QueryContext context) throws SQLException {
        throw new SQLException("can't convert string to boolean");
    }

    @Override
    public void evalGroup(QueryContext context) throws SQLException {
        this._left.evalGroup(context);
        this._right.evalGroup(context);
    }

    public String toString() {
        return new StringBuffer().append("(").append(this._left).append(" = ").append(this._right).append(")").toString();
    }
}

