/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.db.sql;

import com.caucho.db.sql.ColumnExpr;
import com.caucho.db.sql.Expr;
import com.caucho.db.sql.FromItem;
import com.caucho.db.sql.IdExpr;
import com.caucho.db.sql.IndexExpr;
import com.caucho.db.sql.Query;
import com.caucho.db.sql.QueryContext;
import com.caucho.db.sql.StringEqExpr;
import com.caucho.db.sql.UnboundIdentifierExpr;
import com.caucho.log.Log;
import com.rc.retroweaver.runtime.ClassLiteral;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.logging.Logger;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class EqExpr
extends Expr {
    private static final Logger log = Log.open(ClassLiteral.getClass((String)"com/caucho/db/sql/EqExpr"));
    private Expr _left;
    private Expr _right;

    EqExpr(Expr left, Expr right) {
        this._left = left;
        this._right = right;
        if (left == null || right == null) {
            throw new NullPointerException();
        }
        if (right instanceof UnboundIdentifierExpr && !(left instanceof UnboundIdentifierExpr)) {
            Expr temp = this._right;
            this._right = this._left;
            this._left = temp;
        }
    }

    @Override
    protected Expr bind(Query query) throws SQLException {
        Expr newLeft = this._left.bind(query);
        Expr newRight = this._right.bind(query);
        if (newLeft instanceof ColumnExpr && newLeft.getType().equals(ClassLiteral.getClass((String)"java/lang/String"))) {
            return new StringEqExpr((ColumnExpr)newLeft, newRight);
        }
        if (newRight instanceof ColumnExpr && newRight.getType().equals(ClassLiteral.getClass((String)"java/lang/String"))) {
            return new StringEqExpr((ColumnExpr)newRight, newLeft);
        }
        if (this._left == newLeft && this._right == newRight) {
            return this;
        }
        return new EqExpr(newLeft, newRight);
    }

    @Override
    public IndexExpr getIndexExpr(FromItem item) {
        IdExpr expr;
        if (this._left instanceof IdExpr && (expr = (IdExpr)this._left).getColumn().getIndex() != null && item == expr.getFromItem()) {
            return new IndexExpr(expr, this._right);
        }
        if (this._right instanceof IdExpr && (expr = (IdExpr)this._right).getColumn().getIndex() != null && item == expr.getFromItem()) {
            return new IndexExpr(expr, this._left);
        }
        return null;
    }

    @Override
    public Class getType() {
        return Boolean.TYPE;
    }

    @Override
    public long cost(ArrayList<FromItem> fromList) {
        if (this._left instanceof UnboundIdentifierExpr && this._right.cost(fromList) == 0L) {
            UnboundIdentifierExpr id = (UnboundIdentifierExpr)this._left;
            return id.lookupCost(fromList);
        }
        if (this._right instanceof UnboundIdentifierExpr && this._left.cost(fromList) == 0L) {
            UnboundIdentifierExpr id = (UnboundIdentifierExpr)this._right;
            return id.lookupCost(fromList);
        }
        return this.subCost(fromList);
    }

    @Override
    public long subCost(ArrayList<FromItem> fromList) {
        return this._left.subCost(fromList) + this._right.subCost(fromList);
    }

    @Override
    public boolean isNull(QueryContext context) throws SQLException {
        return this._left.isNull(context) || this._right.isNull(context);
    }

    @Override
    public int evalBoolean(QueryContext context) throws SQLException {
        String rightValue;
        if (this._left.isNull(context) || this._right.isNull(context)) {
            return -1;
        }
        if (this._left.isLong() && this._right.isLong()) {
            if (this._left.evalLong(context) == this._right.evalLong(context)) {
                return 1;
            }
            return 0;
        }
        if (this._left.isDouble() && this._right.isDouble()) {
            if (this._left.evalDouble(context) == this._right.evalDouble(context)) {
                return 1;
            }
            return 0;
        }
        String leftValue = this._left.evalString(context);
        if (leftValue == (rightValue = this._right.evalString(context)) || leftValue.equals(rightValue)) {
            return 1;
        }
        return 0;
    }

    @Override
    public String evalString(QueryContext context) throws SQLException {
        throw new SQLException("can't convert string to boolean");
    }

    @Override
    public void evalGroup(QueryContext context) throws SQLException {
        this._left.evalGroup(context);
        this._right.evalGroup(context);
    }

    public String toString() {
        return new StringBuffer().append("(").append(this._left).append(" = ").append(this._right).append(")").toString();
    }
}

