/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.db.sql;

import com.caucho.db.sql.Expr;
import com.caucho.db.sql.FromItem;
import com.caucho.db.sql.Query;
import com.caucho.db.sql.QueryContext;
import com.caucho.db.sql.SetItem;
import com.caucho.db.store.Transaction;
import com.caucho.db.table.Column;
import com.caucho.db.table.Table;
import com.caucho.db.table.TableIterator;
import com.caucho.log.Log;
import com.caucho.util.CharBuffer;
import com.rc.retroweaver.runtime.ClassLiteral;
import java.sql.SQLException;
import java.util.logging.Logger;

class UpdateQuery
extends Query {
    private static final Logger log = Log.open(ClassLiteral.getClass((String)"com/caucho/db/sql/UpdateQuery"));
    private final Table _table;
    private SetItem[] _setItems;

    UpdateQuery(String sql, Table table) throws SQLException {
        super(sql, null);
        this._table = table;
        this.setFromItems(new FromItem[]{new FromItem(table, table.getName())});
    }

    public void setSetItems(SetItem[] setItems) {
        this._setItems = setItems;
    }

    protected void bind() throws SQLException {
        super.bind();
        for (int i = 0; i < this._setItems.length; ++i) {
            Expr expr = this._setItems[i].getExpr();
            expr = expr.bind(this);
            this._setItems[i].setExpr(expr);
        }
    }

    public void execute(QueryContext context, Transaction xa) throws SQLException {
        int count = 0;
        SetItem[] setItems = this._setItems;
        TableIterator[] rows = new TableIterator[]{this._table.createTableIterator()};
        context.init(xa, rows);
        if (!this.start(rows, rows.length, context, xa)) {
            return;
        }
        do {
            for (int i = 0; i < setItems.length; ++i) {
                Column column = setItems[i].getColumn();
                Expr expr = setItems[i].getExpr();
                TableIterator iter = rows[0];
                xa.lockWrite(iter.getTable().getLock());
                column.set(xa, iter, expr, context);
            }
            context.setRowUpdateCount(++count);
        } while (this.nextTuple(rows, rows.length, context, xa));
    }

    public String toString() {
        CharBuffer cb = CharBuffer.allocate();
        cb.append("UpdateQuery[");
        if (this._whereExpr != null) {
            cb.append(",where:" + this._whereExpr);
        }
        cb.append("]");
        return cb.close();
    }
}

