/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.db.table;

import com.caucho.db.store.Block;
import com.caucho.db.store.Store;
import com.caucho.db.store.Transaction;
import com.caucho.vfs.TempBuffer;
import java.io.IOException;
import java.io.OutputStream;

class BlobOutputStream
extends OutputStream {
    private Store _store;
    private Transaction _xa;
    private TempBuffer _tempBuffer;
    private byte[] _buffer;
    private int _offset;
    private int _bufferEnd;
    private long _length;
    private byte[] _inode;
    private int _inodeOffset;
    private int _blockCount;

    BlobOutputStream(Transaction xa, Store store, byte[] inode, int inodeOffset) {
        this.init(xa, store, inode, inodeOffset);
    }

    public void init(Transaction xa, Store store, byte[] inode, int inodeOffset) {
        this._xa = xa;
        this._store = store;
        this._length = 0L;
        this._inode = inode;
        this._inodeOffset = inodeOffset;
        this._blockCount = 0;
        this._offset = 0;
        this._tempBuffer = TempBuffer.allocate();
        this._buffer = this._tempBuffer.getBuffer();
        this._bufferEnd = this._buffer.length;
    }

    public void write(int v) throws IOException {
        if (this._bufferEnd <= this._offset) {
            this.flushBlock();
        }
        this._buffer[this._offset++] = (byte)v;
        ++this._length;
    }

    public void write(byte[] buffer, int offset, int length) throws IOException {
        while (length > 0) {
            int sublen;
            if (this._bufferEnd <= this._offset) {
                this.flushBlock();
            }
            if (length < (sublen = this._bufferEnd - this._offset)) {
                sublen = length;
            }
            System.arraycopy(buffer, offset, this._buffer, this._offset, sublen);
            offset += sublen;
            this._offset += sublen;
            length -= sublen;
            this._length += (long)sublen;
        }
    }

    private void flushBlock() throws IOException {
        if (32768 < this._offset) {
            Block block = this._store.allocate();
            byte[] blockBuffer = block.getBuffer();
            System.arraycopy(this._buffer, 0, blockBuffer, 0, blockBuffer.length);
            long blockId = block.getBlockId();
            block.write();
            block.free();
            this.writeBlockAddr(this._blockCount++, Store.blockIdToAddress(blockId, 0));
        } else if (this._blockCount == 0 && this._offset <= 120) {
            System.arraycopy(this._buffer, 0, this._inode, this._inodeOffset + 8, this._offset);
        } else {
            long blockAddr = this._store.writeFragment(this._buffer, 0, this._offset);
            this.writeBlockAddr(this._blockCount++, blockAddr);
        }
        this._offset = 0;
    }

    private void writeBlockAddr(int count, long id) {
        if (count >= 15) {
            throw new IllegalStateException();
        }
        BlobOutputStream.writeLong(this._inode, this._inodeOffset + (count + 1) * 8, id);
    }

    public void close() throws IOException {
        BlobOutputStream.writeLong(this._inode, this._inodeOffset, this._length);
        this.flushBlock();
        TempBuffer.free(this._tempBuffer);
    }

    private static void writeLong(byte[] buffer, int offset, long v) {
        buffer[offset + 0] = (byte)(v >> 56);
        buffer[offset + 1] = (byte)(v >> 48);
        buffer[offset + 2] = (byte)(v >> 40);
        buffer[offset + 3] = (byte)(v >> 32);
        buffer[offset + 4] = (byte)(v >> 24);
        buffer[offset + 5] = (byte)(v >> 16);
        buffer[offset + 6] = (byte)(v >> 8);
        buffer[offset + 7] = (byte)v;
    }

    private static long readLong(byte[] buffer, int offset) {
        return ((long)buffer[offset + 0] & 0xFFL) << 56 | ((long)buffer[offset + 1] & 0xFFL) << 48 | ((long)buffer[offset + 2] & 0xFFL) << 40 | ((long)buffer[offset + 3] & 0xFFL) << 32 | ((long)buffer[offset + 4] & 0xFFL) << 24 | ((long)buffer[offset + 4] & 0xFFL) << 16 | ((long)buffer[offset + 4] & 0xFFL) << 8 | (long)buffer[offset + 4] & 0xFFL;
    }

    private static void writeShort(byte[] buffer, int offset, short v) {
        buffer[offset + 0] = (byte)(v >> 8);
        buffer[offset + 1] = (byte)v;
    }

    private static int readShort(byte[] buffer, int offset) {
        return (buffer[offset + 0] & 0xFF) << 8 | buffer[offset + 1] & 0xFF;
    }
}

