/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.db.table;

import com.caucho.db.store.Block;
import com.caucho.db.store.Store;
import com.caucho.log.Log;
import com.rc.retroweaver.runtime.ClassLiteral;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Inode {
    private static final Logger log = Log.open(ClassLiteral.getClass((String)"com/caucho/db/table/Inode"));
    private Store _store;
    private long _length;
    private long[] _addr = new long[15];

    void init(Store store, byte[] buffer, int offset) {
        this._store = store;
        this._length = Inode.readLong(buffer, offset);
        for (int i = 0; i < this._addr.length; ++i) {
            this._addr[i] = Inode.readLong(buffer, offset + 8 * (i + 1));
        }
    }

    public void delete() {
        if (this._length <= 120L) {
            return;
        }
        try {
            long length;
            int count = 0;
            for (length = this._length; 65536L <= length; length -= 65536L) {
                this._store.setAllocation(this._addr[count] >> 16, 0);
                ++count;
            }
            if (count > 0) {
                this._store.saveAllocation();
            }
            if (length > 0L) {
                int i;
                long addr = this._addr[count];
                int fragmentId = (int)(addr & 0xFFFFL);
                Block fragment = this._store.readBlock(this._store.addressToBlockId(this._addr[count]));
                byte[] buffer = fragment.getBuffer();
                int offset = Inode.readShort(buffer, fragmentId);
                int sublen = Inode.readShort(buffer, fragmentId + 2);
                Inode.writeShort(buffer, fragmentId, 0);
                Inode.writeShort(buffer, fragmentId + 2, 0);
                for (i = offset; i < buffer.length - sublen; ++i) {
                    buffer[i] = buffer[i + sublen];
                }
                for (i = 4; i < 1024; i += 4) {
                    int subOffset = Inode.readShort(buffer, i);
                    if (offset >= subOffset) continue;
                    Inode.writeShort(buffer, i, subOffset - sublen);
                }
                Inode.writeShort(buffer, 0, Inode.readShort(buffer, 0) - sublen);
                fragment.write();
                fragment.free();
            }
        }
        catch (Exception e) {
            log.log(Level.WARNING, e.toString(), e);
        }
    }

    static long readLong(byte[] buffer, int offset) {
        return (((long)buffer[offset + 0] & 0xFFL) << 56) + (((long)buffer[offset + 1] & 0xFFL) << 48) + (((long)buffer[offset + 2] & 0xFFL) << 40) + (((long)buffer[offset + 3] & 0xFFL) << 32) + (((long)buffer[offset + 4] & 0xFFL) << 24) + (((long)buffer[offset + 5] & 0xFFL) << 16) + (((long)buffer[offset + 6] & 0xFFL) << 8) + ((long)buffer[offset + 7] & 0xFFL);
    }

    private static int readShort(byte[] buffer, int offset) {
        return ((buffer[offset + 0] & 0xFF) << 8) + (buffer[offset + 1] & 0xFF);
    }

    private static void writeShort(byte[] buffer, int offset, int v) {
        buffer[offset + 0] = (byte)(v >> 8);
        buffer[offset + 1] = (byte)v;
    }
}

