/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.db.table;

import com.caucho.db.Database;
import com.caucho.db.sql.Expr;
import com.caucho.db.table.BigStringColumn;
import com.caucho.db.table.BlobColumn;
import com.caucho.db.table.Column;
import com.caucho.db.table.Constraint;
import com.caucho.db.table.DateColumn;
import com.caucho.db.table.DoubleColumn;
import com.caucho.db.table.IntColumn;
import com.caucho.db.table.LongColumn;
import com.caucho.db.table.PrimaryKeyConstraint;
import com.caucho.db.table.PrimaryKeySingleColumnConstraint;
import com.caucho.db.table.Row;
import com.caucho.db.table.StringColumn;
import com.caucho.db.table.Table;
import com.caucho.db.table.UniqueConstraint;
import com.caucho.db.table.UniqueSingleColumnConstraint;
import com.caucho.util.L10N;
import com.rc.retroweaver.runtime.ClassLiteral;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TableFactory {
    private static final L10N L = new L10N(ClassLiteral.getClass((String)"com/caucho/db/table/TableFactory"));
    private Database _database;
    private String _name;
    private Row _row;
    private ArrayList<Constraint> _constraints = new ArrayList();

    public TableFactory(Database database) {
        this._database = database;
    }

    public String getName() {
        return this._name;
    }

    public Row getRow() {
        return this._row;
    }

    public void startTable(String name) {
        this._name = name;
        this._row = new Row();
    }

    public Column addVarchar(String name, int size) {
        this._row.allocateColumn();
        if (size <= 128) {
            return this._row.addColumn(new StringColumn(this._row, name, size));
        }
        return this._row.addColumn(new BigStringColumn(this._row, name, size));
    }

    public Column addBlob(String name) {
        this._row.allocateColumn();
        return this._row.addColumn(new BlobColumn(this._row, name));
    }

    public Column addInteger(String name) {
        this._row.allocateColumn();
        return this._row.addColumn(new IntColumn(this._row, name));
    }

    public Column addLong(String name) {
        this._row.allocateColumn();
        return this._row.addColumn(new LongColumn(this._row, name));
    }

    public Column addDouble(String name) {
        this._row.allocateColumn();
        return this._row.addColumn(new DoubleColumn(this._row, name));
    }

    public Column addDateTime(String name) {
        this._row.allocateColumn();
        return this._row.addColumn(new DateColumn(this._row, name));
    }

    public void setPrimaryKey(String name) throws SQLException {
        Column column = this._row.getColumn(name);
        if (column == null) {
            throw new SQLException(L.l("`{0}' is not a valid column for primary key", name));
        }
        column.setUnique();
        column.setNotNull();
        this.addConstraint(new PrimaryKeySingleColumnConstraint(column));
    }

    public void setNotNull(String name) throws SQLException {
        Column column = this._row.getColumn(name);
        if (column == null) {
            throw new SQLException(L.l("`{0}' is not a valid column for NOT NULL", name));
        }
        column.setNotNull();
    }

    public void setDefault(String name, Expr expr) throws SQLException {
        Column column = this._row.getColumn(name);
        if (column == null) {
            throw new SQLException(L.l("`{0}' is not a valid column for DEFAULT", name));
        }
        column.setDefault(expr);
    }

    public void setUnique(String name) throws SQLException {
        Column column = this._row.getColumn(name);
        if (column == null) {
            throw new SQLException(L.l("`{0}' is not a valid column for NOT NULL", name));
        }
        column.setUnique();
        this.addConstraint(new UniqueSingleColumnConstraint(column));
    }

    public void setAutoIncrement(String name, int min) throws SQLException {
        Column column = this._row.getColumn(name);
        if (column == null) {
            throw new SQLException(L.l("`{0}' is not a valid column for auto_increment", name));
        }
        column.setAutoIncrement(min);
    }

    public void addUnique(ArrayList<String> names) throws SQLException {
        if (names.size() == 1) {
            this.setUnique(names.get(0));
            return;
        }
        ArrayList columns = new ArrayList();
        for (int i = 0; i < names.size(); ++i) {
            String name = names.get(i);
            Column column = this._row.getColumn(name);
            if (column != null) continue;
            throw new SQLException(L.l("`{0}' is not a valid column for UNIQUE", name));
        }
        Column[] columnArray = new Column[columns.size()];
        columns.toArray(columnArray);
        if (columnArray.length == 1) {
            this.addConstraint(new UniqueSingleColumnConstraint(columnArray[0]));
        } else {
            this.addConstraint(new UniqueConstraint(columnArray));
        }
    }

    public void addPrimaryKey(ArrayList<String> names) throws SQLException {
        if (names.size() == 1) {
            this.setPrimaryKey(names.get(0));
            return;
        }
        ArrayList columns = new ArrayList();
        for (int i = 0; i < names.size(); ++i) {
            String name = names.get(i);
            Column column = this._row.getColumn(name);
            if (column != null) continue;
            throw new SQLException(L.l("`{0}' is not a valid column for PRIMARY KEY", name));
        }
        Column[] columnArray = new Column[columns.size()];
        columns.toArray(columnArray);
        if (columnArray.length == 1) {
            this.addConstraint(new PrimaryKeySingleColumnConstraint(columnArray[0]));
        } else {
            this.addConstraint(new PrimaryKeyConstraint(columnArray));
        }
    }

    public void addConstraint(Constraint constraint) {
        this._constraints.add(constraint);
    }

    public Constraint[] getConstraints() {
        Constraint[] constraints = new Constraint[this._constraints.size()];
        this._constraints.toArray(constraints);
        return constraints;
    }

    public void create() throws SQLException, IOException {
        Table table = new Table(this._database, this._name, this._row, this.getConstraints());
        table.create();
    }
}

