/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.ejb;

import com.caucho.config.ConfigException;
import com.caucho.config.types.JndiBuilder;
import com.caucho.config.types.Period;
import com.caucho.ejb.EJBServerInterface;
import com.caucho.ejb.EjbServerManager;
import com.caucho.ejb.entity2.EntityIntrospector;
import com.caucho.ejb.metadata.Bean;
import com.caucho.ejb.protocol.ProtocolContainer;
import com.caucho.loader.Environment;
import com.caucho.loader.EnvironmentBean;
import com.caucho.loader.EnvironmentClassLoader;
import com.caucho.loader.EnvironmentListener;
import com.caucho.loader.EnvironmentLocal;
import com.caucho.log.Log;
import com.caucho.naming.AbstractModel;
import com.caucho.naming.ContextImpl;
import com.caucho.naming.Jndi;
import com.caucho.naming.ObjectProxy;
import com.caucho.util.CauchoSystem;
import com.caucho.util.L10N;
import com.caucho.vfs.JarPath;
import com.caucho.vfs.MergePath;
import com.caucho.vfs.Path;
import com.caucho.vfs.Vfs;
import com.rc.retroweaver.runtime.ClassLiteral;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jms.ConnectionFactory;
import javax.naming.NamingException;
import javax.sql.DataSource;

public class EJBServer
implements ObjectProxy,
EnvironmentListener,
EJBServerInterface,
EnvironmentBean {
    static final L10N L = new L10N(ClassLiteral.getClass((String)"com/caucho/ejb/EJBServer"));
    protected static final Logger log = Log.open(ClassLiteral.getClass((String)"com/caucho/ejb/EJBServer"));
    protected static EnvironmentLocal<String> _localURL = new EnvironmentLocal("caucho.url");
    protected static EnvironmentLocal<EjbServerManager> _localServer = new EnvironmentLocal("caucho.ejb-server");
    private String _jndiName = "java:comp/env/cmp";
    private EjbServerManager _ejbManager;
    private AbstractModel _rootModel;
    private ArrayList<Path> _descriptors;
    private ArrayList<Path> _ejbJars = new ArrayList();
    private EntityIntrospector _entityIntrospector;
    private MergePath _mergePath;
    private String _urlPrefix;
    private Path _ejbConfigDir;
    private DataSource _dataSource;
    private boolean _createDatabaseSchema;
    private boolean _validateDatabaseSchema = true;
    private boolean _entityLoadLazyOnTransaction = true;
    private String _resinIsolation;
    private String _jdbcIsolation;
    private ConnectionFactory _jmsConnectionFactory;
    private int _entityCacheSize = 32768;
    private long _entityCacheTimeout = 5000L;
    private boolean _forbidJVMCall;
    private boolean _autoCompile = true;
    private boolean _isAllowPOJO = false;
    private String _startupMode;
    private long _transactionTimeout = 0L;

    public EJBServer() throws ConfigException {
        this._ejbManager = EjbServerManager.createLocal();
        _localServer.set(this._ejbManager);
        this._rootModel = this._ejbManager.getProtocolManager().getNamingRoot();
        this._urlPrefix = _localURL.get();
        this._mergePath = new MergePath();
        this._mergePath.addMergePath(Vfs.lookup());
        this._mergePath.addClassPath();
        this._entityIntrospector = new EntityIntrospector(this._ejbManager);
    }

    public static EjbServerManager getLocalManager() {
        return _localServer.get();
    }

    public EnvironmentClassLoader getClassLoader() {
        return this._ejbManager.getClassLoader();
    }

    public void setEnvironmentClassLoader(EnvironmentClassLoader env) {
    }

    public void setName(String name) {
        this.setJndiName(name);
    }

    public void setJndiName(String name) {
        this._jndiName = name;
    }

    public String getJndiName() {
        return this._jndiName;
    }

    public void setURLPrefix(String urlPrefix) {
        this._urlPrefix = urlPrefix;
    }

    public String getURLPrefix() {
        return this._urlPrefix;
    }

    public void setConfigDirectory(Path dir) {
        this._ejbConfigDir = dir;
    }

    public Path getConfigDirectory() {
        return this._ejbConfigDir;
    }

    public void addEJBDescriptor(String ejbDescriptor) {
        if (this._descriptors == null) {
            this._descriptors = new ArrayList();
        }
        Path path = this._mergePath.lookup(ejbDescriptor);
        this._descriptors.add(path);
    }

    public void addEJBJar(Path ejbJar) throws ConfigException {
        if (!ejbJar.canRead() || !ejbJar.isFile()) {
            throw new ConfigException(L.l("<ejb-jar> {0} must refer to a valid jar file.", ejbJar.getURL()));
        }
        this._ejbJars.add(ejbJar);
    }

    public Bean createBean() {
        return new Bean(this._ejbManager, this._entityIntrospector);
    }

    public void addBean(Bean bean) {
    }

    public void setDataSource(DataSource dataSource) throws ConfigException {
        this._dataSource = dataSource;
        if (this._dataSource == null) {
            throw new ConfigException(L.l("<ejb-server> data-source must be a valid DataSource."));
        }
        this._ejbManager.setDataSource(this._dataSource);
    }

    public void setCreateDatabaseSchema(boolean create) {
        this._createDatabaseSchema = create;
    }

    public boolean getCreateDatabaseSchema() {
        return this._createDatabaseSchema;
    }

    public void setValidateDatabaseSchema(boolean validate) {
        this._validateDatabaseSchema = validate;
    }

    public boolean getValidateDatabaseSchema() {
        return this._validateDatabaseSchema;
    }

    public void setLoadLazyOnTransaction(boolean isLazy) {
        this._ejbManager.setEntityLoadLazyOnTransaction(isLazy);
    }

    public void setJMSConnectionFactory(JndiBuilder factory) throws ConfigException, NamingException {
        Object obj = factory.getObject();
        if (!(obj instanceof ConnectionFactory)) {
            throw new ConfigException(L.l("`{0}' must be a JMS ConnectionFactory.", obj));
        }
        this._jmsConnectionFactory = (ConnectionFactory)obj;
    }

    public ConnectionFactory getConnectionFactory() {
        return this._jmsConnectionFactory;
    }

    public int getEntityCacheSize() {
        return this._entityCacheSize;
    }

    public void setCacheSize(int size) {
        this._entityCacheSize = size;
    }

    public long getEntityCacheTimeout() {
        return this._entityCacheTimeout;
    }

    public void setCacheTimeout(Period timeout) {
        this._entityCacheTimeout = timeout.getPeriod();
    }

    public long getTransactionTimeout() {
        return this._transactionTimeout;
    }

    public void setTransactionTimeout(Period timeout) {
        this._transactionTimeout = timeout.getPeriod();
    }

    public String getResinIsolation() {
        return this._resinIsolation;
    }

    public void setResinIsolation(String resinIsolation) {
        this._resinIsolation = resinIsolation;
    }

    public String getJdbcIsolation() {
        return this._jdbcIsolation;
    }

    public void setJdbcIsolation(String jdbcIsolation) {
        this._jdbcIsolation = jdbcIsolation;
    }

    public void setForbidJvmCall(boolean forbid) {
        this._forbidJVMCall = forbid;
    }

    public boolean isAutoCompile() {
        return this._autoCompile;
    }

    public void setAutoCompile(boolean autoCompile) {
        this._autoCompile = autoCompile;
    }

    public boolean isAllowPOJO() {
        return this._isAllowPOJO;
    }

    public void setAllowPOJO(boolean allowPOJO) {
        this._isAllowPOJO = allowPOJO;
    }

    public void setStartupMode(String startupMode) {
        this._startupMode = startupMode;
    }

    public void init() throws Exception {
        String name = this._jndiName;
        if (!name.startsWith("java:")) {
            name = "java:comp/env/" + name;
        }
        try {
            Jndi.rebindDeep(name, this);
        }
        catch (NamingException e) {
            log.log(Level.FINER, e.toString(), e);
        }
        if ("manual".equals(this._startupMode)) {
            return;
        }
        this.manualInit();
    }

    public void manualInit() throws Exception {
        try {
            log.fine("Initializing ejb-server : " + this._jndiName);
            ProtocolContainer protocol = new ProtocolContainer();
            if (this._urlPrefix != null) {
                protocol.setURLPrefix(this._urlPrefix);
            }
            protocol.setServerManager(this._ejbManager);
            this._ejbManager.getProtocolManager().setProtocolContainer(protocol);
            this._ejbManager.setDataSource(this._dataSource);
            this._ejbManager.setCreateDatabaseSchema(this._createDatabaseSchema);
            this._ejbManager.setValidateDatabaseSchema(this._validateDatabaseSchema);
            this._ejbManager.setJMSConnectionFactory(this._jmsConnectionFactory);
            this._ejbManager.setCacheSize(this._entityCacheSize);
            this._ejbManager.setCacheTimeout(this._entityCacheTimeout);
            this._ejbManager.setTransactionTimeout(this._transactionTimeout);
            this._ejbManager.setAllowJVMCall(!this._forbidJVMCall);
            this._ejbManager.setAutoCompile(this._autoCompile);
            this._ejbManager.setAllowPOJO(this.isAllowPOJO());
            int resinIsolation = -1;
            if (this._resinIsolation != null) {
                if (this._resinIsolation.equals("row-locking")) {
                    resinIsolation = 2;
                } else if (this._resinIsolation.equals("database")) {
                    resinIsolation = 0;
                } else {
                    throw new ConfigException(L.l("resin-isolation may only be `row-locking' or `database' in EJBServer, not `{0}'", this._resinIsolation));
                }
            }
            this._ejbManager.setResinIsolation(resinIsolation);
            int jdbcIsolation = -1;
            if (this._jdbcIsolation != null) {
                if (this._jdbcIsolation.equals("none")) {
                    jdbcIsolation = 0;
                } else if (this._jdbcIsolation.equals("read-committed")) {
                    jdbcIsolation = 2;
                } else if (this._jdbcIsolation.equals("read-uncommitted")) {
                    jdbcIsolation = 1;
                } else if (this._jdbcIsolation.equals("repeatable-read")) {
                    jdbcIsolation = 4;
                } else if (this._jdbcIsolation.equals("serializable")) {
                    jdbcIsolation = 8;
                } else {
                    throw new ConfigException(L.l("unknown value for jdbc-isolation at `{0}'", this._jdbcIsolation));
                }
            }
            this._ejbManager.setJDBCIsolation(jdbcIsolation);
            this._entityIntrospector.init();
            this.initAllEjbs();
            this._ejbManager.init();
            Environment.addEnvironmentListener(this);
        }
        catch (Exception e) {
            log.log(Level.WARNING, e.toString(), e);
            throw e;
        }
    }

    public void initEJBs() throws Exception {
        this.manualInit();
    }

    private void initAllEjbs() throws Exception {
        MergePath mergePath = new MergePath();
        if (this._ejbConfigDir != null) {
            mergePath.addMergePath(this._ejbConfigDir);
        }
        mergePath.addClassPath();
        mergePath.addMergePath(CauchoSystem.getWorkPath());
        this.addEJBJars();
        if (this._descriptors != null) {
            for (int i = 0; i < this._descriptors.size(); ++i) {
                Path path = this._descriptors.get(i);
                this._ejbManager.addEJBPath(path);
            }
        }
        if (this._ejbConfigDir != null) {
            Path dir = this._ejbConfigDir;
            String userPath = dir.getUserPath();
            if (!userPath.endsWith("/") && !userPath.equals("")) {
                userPath = userPath + "/";
            }
            String[] list = dir.list();
            for (int j = 0; j < list.length; ++j) {
                String name = list[j];
                if (!name.endsWith(".ejb")) continue;
                Path path = dir.lookup(name);
                path.setUserPath(userPath + name);
                if (!path.exists()) continue;
                this._ejbManager.addEJBPath(path);
            }
        }
    }

    private void addEJBJars() throws Exception {
        for (int i = 0; i < this._ejbJars.size(); ++i) {
            Path metaInf;
            Path path = this._ejbJars.get(i);
            Environment.addDependency(path);
            JarPath jar = JarPath.create(path);
            Path descriptorPath = jar.lookup("META-INF/ejb-jar.xml");
            if (descriptorPath.exists()) {
                this._ejbManager.addEJBPath(descriptorPath);
            }
            if (!(metaInf = jar.lookup("META-INF")).isDirectory()) continue;
            String[] metaList = metaInf.list();
            for (int j = 0; j < metaList.length; ++j) {
                String metaName = metaList[j];
                if (!metaName.endsWith(".ejb")) continue;
                Path metaPath = metaInf.lookup(metaName);
                this._ejbManager.addEJBPath(metaPath);
            }
        }
    }

    public Object createObject(Hashtable env) {
        return new ContextImpl(this._rootModel, env);
    }

    public void environmentStart(EnvironmentClassLoader loader) {
    }

    public void environmentStop(EnvironmentClassLoader loader) {
        this.close();
    }

    public void close() {
        this._ejbManager.destroy();
    }
}

