/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.ejb.burlap;

import com.caucho.config.ConfigException;
import com.caucho.ejb.AbstractServer;
import com.caucho.ejb.burlap.BurlapHandleEncoder;
import com.caucho.ejb.burlap.BurlapSkeleton;
import com.caucho.ejb.burlap.BurlapSkeletonGenerator;
import com.caucho.ejb.burlap.BurlapStubFactory;
import com.caucho.ejb.burlap.ExceptionSkeleton;
import com.caucho.ejb.burlap.MessageSkeleton;
import com.caucho.ejb.burlap.NameContextSkeleton;
import com.caucho.ejb.message.MessageServer;
import com.caucho.ejb.protocol.HandleEncoder;
import com.caucho.ejb.protocol.ProtocolContainer;
import com.caucho.ejb.protocol.Skeleton;
import com.caucho.hessian.io.HessianRemoteResolver;
import com.caucho.util.L10N;
import com.caucho.util.Log;
import com.rc.retroweaver.runtime.ClassLiteral;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.logging.Logger;
import javax.ejb.EJBHome;
import javax.ejb.EJBObject;

public class BurlapProtocol
extends ProtocolContainer {
    private static final L10N L = new L10N(ClassLiteral.getClass((String)"com/caucho/ejb/burlap/BurlapProtocol"));
    private static final Logger log = Log.open(ClassLiteral.getClass((String)"com/caucho/ejb/burlap/BurlapProtocol"));
    private Class _objectSkelClass;
    private Class _homeSkelClass;
    private HashMap<AbstractServer, Class> _homeSkeletonMap = new HashMap();
    private HashMap<AbstractServer, Class> _objectSkeletonMap = new HashMap();
    private HashMap<String, AbstractServer> _serverMap = new HashMap();
    private HessianRemoteResolver _resolver = new BurlapStubFactory();

    public String getName() {
        return "burlap";
    }

    public void addServer(AbstractServer server) {
        log.finer("Burlap[" + server + "] added");
        this._serverMap.put(server.getEJBName(), server);
    }

    public void removeServer(AbstractServer server) {
        this._serverMap.remove(server.getEJBName());
    }

    protected HandleEncoder createHandleEncoder(AbstractServer server, Class primaryKeyClass) throws ConfigException {
        return new BurlapHandleEncoder(server, this.getURLPrefix() + server.getEJBName(), primaryKeyClass);
    }

    public Skeleton getSkeleton(String uri, String queryString) throws Exception {
        AbstractServer server;
        String serverId = uri;
        String objectId = null;
        if (queryString != null) {
            int p = queryString.indexOf(61);
            objectId = p >= 0 ? queryString.substring(p + 1) : queryString;
        }
        if ((server = this.getProtocolManager().getServerByEJBName(serverId)) == null) {
            ArrayList<String> children = this.getProtocolManager().getRemoteChildren(serverId);
            if (children != null && children.size() > 0) {
                return new NameContextSkeleton(this, serverId);
            }
            return null;
        }
        if (objectId != null) {
            Object key = server.getHandleEncoder("burlap").objectIdToKey(objectId);
            EJBObject obj = server.getContext(key, false).getRemoteView();
            Class objectSkelClass = this.getObjectSkelClass(server);
            BurlapSkeleton skel = (BurlapSkeleton)objectSkelClass.newInstance();
            skel._setServer(server);
            skel._setResolver(this._resolver);
            skel._setObject(obj);
            return skel;
        }
        if (server instanceof MessageServer) {
            return new MessageSkeleton((MessageServer)server);
        }
        Object remote = server.getRemoteObject();
        if (remote instanceof EJBHome) {
            Class homeSkelClass = this.getHomeSkelClass(server);
            BurlapSkeleton skel = (BurlapSkeleton)homeSkelClass.newInstance();
            skel._setServer(server);
            skel._setResolver(this._resolver);
            skel._setObject(remote);
            return skel;
        }
        if (remote instanceof EJBObject) {
            Class skelClass = this.getObjectSkelClass(server);
            BurlapSkeleton skel = (BurlapSkeleton)skelClass.newInstance();
            skel._setServer(server);
            skel._setResolver(this._resolver);
            skel._setObject(remote);
            return skel;
        }
        return null;
    }

    public Skeleton getExceptionSkeleton() throws Exception {
        return new ExceptionSkeleton();
    }

    protected Class getHomeSkelClass(AbstractServer server) throws Exception {
        Class homeSkelClass = this._homeSkeletonMap.get(server);
        if (homeSkelClass != null) {
            return homeSkelClass;
        }
        Class remoteHomeClass = server.getRemoteHomeClass();
        homeSkelClass = BurlapSkeletonGenerator.generate(remoteHomeClass, this.getWorkPath());
        this._homeSkeletonMap.put(server, homeSkelClass);
        return homeSkelClass;
    }

    protected Class getObjectSkelClass(AbstractServer server) throws Exception {
        Class objectSkelClass = this._objectSkeletonMap.get(server);
        if (objectSkelClass != null) {
            return objectSkelClass;
        }
        Class remoteObjectClass = server.getRemoteObjectClass();
        objectSkelClass = BurlapSkeletonGenerator.generate(remoteObjectClass, this.getWorkPath());
        this._objectSkeletonMap.put(server, objectSkelClass);
        return objectSkelClass;
    }
}

