/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.ejb.burlap;

import com.caucho.burlap.io.BurlapInput;
import com.caucho.burlap.io.BurlapOutput;
import com.caucho.ejb.AbstractServer;
import com.caucho.ejb.burlap.BurlapWriter;
import com.caucho.ejb.message.MessageServer;
import com.caucho.ejb.protocol.Skeleton;
import com.caucho.log.Log;
import com.caucho.services.message.MessageSender;
import com.caucho.util.CharBuffer;
import com.rc.retroweaver.runtime.ClassLiteral;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageProducer;
import javax.jms.Session;

public class MessageSkeleton
extends Skeleton {
    protected static Logger log = Log.open(ClassLiteral.getClass((String)"com/caucho/ejb/burlap/MessageSkeleton"));
    protected MessageServer _server;
    protected Connection _connection;
    protected Destination _destination;
    protected Session _session;
    protected MessageProducer _sender;

    MessageSkeleton(MessageServer server) throws JMSException {
        this._server = server;
        this._destination = server.getDestination();
        this._connection = server.getJMSConnection();
        this._session = this._connection.createSession(false, 1);
        this._sender = this._session.createProducer(server.getDestination());
    }

    void _setServer(AbstractServer server) {
        this._server = (MessageServer)server;
    }

    protected void _setObject(Object obj) {
    }

    public void _service(InputStream rawIs, OutputStream rawOs) throws Exception {
        BurlapInput in = new BurlapInput(rawIs);
        BurlapWriter out = new BurlapWriter(rawOs);
        try {
            in.startCall();
            String method = in.getMethod();
            if (!"send".equals(method)) {
                throw new IOException("no such method: " + method);
            }
            HashMap headers = (HashMap)in.readObject();
            Object data = in.readObject();
            in.completeCall();
            if (this._destination instanceof MessageSender) {
                ((MessageSender)this._destination).send(headers, data);
            } else {
                Object message = null;
                message = data instanceof String ? this._session.createTextMessage((String)data) : this._session.createObjectMessage((Serializable)data);
                this._sender.send((Message)message);
            }
            out.startReply();
            out.writeNull();
            out.completeReply();
        }
        catch (Exception e) {
            log.log(Level.WARNING, e.toString(), e);
            out.startReply();
            out.writeFault("SystemFault", String.valueOf(e), e);
            out.completeReply();
        }
    }

    protected void _execute(CharBuffer method, BurlapInput in, BurlapOutput out) throws Exception {
    }
}

