/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.ejb.cfg;

import com.caucho.config.ConfigException;
import com.caucho.ejb.cfg.CmpRelationRole;
import com.caucho.ejb.cfg.EjbConfig;
import com.caucho.ejb.cfg.SqlRelation;
import com.caucho.util.L10N;
import com.rc.retroweaver.runtime.ClassLiteral;

public class CmpRelation {
    private static final L10N L = new L10N(ClassLiteral.getClass((String)"com/caucho/ejb/cfg/CmpRelation"));
    private EjbConfig _config;
    private String _location = "";
    private String _name;
    private String _sqlTable;
    private CmpRelationRole _sourceRole;
    private CmpRelationRole _targetRole;
    private int _roleCount;

    public CmpRelation(EjbConfig config) {
        this._config = config;
        this._sourceRole = new CmpRelationRole(this);
        this._targetRole = new CmpRelationRole(this);
        this._sourceRole.setTarget(this._targetRole);
        this._targetRole.setTarget(this._sourceRole);
    }

    public CmpRelation() {
        this._sourceRole = new CmpRelationRole(this);
        this._targetRole = new CmpRelationRole(this);
        this._sourceRole.setTarget(this._targetRole);
        this._targetRole.setTarget(this._sourceRole);
    }

    public void setConfigLocation(String filename, int line) {
        this._location = filename + ":" + line + ": ";
    }

    public String getLocation() {
        return this._location;
    }

    public String getName() {
        return this._name;
    }

    public void setName(String name) {
        this._name = name;
    }

    public void setEJBRelationName(String name) {
        this._name = name;
    }

    public String getSQLTable() {
        return this._sqlTable;
    }

    public void setSQLTable(String sqlTable) {
        this._sqlTable = sqlTable;
    }

    public CmpRelationRole getSourceRole() {
        if (this._sourceRole.getFieldName() == null && this._targetRole.getFieldName() != null) {
            return this._targetRole;
        }
        return this._sourceRole;
    }

    public CmpRelationRole getTargetRole() {
        if (this._sourceRole.getFieldName() == null && this._targetRole.getFieldName() != null) {
            return this._sourceRole;
        }
        return this._targetRole;
    }

    public String getSourceEJB() {
        return this.getSourceRole().getEJBName();
    }

    public void setSourceEJB(String sourceEJB) {
        this._sourceRole.setEJBName(sourceEJB);
    }

    public String getSourceField() {
        return this.getSourceRole().getFieldName();
    }

    public void setSourceField(String sourceField) {
        this._sourceRole.setFieldName(sourceField);
    }

    public boolean getSourceCascadeDelete() {
        return this.getSourceRole().getCascadeDelete();
    }

    public void setSourceCascadeDelete(boolean sourceCascadeDelete) {
        this._sourceRole.setCascadeDelete(sourceCascadeDelete);
    }

    public String getSourceMultiplicity() {
        return this.getSourceRole().getMultiplicity();
    }

    public void setSourceMultiplicity(String sourceMultiplicity) throws ConfigException {
        this._sourceRole.setMultiplicity(sourceMultiplicity);
    }

    public SqlRelation[] getSourceSQLColumns() {
        return this.getSourceRole().getSQLColumns();
    }

    public void addSourceSQLColumn(String sqlColumn, String references) {
        this._sourceRole.addSQLColumn(sqlColumn, references);
    }

    public CmpRelationRole.SqlColumn createSourceSqlColumn() {
        return this._sourceRole.createSqlColumn();
    }

    public String getSourceOrderBy() {
        return this.getSourceRole().getOrderBy();
    }

    public void setSourceOrderBy(String sourceOrderBy) {
        this._sourceRole.setOrderBy(sourceOrderBy);
    }

    public String getTargetEJB() {
        return this.getTargetRole().getEJBName();
    }

    public void setTargetEJB(String targetEJB) {
        this._targetRole.setEJBName(targetEJB);
    }

    public String getTargetField() {
        return this.getTargetRole().getFieldName();
    }

    public void setTargetField(String targetField) {
        this._targetRole.setFieldName(targetField);
    }

    public boolean getTargetCascadeDelete() {
        return this.getTargetRole().getCascadeDelete();
    }

    public void setTargetCascadeDelete(boolean targetCascadeDelete) {
        this._targetRole.setCascadeDelete(targetCascadeDelete);
    }

    public String getTargetMultiplicity() {
        return this.getTargetRole().getMultiplicity();
    }

    public void setTargetMultiplicity(String targetMultiplicity) throws ConfigException {
        this._targetRole.setMultiplicity(targetMultiplicity);
    }

    public SqlRelation[] getTargetSQLColumns() {
        return this.getTargetRole().getSQLColumns();
    }

    public void addTargetSQLColumn(String sqlColumn, String references) {
        this._targetRole.addSQLColumn(sqlColumn, references);
    }

    public CmpRelationRole.SqlColumn createTargetSqlColumn() {
        return this._targetRole.createSqlColumn();
    }

    public String getTargetOrderBy() {
        return this.getTargetRole().getOrderBy();
    }

    public void setTargetOrderBy(String targetOrderBy) {
        this._targetRole.setOrderBy(targetOrderBy);
    }

    public CmpRelationRole createEjbRelationshipRole() throws ConfigException {
        ++this._roleCount;
        if (this._roleCount == 1) {
            return this._sourceRole;
        }
        if (this._roleCount == 2) {
            return this._targetRole;
        }
        throw new ConfigException(L.l("ejb-relation requires two ejb-relationship-role elements"));
    }

    public void merge(CmpRelation newRel) throws ConfigException {
        if (this._sqlTable == null) {
            this._sqlTable = newRel.getSQLTable();
        }
        this._sourceRole.merge(newRel.getSourceRole());
        this._targetRole.merge(newRel.getTargetRole());
    }

    public void init() throws ConfigException {
        if (this.getSourceEJB() == null) {
            throw new ConfigException(L.l("ejb-relation needs a source EJB."));
        }
        if (this.getTargetEJB() == null) {
            throw new ConfigException(L.l("ejb-relation needs a target EJB."));
        }
        if (this.getSourceField() == null) {
            throw new ConfigException(L.l("ejb-relation needs a source field."));
        }
    }

    public boolean equals(Object o) {
        if (!(o instanceof CmpRelation)) {
            return false;
        }
        CmpRelation relation = (CmpRelation)o;
        return this._sourceRole.equals(relation._sourceRole);
    }
}

