/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.ejb.cfg;

import com.caucho.amber.AmberManager;
import com.caucho.amber.field.AmberField;
import com.caucho.amber.field.DependentEntityOneToOneField;
import com.caucho.amber.field.EntityManyToOneField;
import com.caucho.amber.field.Id;
import com.caucho.amber.field.IdField;
import com.caucho.amber.field.KeyManyToOneField;
import com.caucho.amber.table.Column;
import com.caucho.amber.table.ForeignColumn;
import com.caucho.amber.table.LinkColumns;
import com.caucho.amber.type.EntityType;
import com.caucho.config.ConfigException;
import com.caucho.ejb.cfg.CmrRelation;
import com.caucho.ejb.cfg.EjbBean;
import com.caucho.ejb.cfg.EjbEntityBean;
import com.caucho.ejb.cfg.SqlRelation;
import com.caucho.util.L10N;
import com.caucho.util.Log;
import com.rc.retroweaver.runtime.ClassLiteral;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.logging.Logger;

public class CmrManyToOne
extends CmrRelation {
    private static final L10N L = new L10N(ClassLiteral.getClass((String)"com/caucho/ejb/cfg/CmrManyToOne"));
    private static final Logger log = Log.open(ClassLiteral.getClass((String)"com/caucho/ejb/cfg/CmrManyToOne"));
    private EjbEntityBean _targetBean;
    private SqlRelation[] _sqlColumns;
    private EntityManyToOneField _amberManyToOne;
    private DependentEntityOneToOneField _amberDependentOneToOne;
    private boolean _isDependent;
    private boolean _isSourceCascadeDelete;
    private boolean _isTargetCascadeDelete;

    public CmrManyToOne(EjbEntityBean entityBean, String fieldName, EjbEntityBean targetBean) throws ConfigException {
        super(entityBean, fieldName);
        this._targetBean = targetBean;
        Method getter = this.getGetter();
        if (!getter.getReturnType().equals(this._targetBean.getLocal())) {
            throw new ConfigException(L.l("{0}: '{1}' must return the local interface '{2}' of the EJB bean '{3}'.", entityBean.getEJBClass().getName(), EjbBean.getFullMethodName(getter), this._targetBean.getLocal().getName(), this._targetBean.getEJBName()));
        }
    }

    public EjbEntityBean getTargetBean() {
        return this._targetBean;
    }

    public Class getTargetType() {
        return this._targetBean.getLocal();
    }

    public void setSQLColumns(SqlRelation[] columns) {
        this._sqlColumns = columns;
    }

    public SqlRelation[] getSQLColumns() {
        return this._sqlColumns;
    }

    public void setDependent(boolean isDependent) {
        this._isDependent = isDependent;
    }

    public void setSourceCascadeDelete(boolean isCascadeDelete) {
        this._isSourceCascadeDelete = isCascadeDelete;
    }

    public void setTargetCascadeDelete(boolean isCascadeDelete) {
        this._isTargetCascadeDelete = isCascadeDelete;
    }

    public boolean isCascadeDelete() {
        return this._isSourceCascadeDelete;
    }

    public EntityManyToOneField getAmberManyToOne() {
        if (this._amberManyToOne == null) {
            try {
                EntityType sourceType = this.getEntity().getEntityType();
                this._amberManyToOne = new EntityManyToOneField(sourceType, this.getName());
                EntityType targetType = this._targetBean.getEntityType();
                this._amberManyToOne.setType(targetType);
                this._amberManyToOne.setLinkColumns(this.calculateColumns(sourceType, targetType));
                if (!this._isDependent) {
                    this._amberManyToOne.setSourceCascadeDelete(this._isSourceCascadeDelete);
                    this._amberManyToOne.setTargetCascadeDelete(this._isTargetCascadeDelete);
                }
                this._amberManyToOne.init();
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return this._amberManyToOne;
    }

    public DependentEntityOneToOneField getAmberOneToOne() {
        return this._amberDependentOneToOne;
    }

    public IdField createId(AmberManager amberManager, EntityType type) throws ConfigException {
        String fieldName = this.getName();
        EntityType sourceType = this.getEntity().getEntityType();
        EntityType targetType = this.getTargetBean().getEntityType();
        KeyManyToOneField keyField = new KeyManyToOneField(type, fieldName);
        keyField.setType(targetType);
        keyField.setLinkColumns(this.calculateColumns(sourceType, targetType));
        keyField.init();
        return keyField;
    }

    public AmberField assembleAmber(EntityType type) throws ConfigException {
        EntityManyToOneField manyToOne;
        AmberManager manager = type.getAmberManager();
        EntityType targetType = this.getTargetBean().getEntityType();
        if (this._isDependent) {
            DependentEntityOneToOneField oneToOne;
            this._amberDependentOneToOne = oneToOne = new DependentEntityOneToOneField(type, this.getName());
            return oneToOne;
        }
        this._amberManyToOne = manyToOne = new EntityManyToOneField(type, this.getName());
        manyToOne.setType(this._targetBean.getEntityType());
        manyToOne.setLinkColumns(this.calculateColumns(type, targetType));
        manyToOne.setSourceCascadeDelete(this._isSourceCascadeDelete);
        manyToOne.setTargetCascadeDelete(this._isTargetCascadeDelete);
        return manyToOne;
    }

    private LinkColumns calculateColumns(EntityType type, EntityType targetType) throws ConfigException {
        ArrayList<ForeignColumn> columns = new ArrayList<ForeignColumn>();
        Id id = targetType.getId();
        ArrayList<Column> keys = id.getColumns();
        if (this._sqlColumns != null && this._sqlColumns.length == keys.size()) {
            Iterator<Column> i$ = keys.iterator();
            while (i$.hasNext()) {
                Column key = i$.next();
                String sqlColumn = this.getColumn(this._sqlColumns, key.getName());
                ForeignColumn column = type.getTable().createForeignColumn(sqlColumn, key);
                columns.add(column);
            }
        } else if (this._sqlColumns != null && this._sqlColumns.length == 1) {
            String baseSqlColumn = this._sqlColumns[0].getSQLColumn();
            Iterator<Column> i$ = keys.iterator();
            while (i$.hasNext()) {
                Column key = i$.next();
                String sqlColumn = baseSqlColumn + "_" + key.getName();
                ForeignColumn column = type.getTable().createForeignColumn(sqlColumn, key);
                columns.add(column);
            }
        } else {
            if (this._sqlColumns != null && this._sqlColumns.length > 0) {
                throw new IllegalStateException("Mismatched SQL columns");
            }
            if (keys.size() == 1) {
                String sqlColumn = CmrManyToOne.toSqlName(this.getName());
                ForeignColumn column = type.getTable().createForeignColumn(sqlColumn, keys.get(0));
                columns.add(column);
            } else {
                String baseSqlColumn = CmrManyToOne.toSqlName(this.getName());
                Iterator<Column> i$ = keys.iterator();
                while (i$.hasNext()) {
                    Column key = i$.next();
                    String sqlColumn = baseSqlColumn + "_" + key.getName();
                    ForeignColumn column = type.getTable().createForeignColumn(sqlColumn, key);
                    columns.add(column);
                }
            }
        }
        return new LinkColumns(type.getTable(), targetType.getTable(), columns);
    }

    private String getColumn(SqlRelation[] sqlColumns, String sqlName) throws ConfigException {
        String fieldName = this.getFieldName(this._targetBean.getEntityType(), sqlName);
        if (sqlColumns.length == 1) {
            return sqlColumns[0].getSQLColumn();
        }
        for (int i = 0; i < sqlColumns.length; ++i) {
            String ref = sqlColumns[i].getReferences();
            if (ref == null) {
                throw new ConfigException(L.l("sql-column '{0}' needs a references attribute.", sqlColumns[i].getSQLColumn()));
            }
            if (!ref.equals(fieldName)) continue;
            return sqlColumns[i].getSQLColumn();
        }
        throw new ConfigException(L.l("key '{0}' has no matching sql-column", fieldName));
    }

    private String getFieldName(EntityType type, String sqlName) throws ConfigException {
        Iterator<IdField> i$ = type.getId().getKeys().iterator();
        while (i$.hasNext()) {
            IdField field = i$.next();
            ArrayList<Column> columns = field.getColumns();
            for (int i = 0; i < columns.size(); ++i) {
                if (!columns.get(i).getName().equals(sqlName)) continue;
                return field.getName();
            }
        }
        return sqlName;
    }

    public void linkAmber() throws ConfigException {
        CmrRelation targetRelation = this.getTargetRelation();
        if (targetRelation == null) {
            return;
        }
        if (!(targetRelation instanceof CmrManyToOne)) {
            return;
        }
        if (this._isDependent) {
            CmrManyToOne targetManyToOne = (CmrManyToOne)targetRelation;
            EntityManyToOneField amberTarget = targetManyToOne.getAmberManyToOne();
            if (this._amberDependentOneToOne == null) {
                DependentEntityOneToOneField oneToOne;
                EntityType type = this.getEntity().getEntityType();
                this._amberDependentOneToOne = oneToOne = new DependentEntityOneToOneField(type, this.getName());
            }
            this._amberDependentOneToOne.setTargetField(amberTarget);
        } else {
            CmrManyToOne targetManyToOne = (CmrManyToOne)targetRelation;
            DependentEntityOneToOneField amberTarget = targetManyToOne.getAmberOneToOne();
            EntityManyToOneField manyToOne = this.getAmberManyToOne();
            if (amberTarget != null && manyToOne != null) {
                manyToOne.setTargetField(amberTarget);
                amberTarget.setTargetField(manyToOne);
            }
        }
    }
}

