/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.ejb.cfg;

import com.caucho.config.BuilderProgram;
import com.caucho.config.BuilderProgramContainer;
import com.caucho.config.ConfigException;
import com.caucho.config.DependencyBean;
import com.caucho.config.LineConfigException;
import com.caucho.config.types.Period;
import com.caucho.ejb.AbstractServer;
import com.caucho.ejb.EjbServerManager;
import com.caucho.ejb.amber.AmberConfig;
import com.caucho.ejb.cfg.EjbBaseMethod;
import com.caucho.ejb.cfg.EjbConfig;
import com.caucho.ejb.cfg.EjbHomeView;
import com.caucho.ejb.cfg.EjbMethodPattern;
import com.caucho.ejb.cfg.EjbObjectView;
import com.caucho.ejb.cfg.EjbSecurityIdentity;
import com.caucho.ejb.cfg.EjbView;
import com.caucho.ejb.cfg.MethodSignature;
import com.caucho.ejb.gen.BeanAssembler;
import com.caucho.ejb.gen.TransactionChain;
import com.caucho.ejb.gen.UserInRoleChain;
import com.caucho.ejb.gen.ViewClass;
import com.caucho.java.gen.BaseClass;
import com.caucho.java.gen.BaseMethod;
import com.caucho.java.gen.CallChain;
import com.caucho.java.gen.JavaClass;
import com.caucho.java.gen.JavaClassGenerator;
import com.caucho.java.gen.MethodCallChain;
import com.caucho.loader.EnvironmentBean;
import com.caucho.loader.EnvironmentClassLoader;
import com.caucho.loader.EnvironmentLocal;
import com.caucho.log.Log;
import com.caucho.make.ClassDependency;
import com.caucho.make.PersistentDependency;
import com.caucho.util.L10N;
import com.caucho.vfs.Depend;
import com.caucho.vfs.Path;
import com.rc.retroweaver.runtime.ClassLiteral;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EjbBean
implements EnvironmentBean,
DependencyBean {
    private static Logger log = Log.open(ClassLiteral.getClass((String)"com/caucho/ejb/cfg/EjbBean"));
    private static L10N L = new L10N(ClassLiteral.getClass((String)"com/caucho/ejb/cfg/EjbBean"));
    private static EnvironmentLocal<Map<Class, Method[]>> _methodCache = new EnvironmentLocal();
    private EjbConfig _ejbConfig;
    private ClassLoader _loader;
    private String _ejbName;
    private String _jndiName;
    private String _location = "";
    private Class _ejbClass;
    protected Class _remoteHome;
    protected Class _remote;
    protected Class _localHome;
    protected Class _local;
    protected EjbView _remoteHomeView;
    protected EjbView _remoteView;
    protected EjbView _localHomeView;
    protected EjbView _localView;
    private boolean _isAllowPOJO;
    private boolean _isContainerTransaction = true;
    ArrayList<PersistentDependency> _dependList = new ArrayList();
    ArrayList<PersistentDependency> _configDependList = new ArrayList();
    ArrayList<String> _beanDependList = new ArrayList();
    ArrayList<EjbMethodPattern> _methodList = new ArrayList();
    private HashMap<String, EjbBaseMethod> _methodMap = new HashMap();
    private BuilderProgramContainer _initProgram;
    private long _transactionTimeout;

    public EjbBean(EjbConfig ejbConfig) {
        this._ejbConfig = ejbConfig;
        this._loader = Thread.currentThread().getContextClassLoader();
    }

    public EjbConfig getConfig() {
        return this._ejbConfig;
    }

    @Override
    public ClassLoader getClassLoader() {
        return this._loader;
    }

    @Override
    public void setEnvironmentClassLoader(EnvironmentClassLoader loader) {
        this._loader = loader;
    }

    public void setConfigLocation(String filename, int line) {
        this._location = new StringBuffer().append(filename).append(":").append(line).append(": ").toString();
    }

    public void setLocation(String location) {
        this._location = location;
    }

    public String getLocation() {
        return this._location;
    }

    public void setAllowPOJO(boolean allowPOJO) {
        this._isAllowPOJO = allowPOJO;
    }

    public boolean isAllowPOJO() {
        return this._isAllowPOJO;
    }

    public void addDescription(String description) {
    }

    public void addDisplayName(String displayName) {
    }

    public void addIcon(String icon) {
    }

    public void setEJBName(String ejbName) {
        this._ejbName = ejbName;
    }

    public String getEJBName() {
        return this._ejbName;
    }

    public void setJndiName(String jndiName) {
        this._jndiName = jndiName;
    }

    public String getJndiName() {
        return this._jndiName;
    }

    public String getEJBKind() {
        return "unknown";
    }

    public void setEJBClass(Class ejbClass) throws ConfigException {
        if (this._ejbClass != null && !this._ejbClass.equals(ejbClass)) {
            throw this.error(L.l("ejb-class '{0}' cannot be redefined.  Old value is '{1}'.", (Object)this._ejbClass.getName(), ejbClass.getName()));
        }
        this._ejbClass = ejbClass;
        if (!Modifier.isPublic(ejbClass.getModifiers())) {
            throw this.error(L.l("`{0}' must be public.  Bean implementations must be public.", ejbClass.getName()));
        }
        if (Modifier.isFinal(ejbClass.getModifiers())) {
            throw this.error(L.l("`{0}' must not be final.  Bean implementations must not be final.", ejbClass.getName()));
        }
        if (Modifier.isInterface(ejbClass.getModifiers())) {
            throw this.error(L.l("`{0}' must not be an interface.  Bean implementations must be classes.", ejbClass.getName()));
        }
        Constructor constructor = null;
        try {
            constructor = ejbClass.getConstructor(new Class[0]);
        }
        catch (Throwable e) {
            log.log(Level.FINE, e.toString(), e);
        }
        if (constructor == null) {
            throw this.error(L.l("`{0}' needs a public zero-arg constructor.  Bean implementations need a public zero-argument constructor.", ejbClass.getName()));
        }
        Class<?>[] exn = constructor.getExceptionTypes();
        for (int i = 0; i < exn.length; ++i) {
            if (ClassLiteral.getClass((String)"java/lang/RuntimeException").isAssignableFrom(exn[i])) continue;
            throw this.error(L.l("{0}: constructor must not throw `{1}'.  Bean constructors must not throw checked exceptions.", (Object)ejbClass.getName(), exn[i].getName()));
        }
        Method method = null;
        try {
            method = ejbClass.getMethod("finalize", new Class[0]);
        }
        catch (Throwable e) {
            // empty catch block
        }
        if (method != null && !method.getDeclaringClass().equals(ClassLiteral.getClass((String)"java/lang/Object"))) {
            throw this.error(L.l("`{0}' may not implement finalize().  Bean implementations may not implement finalize().", ejbClass.getName()));
        }
    }

    public Class getEJBClass() {
        return this._ejbClass;
    }

    public String getEJBFullClassName() {
        return this._ejbClass.getName();
    }

    public String getEJBClassName() {
        String s = this._ejbClass.getName();
        int p = s.lastIndexOf(46);
        if (p > 0) {
            return s.substring(p + 1);
        }
        return s;
    }

    public String getFullImplName() {
        return this.getEJBFullClassName();
    }

    public void setHome(Class remoteHome) throws ConfigException {
        this._remoteHome = remoteHome;
        if (!Modifier.isPublic(remoteHome.getModifiers())) {
            throw this.error(L.l("`{0}' must be public.  <home> interfaces must be public.", remoteHome.getName()));
        }
        if (!Modifier.isInterface(remoteHome.getModifiers())) {
            throw this.error(L.l("`{0}' must be an interface. <home> interfaces must be interfaces.", remoteHome.getName()));
        }
        if (!ClassLiteral.getClass((String)"javax/ejb/EJBHome").isAssignableFrom(remoteHome) && !this.isAllowPOJO()) {
            throw new ConfigException(L.l("`{0}' must extend EJBHome.  <home> interfaces must extend javax.ejb.EJBHome.", remoteHome.getName()));
        }
    }

    public Class getRemoteHome() {
        return this._remoteHome;
    }

    public void setRemote(Class remote) throws ConfigException {
        this._remote = remote;
        if (!Modifier.isPublic(remote.getModifiers())) {
            throw this.error(L.l("`{0}' must be public.  <remote> interfaces must be public.", remote.getName()));
        }
        if (!Modifier.isInterface(remote.getModifiers())) {
            throw this.error(L.l("`{0}' must be an interface. <remote> interfaces must be interfaces.", remote.getName()));
        }
        if (!ClassLiteral.getClass((String)"javax/ejb/EJBObject").isAssignableFrom(remote) && !this.isAllowPOJO()) {
            throw new ConfigException(L.l("`{0}' must extend EJBObject.  <remote> interfaces must extend javax.ejb.EJBObject.", remote.getName()));
        }
    }

    public Class getRemote() {
        return this._remote;
    }

    public void setLocalHome(Class localHome) throws ConfigException {
        this._localHome = localHome;
        if (!Modifier.isPublic(localHome.getModifiers())) {
            throw this.error(L.l("`{0}' must be public.  <local-home> interfaces must be public.", localHome.getName()));
        }
        if (!Modifier.isInterface(localHome.getModifiers())) {
            throw this.error(L.l("`{0}' must be an interface. <local-home> interfaces must be interfaces.", localHome.getName()));
        }
        if (!ClassLiteral.getClass((String)"javax/ejb/EJBLocalHome").isAssignableFrom(localHome) && !this.isAllowPOJO()) {
            throw new ConfigException(L.l("`{0}' must extend EJBLocalHome.  <local-home> interfaces must extend javax.ejb.EJBLocalHome.", localHome.getName()));
        }
    }

    public Class getLocalHome() {
        return this._localHome;
    }

    public void setLocal(Class local) throws ConfigException {
        this._local = local;
        if (!Modifier.isPublic(local.getModifiers())) {
            throw this.error(L.l("`{0}' must be public.  <local> interfaces must be public.", local.getName()));
        }
        if (!Modifier.isInterface(local.getModifiers())) {
            throw this.error(L.l("`{0}' must be an interface. <local> interfaces must be interfaces.", local.getName()));
        }
        if (!ClassLiteral.getClass((String)"javax/ejb/EJBLocalObject").isAssignableFrom(local) && !this.isAllowPOJO()) {
            throw new ConfigException(L.l("`{0}' must extend EJBLocalObject.  <local> interfaces must extend javax.ejb.EJBLocalObject.", local.getName()));
        }
    }

    public Class getLocal() {
        return this._local;
    }

    public boolean isContainerTransaction() {
        return this._isContainerTransaction;
    }

    public EjbMethodPattern createMethod(MethodSignature sig) {
        for (int i = 0; i < this._methodList.size(); ++i) {
            EjbMethodPattern method = this._methodList.get(i);
            if (!method.getSignature().equals(sig)) continue;
            return method;
        }
        EjbMethodPattern method = new EjbMethodPattern(this, sig);
        this._methodList.add(method);
        return method;
    }

    public void addMethod(EjbMethodPattern method) {
        this._methodList.add(method);
    }

    public EjbMethodPattern getMethodPattern(Method method, String intf) {
        EjbMethodPattern bestMethod = null;
        int bestCost = -1;
        for (int i = 0; i < this._methodList.size(); ++i) {
            EjbMethodPattern ejbMethod = this._methodList.get(i);
            MethodSignature sig = ejbMethod.getSignature();
            if (!sig.isMatch(method, intf) || bestCost >= sig.getCost()) continue;
            bestMethod = ejbMethod;
            bestCost = sig.getCost();
        }
        return bestMethod;
    }

    public ArrayList<EjbMethodPattern> getMethodList() {
        return this._methodList;
    }

    public void setTransactionTimeout(Period timeout) {
        this._transactionTimeout = timeout.getPeriod();
    }

    public long getTransactionTimeout() {
        return this._transactionTimeout;
    }

    public void setSecurityIdentity(EjbSecurityIdentity securityIdentity) {
    }

    public void addDependencyList(ArrayList<PersistentDependency> dependList) {
        for (int i = 0; dependList != null && i < dependList.size(); ++i) {
            this.addDependency(dependList.get(i));
        }
    }

    public void addDepend(Path path) {
        this.addDependency(new Depend(path));
    }

    @Override
    public void addDependency(PersistentDependency depend) {
        if (!this._dependList.contains(depend)) {
            this._dependList.add(depend);
        }
    }

    public void addDependency(Class cl) {
        this.addDependency(new ClassDependency(cl));
    }

    public ArrayList<PersistentDependency> getDependList() {
        return this._dependList;
    }

    public void addBeanDependency(String ejbName) {
        if (!this._beanDependList.contains(ejbName)) {
            this._beanDependList.add(ejbName);
        }
    }

    public ArrayList<String> getBeanDependList() {
        return this._beanDependList;
    }

    public void addInitProgram(BuilderProgram init) {
        if (this._initProgram == null) {
            this._initProgram = new BuilderProgramContainer();
        }
        this._initProgram.addProgram(init);
    }

    public BuilderProgramContainer getInitProgram() {
        return this._initProgram;
    }

    public void init() throws ConfigException {
        try {
            this.introspect();
            this.assembleBeanMethods();
            this.createViews();
        }
        catch (LineConfigException e) {
            throw e;
        }
        catch (ConfigException e) {
            throw new LineConfigException(new StringBuffer().append(this._location).append(e.getMessage()).toString(), e);
        }
    }

    public void introspect() throws ConfigException {
    }

    public void configureAmber(AmberConfig config) throws ConfigException {
    }

    protected void createViews() throws ConfigException {
        if (this._remoteHome != null) {
            this._remoteHomeView = this.createHomeView(this._remoteHome, "RemoteHome");
            this._remoteHomeView.introspect();
        }
        if (this._remote != null) {
            this._remoteView = this.createObjectView(this._remote, "Remote");
            this._remoteView.introspect();
        }
        if (this._localHome != null) {
            this._localHomeView = this.createHomeView(this._localHome, "LocalHome");
            this._localHomeView.introspect();
        }
        if (this._local != null) {
            this._localView = this.createObjectView(this._local, "Local");
            this._localView.introspect();
        }
    }

    protected EjbHomeView createHomeView(Class homeClass, String prefix) throws ConfigException {
        return new EjbHomeView(this, homeClass, prefix);
    }

    protected EjbObjectView createObjectView(Class apiClass, String prefix) throws ConfigException {
        return new EjbObjectView(this, apiClass, prefix);
    }

    public void generate(JavaClassGenerator javaGen, boolean isAutoCompile) throws Exception {
        JavaClass javaClass;
        String fullClassName = this.getSkeletonName();
        if (javaGen.preload(fullClassName) == null && isAutoCompile && (javaClass = this.assembleGenerator(fullClassName)) != null) {
            javaGen.generate(javaClass);
        }
    }

    public AbstractServer deployServer(EjbServerManager ejbManager, JavaClassGenerator javaGen) throws ClassNotFoundException, ConfigException {
        throw new UnsupportedOperationException();
    }

    protected void validateRemote(Class objectClass) throws ConfigException {
        Class beanClass = this.getEJBClass();
        String beanName = beanClass.getName();
        String objectName = objectClass.getName();
        if (!Modifier.isPublic(objectClass.getModifiers())) {
            throw this.error(L.l("`{0}' must be public", objectName));
        }
        if (!Modifier.isInterface(objectClass.getModifiers())) {
            throw this.error(L.l("`{0}' must be an interface", objectName));
        }
        Method[] methods = EjbBean.getMethods(objectClass);
        for (int i = 0; i < methods.length; ++i) {
            Method method = methods[i];
            String name = method.getName();
            Class[] param = method.getParameterTypes();
            Class<?> retType = method.getReturnType();
            if (method.getDeclaringClass().isAssignableFrom(ClassLiteral.getClass((String)"javax/ejb/EJBObject")) || method.getDeclaringClass().isAssignableFrom(ClassLiteral.getClass((String)"javax/ejb/EJBLocalObject"))) continue;
            if (ClassLiteral.getClass((String)"javax/ejb/EJBObject").isAssignableFrom(objectClass)) {
                this.validateException(method, ClassLiteral.getClass((String)"java/rmi/RemoteException"));
            }
            if (name.startsWith("ejb")) {
                throw this.error(L.l("`{0}' forbidden in {1}.  Local or remote interfaces may not define ejbXXX methods.", (Object)EjbBean.getFullMethodName(method), objectName));
            }
            Class<?> returnType = method.getReturnType();
            if (ClassLiteral.getClass((String)"javax/ejb/EJBObject").isAssignableFrom(objectClass) && (ClassLiteral.getClass((String)"javax/ejb/EJBLocalObject").isAssignableFrom(returnType) || ClassLiteral.getClass((String)"javax/ejb/EJBLocalHome").isAssignableFrom(returnType))) {
                throw this.error(L.l("`{0}' must not return `{1}' in {2}.  Remote methods must not return local interfaces.", EjbBean.getFullMethodName(method), EjbBean.getShortClassName(returnType), objectClass.getName()));
            }
            Method implMethod = this.validateRemoteImplMethod(method.getName(), param, method, objectClass);
            if (!returnType.equals(implMethod.getReturnType())) {
                throw this.error(L.l("{0}: `{1}' must return {2} to match {3}.{4}.  Business methods must return the same type as the interface.", method.getDeclaringClass().getName(), EjbBean.getFullMethodName(method), implMethod.getReturnType().getName(), EjbBean.getShortClassName(implMethod.getDeclaringClass()), EjbBean.getFullMethodName(implMethod)));
            }
            this.validateExceptions(method, implMethod.getExceptionTypes());
        }
    }

    private Method validateRemoteImplMethod(String methodName, Class[] param, Method sourceMethod, Class sourceClass) throws ConfigException {
        Method method = null;
        Class beanClass = this.getEJBClass();
        method = EjbBean.getMethod(beanClass, methodName, param);
        if (method == null && sourceMethod != null) {
            throw this.error(L.l("{0}: `{1}' expected to match {2}.{3}", beanClass.getName(), EjbBean.getFullMethodName(methodName, param), EjbBean.getShortClassName(sourceMethod.getDeclaringClass()), EjbBean.getFullMethodName(sourceMethod)));
        }
        if (method == null) {
            throw this.error(L.l("{0}: `{1}' expected", (Object)beanClass.getName(), EjbBean.getFullMethodName(methodName, param)));
        }
        if (!Modifier.isPublic(method.getModifiers())) {
            throw this.error(L.l("{0}: `{1}' must be public", (Object)beanClass.getName(), EjbBean.getFullMethodName(methodName, param)));
        }
        if (Modifier.isStatic(method.getModifiers())) {
            throw this.error(L.l("{0}: `{1}' must not be static", (Object)beanClass.getName(), EjbBean.getFullMethodName(methodName, param)));
        }
        if (Modifier.isFinal(method.getModifiers())) {
            throw this.error(L.l("{0}: `{1}' must not be final.", beanClass.getName(), EjbBean.getFullMethodName(methodName, param), beanClass.getName()));
        }
        return method;
    }

    Method validateNonFinalMethod(String methodName, Class[] param, boolean isOptional) throws ConfigException {
        if (isOptional && EjbBean.getMethod(this._ejbClass, methodName, param) == null) {
            return null;
        }
        return this.validateNonFinalMethod(methodName, param);
    }

    Method validateNonFinalMethod(String methodName, Class[] param) throws ConfigException {
        return this.validateNonFinalMethod(methodName, param, null, null);
    }

    Method validateNonFinalMethod(String methodName, Class[] param, Method sourceMethod, Class sourceClass) throws ConfigException {
        return this.validateNonFinalMethod(methodName, param, sourceMethod, sourceClass, false);
    }

    Method validateNonFinalMethod(String methodName, Class[] param, Method sourceMethod, Class sourceClass, boolean isOptional) throws ConfigException {
        Method method = this.validateMethod(methodName, param, sourceMethod, sourceClass, isOptional);
        if (method == null && isOptional) {
            return null;
        }
        if (Modifier.isFinal(method.getModifiers())) {
            throw this.error(L.l("{0}: `{1}' must not be final", (Object)this._ejbClass.getName(), EjbBean.getFullMethodName(method)));
        }
        if (Modifier.isStatic(method.getModifiers())) {
            throw this.error(L.l("{0}: `{1}' must not be static", (Object)this._ejbClass.getName(), EjbBean.getFullMethodName(method)));
        }
        return method;
    }

    Method validateMethod(String methodName, Class[] param) throws ConfigException {
        return this.validateMethod(methodName, param, null, null);
    }

    Method validateMethod(String methodName, Class[] param, Method sourceMethod, Class sourceClass) throws ConfigException {
        return this.validateMethod(methodName, param, sourceMethod, sourceClass, false);
    }

    Method validateMethod(String methodName, Class[] param, Method sourceMethod, Class sourceClass, boolean isOptional) throws ConfigException {
        Method method = null;
        method = EjbBean.getMethod(this._ejbClass, methodName, param);
        if (method == null && isOptional) {
            return null;
        }
        if (method == null && sourceMethod != null) {
            throw this.error(L.l("{0}: missing `{1}' needed to match {2}.{3}", this._ejbClass.getName(), EjbBean.getFullMethodName(methodName, param), EjbBean.getShortClassName(sourceClass), EjbBean.getFullMethodName(sourceMethod)));
        }
        if (method == null) {
            throw this.error(L.l("{0}: expected `{1}'", (Object)this._ejbClass.getName(), EjbBean.getFullMethodName(methodName, param)));
        }
        Class<?> declaringClass = method.getDeclaringClass();
        if (Modifier.isAbstract(method.getModifiers())) {
            if (EjbBean.getMethod(ClassLiteral.getClass((String)"javax/ejb/EntityBean"), method) != null) {
                throw this.error(L.l("{0}: `{1}' must not be abstract.  Entity beans must implement the methods in EntityBean.", (Object)this._ejbClass.getName(), EjbBean.getFullMethodName(methodName, param)));
            }
            if (EjbBean.getMethod(ClassLiteral.getClass((String)"javax/ejb/SessionBean"), method) != null) {
                throw this.error(L.l("{0}: `{1}' must not be abstract.  Session beans must implement the methods in SessionBean.", (Object)this._ejbClass.getName(), EjbBean.getFullMethodName(methodName, param)));
            }
            if (sourceMethod != null) {
                throw this.error(L.l("{0}: `{1}' must not be abstract.  All methods from `{2}' must be implemented in the bean.", this._ejbClass.getName(), EjbBean.getFullMethodName(methodName, param), sourceClass.getName()));
            }
            throw this.error(L.l("{0}: `{1}' must not be abstract.  Business methods must be implemented.", (Object)this._ejbClass.getName(), EjbBean.getFullMethodName(methodName, param)));
        }
        if (!Modifier.isPublic(method.getModifiers())) {
            throw this.error(L.l("{0}: `{1}' must be public.  Business method implementations must be public.", (Object)this._ejbClass.getName(), EjbBean.getFullMethodName(methodName, param)));
        }
        if (Modifier.isStatic(method.getModifiers())) {
            throw this.error(L.l("{0}: `{1}' must not be static.  Business method implementations must not be static.", (Object)this._ejbClass.getName(), EjbBean.getFullMethodName(method)));
        }
        return method;
    }

    protected String getSkeletonName() {
        String className = this.getEJBClass().getName();
        int p = className.lastIndexOf(46);
        if (p > 0) {
            className = className.substring(p + 1);
        }
        String ejbName = this.getEJBName();
        String fullClassName = new StringBuffer().append("_ejb.").append(ejbName).append(".").append(className).append("__EJB").toString();
        return JavaClassGenerator.cleanClassName(fullClassName);
    }

    protected JavaClass assembleGenerator(String fullClassName) throws NoSuchMethodException, ConfigException {
        BeanAssembler assembler;
        int p = fullClassName.lastIndexOf(46);
        String className = fullClassName;
        if (p > 0) {
            className = fullClassName.substring(p + 1);
        }
        if ((assembler = this.createAssembler(fullClassName)) == null) {
            return null;
        }
        this.addImports(assembler);
        assembler.addHeaderComponent(this.getEJBClass(), fullClassName, this.getFullImplName());
        this.assembleMethods(assembler, fullClassName);
        if (this._remoteHomeView != null) {
            this._remoteHomeView.assembleView(assembler, fullClassName);
        }
        if (this._remoteView != null) {
            this._remoteView.assembleView(assembler, fullClassName);
        }
        if (this._localHomeView != null) {
            this._localHomeView.assembleView(assembler, fullClassName);
        }
        if (this._localView != null) {
            this._localView.assembleView(assembler, fullClassName);
        }
        for (PersistentDependency depend : this._dependList) {
            assembler.addDependency(depend);
        }
        assembler.addDependency(new ClassDependency(this._ejbClass));
        if (this._remoteHome != null) {
            assembler.addDependency(new ClassDependency(this._remoteHome));
        }
        if (this._remote != null) {
            assembler.addDependency(new ClassDependency(this._remote));
        }
        if (this._localHome != null) {
            assembler.addDependency(new ClassDependency(this._localHome));
        }
        if (this._local != null) {
            assembler.addDependency(new ClassDependency(this._local));
        }
        return assembler.getAssembledGenerator();
    }

    protected void addImports(BeanAssembler assembler) {
        assembler.addImport("javax.ejb.*");
        assembler.addImport("com.caucho.vfs.*");
        assembler.addImport("com.caucho.ejb.xa.EjbTransactionManager");
        assembler.addImport("com.caucho.ejb.xa.TransactionContext");
        assembler.addImport("com.caucho.ejb.AbstractContext");
    }

    protected BeanAssembler createAssembler(String fullClassName) {
        return null;
    }

    protected void assembleBeanMethods() throws ConfigException {
        Method[] implMethods = EjbBean.getMethods(this.getEJBClass());
        for (int i = 0; i < implMethods.length; ++i) {
            Method method = implMethods[i];
            EjbBaseMethod ejbMethod = null;
            String name = method.getName();
            if (name.startsWith("ejb")) {
                ejbMethod = this.introspectEJBMethod(method);
                if (ejbMethod == null) continue;
                this._methodMap.put(EjbBean.getFullMethodName(ejbMethod.getMethod()), ejbMethod);
                continue;
            }
            this.validateImplMethod(method);
        }
    }

    protected void assembleMethods(BeanAssembler assembler, String fullClassName) throws ConfigException {
        for (EjbBaseMethod method : this._methodMap.values()) {
            assembler.addMethod(method.assemble(assembler, fullClassName));
        }
    }

    protected EjbBaseMethod introspectEJBMethod(Method method) throws ConfigException {
        return null;
    }

    protected void validateImplMethod(Method method) throws ConfigException {
    }

    protected void assembleMethods(BeanAssembler assembler, ViewClass view, String contextClassName, Method[] methods, String prefix) throws NoSuchMethodException {
        for (int i = 0; i < methods.length; ++i) {
            String className = methods[i].getDeclaringClass().getName();
            String methodName = methods[i].getName();
            Class<?>[] args = methods[i].getParameterTypes();
            if (className.startsWith("javax.ejb.") || EjbBean.isOld(methods, methods[i], i) || methodName.equals("equals") && args.length == 1 && args[0].equals(ClassLiteral.getClass((String)"java/lang/Object")) || methodName.equals("hashCode") && args.length == 0) continue;
            Method beanMethod = null;
            try {
                beanMethod = this.getEJBClass().getMethod(methods[i].getName(), methods[i].getParameterTypes());
            }
            catch (NoSuchMethodException e) {
                throw new NoSuchMethodException(new StringBuffer().append("Can't find public method ").append(EjbBean.getFullMethodName(methods[i].getName(), methods[i].getParameterTypes())).toString());
            }
            CallChain call = new MethodCallChain(beanMethod);
            call = view.createPoolChain(call);
            call = this.getTransactionChain(call, beanMethod, prefix);
            call = this.getSecurityChain(call, beanMethod, prefix);
            view.addMethod(new BaseMethod(methods[i], call));
        }
    }

    protected void assembleHomeMethods(BeanAssembler assembler, BaseClass baseClass, String contextClassName, Class homeClass, String prefix) throws NoSuchMethodException {
        Method[] methods = EjbBean.getMethods(homeClass);
        for (int i = 0; i < methods.length; ++i) {
            String name;
            Method beanMethod;
            String className = methods[i].getDeclaringClass().getName();
            String methodName = methods[i].getName();
            if (className.startsWith("javax.ejb.") || EjbBean.isOld(methods, methods[i], i)) continue;
            if (methodName.startsWith("create")) {
                beanMethod = null;
                name = new StringBuffer().append("ejbCreate").append(Character.toUpperCase(methodName.charAt(0))).append(methodName.substring(1)).toString();
                try {
                    beanMethod = this.getEJBClass().getMethod(name, methods[i].getParameterTypes());
                }
                catch (Throwable e) {}
                continue;
            }
            if (methodName.startsWith("find")) continue;
            beanMethod = null;
            name = new StringBuffer().append("ejbHome").append(Character.toUpperCase(methodName.charAt(0))).append(methodName.substring(1)).toString();
            try {
                beanMethod = this.getEJBClass().getMethod(name, methods[i].getParameterTypes());
            }
            catch (Exception e) {
                throw new NoSuchMethodException(new StringBuffer().append("can't find method ").append(name).toString());
            }
            CallChain call = new MethodCallChain(beanMethod);
            call = this.getTransactionChain(call, beanMethod, prefix);
            call = this.getSecurityChain(call, beanMethod, prefix);
            baseClass.addMethod(new BaseMethod(methods[i], call));
        }
    }

    protected CallChain getTransactionChain(CallChain next, Method method, String prefix) {
        return TransactionChain.create(next, this.getTransactionAttribute(method, prefix));
    }

    protected CallChain getSecurityChain(CallChain next, Method method, String prefix) {
        EjbMethodPattern ejbMethod = this.getMethodPattern(method, prefix);
        ArrayList roles = null;
        if (ejbMethod != null) {
            roles = ejbMethod.getRoles();
        }
        if (roles == null && (ejbMethod = this.getMethodPattern(null, prefix)) != null) {
            roles = ejbMethod.getRoles();
        }
        if (roles == null && (ejbMethod = this.getMethodPattern(method, null)) != null) {
            roles = ejbMethod.getRoles();
        }
        if (roles == null && (ejbMethod = this.getMethodPattern(null, null)) != null) {
            roles = ejbMethod.getRoles();
        }
        if (roles != null) {
            return new UserInRoleChain(next, roles);
        }
        return next;
    }

    protected void validatePublicMethod(Method method) throws ConfigException {
        if (!Modifier.isPublic(method.getModifiers())) {
            throw this.error(L.l("{0}: '{1}' must be public.", (Object)this._ejbClass.getName(), EjbBean.getFullMethodName(method)));
        }
        if (Modifier.isStatic(method.getModifiers())) {
            throw this.error(L.l("{0}: `{1}' must not be static.", (Object)this._ejbClass.getName(), EjbBean.getFullMethodName(method)));
        }
    }

    static boolean isOld(Method[] methods, Method method, int index) {
        for (int i = 0; i < index; ++i) {
            if (!EjbBean.isEquiv(methods[i], method)) continue;
            return true;
        }
        return false;
    }

    static boolean isEquiv(Method oldMethod, Method method) {
        Class<?>[] param;
        if (!oldMethod.getName().equals(method.getName())) {
            return false;
        }
        Class<?>[] oldParam = oldMethod.getParameterTypes();
        if (oldParam.length != (param = method.getParameterTypes()).length) {
            return false;
        }
        for (int j = 0; j < param.length; ++j) {
            if (param[j].equals(oldParam[j])) continue;
            return false;
        }
        return true;
    }

    public int getTransactionAttribute(Method method, String intf) {
        if (!this.isContainerTransaction()) {
            return 0;
        }
        int transaction = 3;
        EjbMethodPattern ejbMethod = this.getMethodPattern(null, null);
        if (ejbMethod != null) {
            transaction = ejbMethod.getTransactionType();
        }
        if ((ejbMethod = this.getMethodPattern(method, null)) != null) {
            transaction = ejbMethod.getTransactionType();
        }
        if ((ejbMethod = this.getMethodPattern(method, intf)) != null) {
            transaction = ejbMethod.getTransactionType();
        }
        return transaction;
    }

    Method getMethod(String methodName, Class[] paramTypes) {
        return EjbBean.getMethod(this.getEJBClass(), methodName, paramTypes);
    }

    public static Method getMethod(Class cl, Method sourceMethod) {
        return EjbBean.getMethod(cl, sourceMethod.getName(), sourceMethod.getParameterTypes());
    }

    public static Method getMethod(Class cl, String name, Class[] param) {
        if (cl == null) {
            return null;
        }
        Method[] methods = cl.getDeclaredMethods();
        for (int i = 0; i < methods.length; ++i) {
            if (!EjbBean.isMatch(methods[i], name, param)) continue;
            return methods[i];
        }
        for (Class<?> iface : cl.getInterfaces()) {
            Method method = EjbBean.getMethod(iface, name, param);
            if (method == null) continue;
            return method;
        }
        return EjbBean.getMethod(cl.getSuperclass(), name, param);
    }

    static boolean isMatch(Method methodA, Method methodB) {
        if (methodA == methodB) {
            return true;
        }
        if (methodA == null || methodB == null) {
            return false;
        }
        return EjbBean.isMatch(methodA, methodB.getName(), methodB.getParameterTypes());
    }

    static boolean isMatch(Method method, String name, Class[] param) {
        if (!method.getName().equals(name)) {
            return false;
        }
        Class<?>[] mparam = method.getParameterTypes();
        if (mparam.length != param.length) {
            return false;
        }
        for (int j = 0; j < param.length; ++j) {
            if (mparam[j].equals(param[j])) continue;
            return false;
        }
        return true;
    }

    static Method findMethod(MethodSignature sig, Class cl, String intf) {
        if (cl == null) {
            return null;
        }
        Method[] methods = EjbBean.getMethods(cl);
        for (int i = 0; i < methods.length; ++i) {
            if (!sig.isMatch(methods[i], intf)) continue;
            return methods[i];
        }
        return null;
    }

    static Method[] getMethods(Class cl) {
        Method[] methodArray;
        Map<Class, Method[]> methodMap = _methodCache.get();
        if (methodMap == null) {
            methodMap = new WeakHashMap<Class, Method[]>();
            _methodCache.set(methodMap);
        }
        if ((methodArray = methodMap.get(cl)) != null) {
            return methodArray;
        }
        ArrayList<Method> methods = new ArrayList<Method>();
        EjbBean.getMethods(methods, cl);
        methodArray = methods.toArray(new Method[methods.size()]);
        methodMap.put(cl, methodArray);
        return methodArray;
    }

    static void getMethods(ArrayList<Method> methods, Class cl) {
        if (cl == null) {
            return;
        }
        Method[] subMethods = cl.getDeclaredMethods();
        for (int i = 0; i < subMethods.length; ++i) {
            if (EjbBean.findMethod(methods, subMethods[i]) != null) continue;
            methods.add(subMethods[i]);
        }
        EjbBean.getMethods(methods, cl.getSuperclass());
        Class<?>[] interfaces = cl.getInterfaces();
        for (int i = 0; interfaces != null && i < interfaces.length; ++i) {
            EjbBean.getMethods(methods, interfaces[i]);
        }
    }

    static Method findMethod(ArrayList<Method> methods, Method method) {
        block0: for (int i = 0; i < methods.size(); ++i) {
            Class<?>[] bParamTypes;
            Class<?>[] aParamTypes;
            Method oldMethod = methods.get(i);
            if (!method.getName().equals(oldMethod.getName()) || (aParamTypes = oldMethod.getParameterTypes()).length != (bParamTypes = method.getParameterTypes()).length) continue;
            for (int j = 0; j < aParamTypes.length; ++j) {
                if (!aParamTypes[j].equals(bParamTypes[j])) continue block0;
            }
            return oldMethod;
        }
        return null;
    }

    static String getFullMethodName(Method method) {
        return EjbBean.getFullMethodName(method.getName(), method.getParameterTypes());
    }

    static String getFullMethodName(String methodName, Class[] params) {
        String name = new StringBuffer().append(methodName).append("(").toString();
        for (int i = 0; i < params.length; ++i) {
            if (i != 0) {
                name = new StringBuffer().append(name).append(", ").toString();
            }
            name = new StringBuffer().append(name).append(EjbBean.getShortClassName(params[i])).toString();
        }
        return new StringBuffer().append(name).append(")").toString();
    }

    static String getClassName(Class cl) {
        if (cl == null) {
            return "null";
        }
        if (cl.isArray()) {
            return new StringBuffer().append(EjbBean.getClassName(cl.getComponentType())).append("[]").toString();
        }
        if (cl.getName().startsWith("java")) {
            int p = cl.getName().lastIndexOf(46);
            return cl.getName().substring(p + 1);
        }
        return cl.getName();
    }

    static String getShortClassName(Class cl) {
        if (cl.isArray()) {
            return new StringBuffer().append(EjbBean.getShortClassName(cl.getComponentType())).append("[]").toString();
        }
        int p = cl.getName().lastIndexOf(46);
        return cl.getName().substring(p + 1);
    }

    boolean classHasMethod(Method method, Class cl) {
        try {
            Method match = cl.getMethod(method.getName(), method.getParameterTypes());
            return match != null;
        }
        catch (Exception e) {
            return false;
        }
    }

    void validateException(Method method, Class e) throws ConfigException {
        this.validateExceptions(method, new Class[]{e});
    }

    void validateExceptions(Method method, Class[] exn) throws ConfigException {
        Class<?>[] methodExceptions = method.getExceptionTypes();
        block0: for (int i = 0; i < exn.length; ++i) {
            if (ClassLiteral.getClass((String)"java/lang/RuntimeException").isAssignableFrom(exn[i])) continue;
            for (int j = 0; j < methodExceptions.length; ++j) {
                if (methodExceptions[j].isAssignableFrom(exn[i])) continue block0;
            }
            throw new ConfigException(L.l("{2}: `{0}' must throw {1}.", EjbBean.getFullMethodName(method), exn[i].getName(), method.getDeclaringClass().getName()));
        }
    }

    void validateExceptions(Method caller, Method callee) throws ConfigException {
        Class[] exn = callee.getExceptionTypes();
        Class missing = this.findMissingException(caller, exn);
        if (missing != null) {
            throw this.error(new StringBuffer().append(L.l("{0}: `{1}' must throw {2}.", caller.getDeclaringClass().getName(), EjbBean.getFullMethodName(caller), EjbBean.getShortClassName(missing), caller.getDeclaringClass().getName())).append(L.l(" {0} must throw all {1}.{2} exceptions.", caller.getName(), EjbBean.getShortClassName(callee.getDeclaringClass()), callee.getName())).toString());
        }
    }

    Class findMissingException(Method method, Class[] exn) throws ConfigException {
        Class<?>[] methodExceptions = method.getExceptionTypes();
        for (int i = 0; i < exn.length; ++i) {
            if (this.hasException(method, exn[i]) || ClassLiteral.getClass((String)"java/lang/RuntimeException").isAssignableFrom(exn[i])) continue;
            return exn[i];
        }
        return null;
    }

    boolean hasException(Method method, Class exn) throws ConfigException {
        Class<?>[] methodExceptions = method.getExceptionTypes();
        for (int j = 0; j < methodExceptions.length; ++j) {
            if (!methodExceptions[j].isAssignableFrom(exn)) continue;
            return true;
        }
        return false;
    }

    public ConfigException error(String msg) {
        return new ConfigException(msg);
    }
}

