/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.ejb.cfg;

import com.caucho.amber.AmberManager;
import com.caucho.amber.type.EntityType;
import com.caucho.config.ConfigException;
import com.caucho.config.LineConfigException;
import com.caucho.config.types.Period;
import com.caucho.ejb.AbstractServer;
import com.caucho.ejb.EjbServerManager;
import com.caucho.ejb.amber.AmberConfig;
import com.caucho.ejb.cfg.CmpField;
import com.caucho.ejb.cfg.CmpFieldProxy;
import com.caucho.ejb.cfg.CmpProperty;
import com.caucho.ejb.cfg.CmrMap;
import com.caucho.ejb.cfg.CmrRelation;
import com.caucho.ejb.cfg.EjbAmberSelectMethod;
import com.caucho.ejb.cfg.EjbBaseMethod;
import com.caucho.ejb.cfg.EjbBean;
import com.caucho.ejb.cfg.EjbCmpView;
import com.caucho.ejb.cfg.EjbConfig;
import com.caucho.ejb.cfg.EjbEntityHomeView;
import com.caucho.ejb.cfg.EjbEntityView;
import com.caucho.ejb.cfg.EjbHomeView;
import com.caucho.ejb.cfg.EjbMethodPattern;
import com.caucho.ejb.cfg.EjbObjectView;
import com.caucho.ejb.cfg.MethodSignature;
import com.caucho.ejb.cfg.Query;
import com.caucho.ejb.entity.EntityServer;
import com.caucho.ejb.gen.AmberAssembler;
import com.caucho.ejb.gen.BeanAssembler;
import com.caucho.ejb.gen.EntityAssembler;
import com.caucho.ejb.gen.EntityCreateMethod;
import com.caucho.ejb.gen.EntityFindMethod;
import com.caucho.ejb.gen.EntityHomePoolChain;
import com.caucho.java.JavaWriter;
import com.caucho.java.gen.BaseClass;
import com.caucho.java.gen.BaseMethod;
import com.caucho.java.gen.CallChain;
import com.caucho.java.gen.JavaClassGenerator;
import com.caucho.java.gen.MethodCallChain;
import com.caucho.util.L10N;
import com.rc.retroweaver.runtime.ClassLiteral;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import javax.sql.DataSource;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EjbEntityBean
extends EjbBean {
    private static final L10N L = new L10N(ClassLiteral.getClass((String)"com/caucho/ejb/cfg/EjbEntityBean"));
    private Class _primKeyClass;
    private String _primKeyField;
    private Class _compositeKeyClass;
    private String _cmpVersion = "2.0";
    private boolean _isCMP = false;
    private DataSource _dataSource;
    private String _abstractSchemaName;
    private String _sqlTable;
    private long _cacheTimeout = 2000L;
    private int _cacheSize = -666;
    private boolean _loadLazyOnTransaction = true;
    private boolean _isReadOnly = false;
    private boolean _isReentrant = true;
    private ArrayList<CmpField> _fields = new ArrayList();
    private ArrayList<CmrRelation> _relations = new ArrayList();
    private ArrayList<Method> _stubMethods = new ArrayList();

    public EjbEntityBean(EjbConfig ejbConfig) {
        super(ejbConfig);
        EjbServerManager ejbManager = ejbConfig.getEJBManager();
        this._cacheTimeout = ejbManager.getCacheTimeout();
        this._loadLazyOnTransaction = ejbManager.isEntityLoadLazyOnTransaction();
    }

    @Override
    public String getEJBKind() {
        return "entity";
    }

    @Override
    public void setEJBClass(Class ejbClass) throws ConfigException {
        super.setEJBClass(ejbClass);
        if (!ClassLiteral.getClass((String)"javax/ejb/EntityBean").isAssignableFrom(ejbClass) && !this.isAllowPOJO()) {
            throw this.error(L.l("`{0}' must implement EntityBean.  Entity beans must implement javax.ejb.EntityBean.", ejbClass.getName()));
        }
        this.validateNonFinalMethod("setEntityContext", new Class[]{ClassLiteral.getClass((String)"javax/ejb/EntityContext")}, this.isAllowPOJO());
        this.validateNonFinalMethod("unsetEntityContext", new Class[0], this.isAllowPOJO());
        this.validateNonFinalMethod("ejbActivate", new Class[0], this.isAllowPOJO());
        this.validateNonFinalMethod("ejbPassivate", new Class[0], this.isAllowPOJO());
        this.validateNonFinalMethod("ejbRemove", new Class[0], this.isAllowPOJO());
        this.validateNonFinalMethod("ejbLoad", new Class[0], this.isAllowPOJO());
        this.validateNonFinalMethod("ejbStore", new Class[0], this.isAllowPOJO());
    }

    public EntityType getEntityType() {
        AmberManager amberManager = this.getConfig().getEJBManager().getAmberManager();
        EntityType type = amberManager.createEntity(this.getAbstractSchemaName(), this.getEJBClass());
        type.setProxyClass(this.getLocal());
        return type;
    }

    public Class getPrimKeyClass() {
        return this._primKeyClass;
    }

    public void setPrimKeyClass(Class cl) {
        this._primKeyClass = cl;
    }

    public Class getCompositeKeyClass() {
        return this._compositeKeyClass;
    }

    public String getPrimKeyField() {
        return this._primKeyField;
    }

    public void setPrimKeyField(String field) {
        this._primKeyField = field;
    }

    public void setPersistenceType(String type) throws ConfigException {
        if ("Bean".equals(type)) {
            this._isCMP = false;
        } else if ("Container".equals(type)) {
            this._isCMP = true;
        } else {
            throw new ConfigException(L.l("`{0}' is an known persistence-type.  <persistence-type> must either be `Bean' or `Container'.", type));
        }
    }

    public boolean isCMP() {
        return this._isCMP;
    }

    public void setCMP(boolean isCMP) {
        this._isCMP = isCMP;
    }

    @Override
    public String getFullImplName() {
        if (this.isCMP()) {
            String name = new StringBuffer().append("_ejb.").append(this.getEJBName()).append(".").append(this.getEJBClassName()).append("__Amber").toString();
            return JavaClassGenerator.cleanClassName(name);
        }
        return super.getFullImplName();
    }

    public void setCmpVersion(String version) throws ConfigException {
        this._cmpVersion = version;
        if (!version.equals("2.x")) {
            throw this.error(L.l("CMP version `{0}' is not currently supported.  Only CMP version 2.x is supported.", version));
        }
    }

    public void setReentrant(boolean reentrant) throws ConfigException {
        this._isReentrant = reentrant;
    }

    public DataSource getDataSource() {
        return this._dataSource;
    }

    public void setDataSource(DataSource dataSource) {
        this._dataSource = dataSource;
    }

    public String getAbstractSchemaName() {
        if (this._abstractSchemaName != null) {
            return this._abstractSchemaName;
        }
        String name = this.getEJBName();
        int p = name.lastIndexOf(47);
        if (p < 0) {
            return name;
        }
        return name.substring(p + 1);
    }

    public void setAbstractSchemaName(String abstractSchema) {
        this._abstractSchemaName = abstractSchema;
    }

    public String getSQLTable() {
        return this._sqlTable;
    }

    public void setSQLTable(String sqlTable) {
        this._sqlTable = sqlTable;
    }

    public int getCacheSize() {
        return this._cacheSize;
    }

    public void setCacheSize(int cacheSize) {
        this._cacheSize = cacheSize;
    }

    public void setCacheTimeout(Period cacheTimeout) {
        this._cacheTimeout = cacheTimeout.getPeriod();
    }

    public long getCacheTimeout() {
        return this._cacheTimeout;
    }

    public boolean isReadOnly() {
        return this._isReadOnly;
    }

    public void setReadOnly(boolean isReadOnly) {
        this._isReadOnly = isReadOnly;
    }

    public CmpFieldProxy createCmpField() {
        return new CmpFieldProxy(this);
    }

    public ArrayList<CmpField> getCmpFields() {
        return this._fields;
    }

    public CmpField getCmpField(String fieldName) {
        for (int i = 0; i < this._fields.size(); ++i) {
            CmpField field = this._fields.get(i);
            if (!field.getName().equals(fieldName)) continue;
            return field;
        }
        return null;
    }

    public CmpField addField(String fieldName) throws ConfigException {
        CmpField field = this.getCmpField(fieldName);
        if (field == null) {
            field = new CmpField(this);
            field.setFieldName(fieldName);
            field.init();
            this._fields.add(field);
        }
        return field;
    }

    public Method getFieldGetter(String fieldName) {
        if (fieldName == null) {
            return null;
        }
        String methodName = new StringBuffer().append("get").append(Character.toUpperCase(fieldName.charAt(0))).append(fieldName.substring(1)).toString();
        try {
            return EjbEntityBean.getMethod(this.getEJBClass(), methodName, new Class[0]);
        }
        catch (Throwable e) {
            return null;
        }
    }

    public void addRelation(CmrRelation relation) throws ConfigException {
        String fieldName = relation.getName();
        Method method = this.getMethodField(fieldName);
        if (method == null && !(relation instanceof CmrMap)) {
            throw this.error(L.l("'{0}' is a missing method", fieldName));
        }
        this._relations.add(relation);
    }

    public CmrRelation getRelation(String relationName) {
        for (int i = 0; i < this._relations.size(); ++i) {
            CmrRelation relation = this._relations.get(i);
            if (!relationName.equals(relation.getName())) continue;
            return relation;
        }
        return null;
    }

    public ArrayList<CmrRelation> getRelations() {
        return this._relations;
    }

    public ArrayList<Method> getStubMethods() {
        return this._stubMethods;
    }

    public void addStubMethod(Method method) {
        if (!this._stubMethods.contains(method)) {
            this._stubMethods.add(method);
        }
    }

    public Class getFieldType(String fieldName) {
        Method method = this.getMethodField(fieldName);
        if (method != null) {
            return method.getReturnType();
        }
        return null;
    }

    public Query createQuery() {
        return new Query(this);
    }

    public void addQuery(Query query) {
        MethodSignature sig = query.getSignature();
        EjbMethodPattern method = this.getMethod(sig);
        if (method == null) {
            method = new EjbMethodPattern(this, sig);
            method.setLocation(query.getConfigLocation());
            this._methodList.add(method);
        }
        method.setQueryLocation(query.getConfigLocation());
        method.setQuery(query.getEjbQl());
    }

    public EjbMethodPattern getMethod(MethodSignature sig) {
        for (int i = 0; i < this._methodList.size(); ++i) {
            EjbMethodPattern method = (EjbMethodPattern)this._methodList.get(i);
            if (!method.getSignature().equals(sig)) continue;
            return method;
        }
        return null;
    }

    public EjbMethodPattern getQuery(Method method, String intf) {
        return this.getMethodPattern(method, intf);
    }

    public ArrayList<EjbMethodPattern> getQueryList() {
        return this._methodList;
    }

    @Override
    public void init() throws ConfigException {
        try {
            if (!this.isCMP() && Modifier.isAbstract(this.getEJBClass().getModifiers())) {
                throw this.error(L.l("'{0}' must not be abstract. BMP entity beans may not be abstract.", this.getEJBClass().getName()));
            }
            super.init();
            if (!(this._primKeyClass != null || this.isAllowPOJO() || this.getRemote() == null && this.getLocal() == null)) {
                throw new ConfigException(L.l("{0}: <entity> has no primary key class.  Entity beans must define a prim-key-class.", this.getEJBClass().getName()));
            }
            if (this.getRemoteHome() != null) {
                this.validateHome(this.getRemoteHome());
            }
            if (this.getLocalHome() != null) {
                this.validateHome(this.getLocalHome());
            }
            if (this.getRemote() != null) {
                this.validateRemote(this.getRemote());
            }
            if (this.getLocal() != null) {
                this.validateRemote(this.getLocal());
            }
            this.validateMethods();
        }
        catch (LineConfigException e) {
            throw e;
        }
        catch (ConfigException e) {
            throw new LineConfigException(new StringBuffer().append(this.getLocation()).append(e.getMessage()).toString(), e);
        }
    }

    @Override
    public void introspect() throws ConfigException {
        if (this.isCMP()) {
            this.introspectCMPFields();
            this.introspectCMPId();
            this.validateCMPFields();
        }
    }

    protected void introspectCMPFields() throws ConfigException {
        Method[] methods = EjbEntityBean.getMethods(this.getEJBClass());
        for (int i = 0; i < methods.length; ++i) {
            String fieldName;
            CmrRelation rel;
            String name;
            Method method = methods[i];
            if (!Modifier.isAbstract(method.getModifiers()) || !(name = method.getName()).startsWith("get") || name.length() <= 3 || method.getParameterTypes().length != 0 || (rel = this.getRelation(fieldName = EjbEntityBean.getterToFieldName(name))) != null) continue;
            Class<?> type = method.getReturnType();
            if (ClassLiteral.getClass((String)"java/util/Collection").isAssignableFrom(type)) {
                throw this.error(L.l("'{0}' needs to be a relation", fieldName));
            }
            if (ClassLiteral.getClass((String)"javax/ejb/EJBLocalObject").isAssignableFrom(type)) {
                throw this.error(L.l("{0}: '{1}' needs to be defined in an ejb-relation for getter method {2}.", this.getEJBClass().getName(), fieldName, EjbEntityBean.getFullMethodName(method)));
            }
            if (ClassLiteral.getClass((String)"javax/ejb/EJBObject").isAssignableFrom(type)) {
                throw this.error(L.l("'{0}' needs to be a relation", fieldName));
            }
            CmpField cmpField = this.addField(fieldName);
            cmpField.setJavaType(method.getReturnType());
        }
    }

    protected void validateCMPFields() throws ConfigException {
        Method[] methods = EjbEntityBean.getMethods(this.getEJBClass());
        for (int i = 0; i < methods.length; ++i) {
            String fieldName;
            String name;
            Method method = methods[i];
            if (!Modifier.isAbstract(method.getModifiers()) || (name = method.getName()).startsWith("ejb")) continue;
            if (name.startsWith("get") && name.length() > 3 && method.getParameterTypes().length == 0) {
                fieldName = EjbEntityBean.getterToFieldName(name);
                if (this.getCmpField(fieldName) != null || this.getRelation(fieldName) != null) {
                    continue;
                }
            } else if (name.startsWith("get") && name.length() > 3 && method.getParameterTypes().length == 1) {
                CmrMap map;
                fieldName = EjbEntityBean.getterToFieldName(name);
                CmrRelation rel = this.getRelation(fieldName);
                if (rel instanceof CmrMap && method.equals((map = (CmrMap)rel).getMapMethod())) {
                    continue;
                }
            } else if (name.startsWith("set") && name.length() > 3 && method.getParameterTypes().length == 1) {
                fieldName = EjbEntityBean.getterToFieldName(name);
                CmpField field = this.getCmpField(fieldName);
                if (field != null) {
                    if (EjbEntityBean.isMatch(method, field.getSetter())) continue;
                    throw new ConfigException(L.l("{0}: '{1}' does not match the corresponding cmp-field getter '{2}'.", this.getEJBClass().getName(), EjbEntityBean.getFullMethodName(method), EjbEntityBean.getFullMethodName(field.getGetter())));
                }
                CmrRelation rel = this.getRelation(fieldName);
                if (rel != null) {
                    if (method.equals(rel.getSetter())) continue;
                    throw new ConfigException(L.l("{0}: '{1}' does not match the corresponding cmp-field getter '{2}'.", this.getEJBClass().getName(), EjbEntityBean.getFullMethodName(method), EjbEntityBean.getFullMethodName(rel.getGetter())));
                }
            }
            throw this.error(L.l("{0}: '{1}' must not be abstract.  Business methods must be implemented.", (Object)this.getEJBClass().getName(), EjbEntityBean.getFullMethodName(method)));
        }
    }

    protected void introspectCMPId() throws ConfigException {
        CmpProperty property;
        if (!(this._primKeyClass == null || this._primKeyClass.isPrimitive() || this._primKeyClass.getName().startsWith("java.lang.") || this._primKeyClass.getName().equals("java.util.Date") || this._primKeyClass.getName().equals("java.sql.Date") || this._primKeyClass.getName().equals("java.sql.Time") || this._primKeyClass.getName().equals("java.sql.Timestamp") || ClassLiteral.getClass((String)"javax/ejb/EJBLocalObject").isAssignableFrom(this._primKeyClass))) {
            if (this._primKeyField != null) {
                throw this.error(L.l("{0}: 'primkey-field' must not be defined for a composite primkey-class.", this.getEJBClass().getName()));
            }
            this._compositeKeyClass = this._primKeyClass;
            this.introspectCMPCompositeId();
            return;
        }
        String id = this._primKeyField;
        if (id == null) {
            id = "id";
        }
        if ((property = this.getCmpField(id)) == null) {
            property = this.getRelation(id);
        }
        if (property == null) {
            throw this.error(L.l("{0}: primary key field '{1}' is an unknown cmp-field", (Object)this.getEJBClass().getName(), id));
        }
        property.setId(true);
    }

    protected void introspectCMPCompositeId() throws ConfigException {
        try {
            Method equals = this._primKeyClass.getMethod("equals", ClassLiteral.getClass((String)"java/lang/Object"));
            if (equals.getDeclaringClass().equals(ClassLiteral.getClass((String)"java/lang/Object"))) {
                throw this.error(L.l("{0}: primary key class '{1}' must override the 'equals' method.", (Object)this.getEJBClass().getName(), this._primKeyClass.getName()));
            }
        }
        catch (ConfigException e) {
            throw e;
        }
        catch (Throwable e) {
            // empty catch block
        }
        try {
            Method hashCode = this._primKeyClass.getMethod("hashCode", new Class[0]);
            if (hashCode.getDeclaringClass().equals(ClassLiteral.getClass((String)"java/lang/Object"))) {
                throw this.error(L.l("{0}: primary key class '{1}' must override the 'hashCode' method.", (Object)this.getEJBClass().getName(), this._primKeyClass.getName()));
            }
        }
        catch (ConfigException e) {
            throw e;
        }
        catch (Throwable e) {
            // empty catch block
        }
        if (this._primKeyClass.getFields().length == 0) {
            throw this.error(L.l("{0}: compound key '{1}' has no public accessible fields.  Compound key fields must be public.", (Object)this.getEJBClass().getName(), this._primKeyClass.getName()));
        }
        for (Field field : this._primKeyClass.getFields()) {
            CmpProperty cmpProperty = this.getCmpField(field.getName());
            if (cmpProperty == null) {
                cmpProperty = this.getRelation(field.getName());
            }
            if (cmpProperty == null) {
                throw this.error(L.l("{0}: primary key field '{1}' is an unknown field.", (Object)this.getEJBClass().getName(), field.getName()));
            }
            cmpProperty.setId(true);
        }
    }

    private static String getterToFieldName(String name) {
        String fieldName = name.substring(3);
        char ch = fieldName.charAt(0);
        if (Character.isUpperCase(ch) && (fieldName.length() == 1 || Character.isLowerCase(fieldName.charAt(1)))) {
            fieldName = new StringBuffer().append(Character.toLowerCase(ch)).append(fieldName.substring(1)).toString();
        }
        return fieldName;
    }

    @Override
    public void configureAmber(AmberConfig config) throws ConfigException {
        if (this.isCMP()) {
            try {
                config.addBean(this);
            }
            catch (LineConfigException e) {
                throw e;
            }
            catch (Exception e) {
                throw new LineConfigException(new StringBuffer().append(this.getLocation()).append(e.getMessage()).toString(), e);
            }
        }
    }

    @Override
    protected BeanAssembler createAssembler(String fullClassName) {
        if (this.isCMP()) {
            return new AmberAssembler(this, fullClassName);
        }
        return new EntityAssembler(this, fullClassName);
    }

    @Override
    protected void addImports(BeanAssembler assembler) {
        super.addImports(assembler);
        assembler.addImport("com.caucho.ejb.FinderExceptionWrapper");
        assembler.addImport("com.caucho.ejb.entity.EntityServer");
        assembler.addImport("com.caucho.ejb.entity.QEntityContext");
        assembler.addImport("com.caucho.ejb.entity.EntityHome");
        assembler.addImport("com.caucho.ejb.entity.EntityLocalHome");
        assembler.addImport("com.caucho.ejb.entity.EntityRemoteHome");
        assembler.addImport("com.caucho.ejb.entity.EntityObject");
        assembler.addImport("com.caucho.ejb.entity.QEntity");
    }

    @Override
    protected EjbBaseMethod introspectEJBMethod(Method method) throws ConfigException {
        String methodName = method.getName();
        Class<?>[] paramTypes = method.getParameterTypes();
        if (methodName.startsWith("ejbSelect") && Modifier.isAbstract(method.getModifiers())) {
            this.validateSelectMethod(method);
            EjbMethodPattern pattern = this.getMethodPattern(method, "Local");
            if (pattern == null) {
                throw this.error(L.l("{0}: '{1}' expects an ejb-ql query. ejbSelect methods must have an ejb-ql query in the deployment descriptor.", (Object)this.getEJBClass().getName(), EjbEntityBean.getFullMethodName(method)));
            }
            String query = pattern.getQuery();
            EjbAmberSelectMethod select = new EjbAmberSelectMethod(this, method, query, pattern.getQueryLocation());
            select.setQueryLoadsBean(pattern.getQueryLoadsBean());
            return select;
        }
        return null;
    }

    @Override
    protected void validateImplMethod(Method method) throws ConfigException {
        String methodName = method.getName();
        Class<?>[] paramTypes = method.getParameterTypes();
        if (!(Modifier.isAbstract(method.getModifiers()) && methodName.startsWith("get") && paramTypes.length == 0 || Modifier.isAbstract(method.getModifiers()) && methodName.startsWith("get") && paramTypes.length == 1 || Modifier.isAbstract(method.getModifiers()) && methodName.startsWith("set") && paramTypes.length == 1 || methodName.startsWith("ejb") || !Modifier.isAbstract(method.getModifiers()))) {
            throw this.error(L.l("{0}: '{1}' must not be abstract.  The bean must implement its business methods.", (Object)this.getEJBClass().getName(), EjbEntityBean.getFullMethodName(method)));
        }
    }

    private void validateSelectMethod(Method method) throws ConfigException {
        if (!Modifier.isPublic(method.getModifiers())) {
            throw this.error(L.l("{0}: '{1}' must be public. ejbSelect methods must be public.", (Object)this.getEJBClass().getName(), EjbEntityBean.getFullMethodName(method)));
        }
        if (Modifier.isStatic(method.getModifiers())) {
            throw this.error(L.l("{0}: `{1}' must not be static. ejbSelect methods must not be static.", (Object)this.getEJBClass().getName(), EjbEntityBean.getFullMethodName(method)));
        }
        if (!Modifier.isAbstract(method.getModifiers())) {
            throw this.error(L.l("{0}: `{1}' must be abstract. ejbSelect methods must be abstract.", (Object)this.getEJBClass().getName(), EjbEntityBean.getFullMethodName(method)));
        }
    }

    @Override
    protected EjbHomeView createHomeView(Class homeClass, String prefix) throws ConfigException {
        return new EjbEntityHomeView(this, homeClass, prefix);
    }

    @Override
    protected EjbObjectView createObjectView(Class apiClass, String prefix) throws ConfigException {
        if (this.isCMP()) {
            return new EjbCmpView(this, apiClass, prefix);
        }
        return new EjbEntityView(this, apiClass, prefix);
    }

    @Override
    public AbstractServer deployServer(EjbServerManager ejbManager, JavaClassGenerator javaGen) throws ClassNotFoundException {
        EntityServer server = new EntityServer(ejbManager);
        server.setEJBName(this.getEJBName());
        server.setRemoteHomeClass(this.getRemoteHome());
        server.setRemoteObjectClass(this.getRemote());
        Class contextImplClass = javaGen.loadClass(this.getSkeletonName());
        server.setContextImplClass(contextImplClass);
        server.setCMP(this.isCMP());
        server.setPrimaryKeyClass(this._primKeyClass);
        server.setLoadLazyOnTransaction(this._loadLazyOnTransaction);
        server.setInitProgram(this.getInitProgram());
        if (this.isCMP()) {
            server.setAmberEntityHome(this.getEntityType().getHome());
        }
        return server;
    }

    private void validateMethods() throws ConfigException {
        Class primKeyClass = this.getPrimKeyClass();
        Method[] methods = EjbEntityBean.getMethods(this.getEJBClass());
        for (int i = 0; i < methods.length; ++i) {
            Method method = methods[i];
            String name = method.getName();
            try {
                method = this.getEJBClass().getMethod(name, method.getParameterTypes());
            }
            catch (Exception e) {
                // empty catch block
            }
            if (ClassLiteral.getClass((String)"javax/ejb/EntityBean").isAssignableFrom(method.getReturnType())) {
                throw this.error(L.l("{0}: `{1}' must not return entity bean `{2}'.  Entity bean methods must always return local or remote interfaces.", this.getEJBClass().getName(), EjbEntityBean.getFullMethodName(method), EjbEntityBean.getShortClassName(method.getReturnType())));
            }
            if (name.startsWith("ejbFind")) {
                if (!this.isCMP()) {
                    this.validateNonFinalMethod(method.getName(), method.getParameterTypes());
                    continue;
                }
                this.validateNonFinalMethod(method.getName(), method.getParameterTypes());
                continue;
            }
            if (name.startsWith("ejbSelect")) {
                if (!Modifier.isAbstract(method.getModifiers())) {
                    throw this.error(L.l("{0}: `{1}' must be abstract. ejbSelect methods must be abstract.", (Object)method.getDeclaringClass().getName(), EjbEntityBean.getFullMethodName(method)));
                }
                if (!Modifier.isPublic(method.getModifiers())) {
                    throw this.error(L.l("{0}: `{1}' must be public.", (Object)method.getDeclaringClass().getName(), EjbEntityBean.getFullMethodName(method)));
                }
                this.validateException(method, ClassLiteral.getClass((String)"javax/ejb/FinderException"));
                continue;
            }
            if (name.startsWith("ejbCreate")) {
                this.validateNonFinalMethod(method.getName(), method.getParameterTypes());
                if (!this.isPrimaryKeyClass(method.getReturnType())) {
                    throw this.error(L.l("{0}: `{1}' must return `{2}'.  ejbCreate methods must return the primary key.", method.getDeclaringClass().getName(), EjbEntityBean.getFullMethodName(method), EjbEntityBean.getClassName(primKeyClass)));
                }
                if (!this.isCMP()) continue;
                this.validateException(method, ClassLiteral.getClass((String)"javax/ejb/CreateException"));
                continue;
            }
            if (name.startsWith("ejbPostCreate")) {
                this.validateNonFinalMethod(method.getName(), method.getParameterTypes());
                if (method.getReturnType().equals(Void.TYPE)) continue;
                throw this.error(L.l("{0}: `{1}' must return void. ejbPostCreate methods must return void.", (Object)method.getDeclaringClass().getName(), EjbEntityBean.getFullMethodName(method)));
            }
            if (name.startsWith("create") && Modifier.isAbstract(method.getModifiers())) continue;
            if (name.startsWith("ejbHome")) {
                this.validateNonFinalMethod(method.getName(), method.getParameterTypes());
                continue;
            }
            if (name.equals("ejbRemove")) {
                if (method.getParameterTypes().length == 0) continue;
                throw this.error(L.l("{0}: `{1}' must have no arguments.", (Object)method.getDeclaringClass().getName(), EjbEntityBean.getFullMethodName(method)));
            }
            if (this.classHasMethod(method, ClassLiteral.getClass((String)"javax/ejb/EntityBean"))) continue;
            if (name.equals("finalize") && method.getParameterTypes().length == 0 && !method.getDeclaringClass().equals(ClassLiteral.getClass((String)"java/lang/Object"))) {
                throw this.error(L.l("{0}: Entity beans must not define `finalize'.", this.getEJBClass().getClass()));
            }
            if (name.startsWith("ejb")) {
                throw this.error(L.l("{0}: `{1}' must not start with `ejb'.  ejbXXX methods are reserved by the EJB spec.", (Object)method.getDeclaringClass().getName(), EjbEntityBean.getFullMethodName(method)));
            }
            boolean isAbstract = Modifier.isAbstract(method.getModifiers());
            Object persist = null;
            if (!isAbstract || !this.isCMP() || method.getName().startsWith("get") || method.getName().startsWith("set") || method.getName().startsWith("ejbSelect")) continue;
            throw this.error(L.l("{0}: `{1}' must not be abstract.  Only CMP methods may be abstract.", (Object)method.getDeclaringClass().getName(), EjbEntityBean.getFullMethodName(method)));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void validateHome(Class homeClass) throws ConfigException {
        Class beanClass = this.getEJBClass();
        String beanName = this.getEJBClass().getName();
        String homeName = homeClass.getName();
        Class objectClass = ClassLiteral.getClass((String)"javax/ejb/EJBHome").isAssignableFrom(homeClass) ? this.getRemote() : this.getLocal();
        String objectName = objectClass != null ? objectClass.getName() : null;
        boolean hasFindByPrimaryKey = false;
        Class primKeyClass = this.getPrimKeyClass();
        if (!Modifier.isPublic(homeClass.getModifiers())) {
            throw this.error(L.l("`{0}' must be public. Entity beans must be public.", homeName));
        }
        if (Modifier.isFinal(beanClass.getModifiers())) {
            throw this.error(L.l("`{0}' must not be final.  Entity beans must not be final.", beanName));
        }
        if (!this.isCMP() && Modifier.isAbstract(beanClass.getModifiers())) {
            throw this.error(L.l("`{0}' must not be abstract. BMP entity beans must not be abstract.", beanName));
        }
        if (!Modifier.isInterface(homeClass.getModifiers())) {
            throw this.error(L.l("`{0}' must be an interface.", homeName));
        }
        Method[] methods = EjbEntityBean.getMethods(homeClass);
        for (int i = 0; i < methods.length; ++i) {
            Method implMethod;
            Method method = methods[i];
            String name = method.getName();
            Class[] param = method.getParameterTypes();
            Class<?> retType = method.getReturnType();
            if (method.getDeclaringClass().isAssignableFrom(ClassLiteral.getClass((String)"javax/ejb/EJBHome")) || method.getDeclaringClass().isAssignableFrom(ClassLiteral.getClass((String)"javax/ejb/EJBLocalHome"))) continue;
            if (ClassLiteral.getClass((String)"javax/ejb/EJBHome").isAssignableFrom(homeClass)) {
                this.validateException(method, ClassLiteral.getClass((String)"java/rmi/RemoteException"));
            }
            if (name.startsWith("create")) {
                this.validateExceptions(method, new Class[]{ClassLiteral.getClass((String)"javax/ejb/CreateException")});
                if (!retType.equals(objectClass)) {
                    throw this.error(L.l("{0}: `{1}' must return {2}.  Create methods must return the local or remote interface.", homeName, EjbEntityBean.getFullMethodName(method), objectName));
                }
                String createName = new StringBuffer().append("ejbC").append(name.substring(1)).toString();
                implMethod = this.validateNonFinalMethod(createName, param, method, homeClass);
                if (!this.isPrimaryKeyClass(implMethod.getReturnType())) {
                    throw this.error(L.l("{0}: `{1}' must return `{2}'.  ejbCreate methods must return the primary key.", beanName, EjbEntityBean.getFullMethodName(createName, param), EjbEntityBean.getClassName(primKeyClass)));
                }
                if (!this.hasException(implMethod, ClassLiteral.getClass((String)"javax/ejb/CreateException"))) {
                    throw this.error(L.l("{0}: `{1}' must throw {2}.  ejbCreate methods must throw CreateException.", implMethod.getDeclaringClass().getName(), EjbEntityBean.getFullMethodName(implMethod), "CreateException"));
                }
                this.validateExceptions(method, implMethod);
                createName = new StringBuffer().append("ejbPostC").append(name.substring(1)).toString();
                implMethod = this.validateNonFinalMethod(createName, param, method, homeClass);
                if (!implMethod.getReturnType().equals(Void.TYPE)) {
                    throw this.error(L.l("{0}: `{1}' must return {2}. ejbPostCreate methods must return void.", beanName, EjbEntityBean.getFullMethodName(createName, param), "void"));
                }
                this.validateExceptions(method, implMethod);
                continue;
            }
            if (name.startsWith("find")) {
                String query;
                if (name.equals("findByPrimaryKey")) {
                    hasFindByPrimaryKey = true;
                    if (!objectClass.equals(method.getReturnType())) {
                        throw this.error(L.l("{0}: `{1}' must return `{2}'.  Find methods must return the remote or local interface.", homeName, EjbEntityBean.getFullMethodName(method), objectName));
                    }
                }
                String findName = new StringBuffer().append("ejbF").append(name.substring(1)).toString();
                if (!this.isCMP() || EjbEntityBean.getMethod(beanClass, findName, param) != null) {
                    Method impl = this.validateNonFinalMethod(findName, param, this.isAllowPOJO());
                    if (impl != null) {
                        this.validateExceptions(method, impl);
                    }
                    if (objectClass.equals(method.getReturnType())) {
                        if (impl != null && !this.isPrimaryKeyClass(impl.getReturnType())) {
                            throw this.error(L.l("{0}: `{1}' must return primary key `{2}'.  ejbFind methods must return the primary key", beanName, EjbEntityBean.getFullMethodName(impl), EjbEntityBean.getClassName(primKeyClass)));
                        }
                    } else if (ClassLiteral.getClass((String)"java/util/Collection").isAssignableFrom(method.getReturnType())) {
                        if (impl != null && !ClassLiteral.getClass((String)"java/util/Collection").isAssignableFrom(impl.getReturnType())) {
                            throw this.error(L.l("{0}: `{1}' must return collection.", (Object)beanName, EjbEntityBean.getFullMethodName(impl)));
                        }
                    } else {
                        if (!ClassLiteral.getClass((String)"java/util/Enumeration").isAssignableFrom(method.getReturnType())) throw this.error(L.l("{0}: `{1}' must return `{2}' or a collection. ejbFind methods must return the primary key or a collection.", homeName, EjbEntityBean.getFullMethodName(method), objectName));
                        if (!ClassLiteral.getClass((String)"java/util/Enumeration").isAssignableFrom(impl.getReturnType())) {
                            throw this.error(L.l("{0}: `{1}' must return enumeration.", (Object)beanName, EjbEntityBean.getFullMethodName(impl)));
                        }
                    }
                } else if (this.isCMP() && !name.equals("findByPrimaryKey") && (query = this.findQuery(method)) == null) {
                    throw this.error(L.l("{0}: `{1}' expects an ejb-ql query.  All find methods need queries defined in the EJB deployment descriptor.", (Object)homeName, EjbEntityBean.getFullMethodName(method)));
                }
                this.validateException(method, ClassLiteral.getClass((String)"javax/ejb/FinderException"));
                if (retType.equals(objectClass) || (ClassLiteral.getClass((String)"java/util/Collection").isAssignableFrom(retType) || ClassLiteral.getClass((String)"java/util/Enumeration").equals(retType)) && !name.equals("findByPrimaryKey")) continue;
                throw this.error(L.l("{0}: `{1}' must return {2} or a collection. ejbFind methods must return the primary key or a collection.", homeName, EjbEntityBean.getFullMethodName(method), objectName));
            }
            if (name.startsWith("ejbSelect")) {
                throw this.error(L.l("{0}: `{1}' forbidden.  ejbSelect methods may not be exposed in the remote or local interface.", (Object)homeName, EjbEntityBean.getFullMethodName(method)));
            }
            if (name.startsWith("ejb")) {
                throw this.error(L.l("{0}: `{1}' forbidden.  Only ejbXXX methods defined by the spec are allowed.", (Object)homeName, EjbEntityBean.getFullMethodName(method)));
            }
            if (name.startsWith("remove")) {
                throw this.error(L.l("{0}: `{1}' forbidden.  removeXXX methods are reserved by the spec.", (Object)homeName, EjbEntityBean.getFullMethodName(method)));
            }
            retType = method.getReturnType();
            if (ClassLiteral.getClass((String)"javax/ejb/EJBHome").isAssignableFrom(homeClass) && (ClassLiteral.getClass((String)"javax/ejb/EJBLocalObject").isAssignableFrom(retType) || ClassLiteral.getClass((String)"javax/ejb/EJBLocalHome").isAssignableFrom(retType))) {
                throw this.error(L.l("{1}: `{0}' must not return local interface.", (Object)homeClass.getName(), EjbEntityBean.getFullMethodName(method)));
            }
            String homeMethodName = new StringBuffer().append("ejbHome").append(Character.toUpperCase(name.charAt(0))).append(name.substring(1)).toString();
            implMethod = this.validateMethod(homeMethodName, param, method, homeClass);
            if (!retType.equals(implMethod.getReturnType())) {
                throw this.error(L.l("{0}: `{1}' must return {2}.", beanName, EjbEntityBean.getFullMethodName(implMethod), method.getReturnType().getName()));
            }
            this.validateExceptions(method, implMethod.getExceptionTypes());
        }
        if (hasFindByPrimaryKey || this.isAllowPOJO() || objectClass == null) return;
        throw this.error(L.l("{0}: expected `{1}'. All entity homes must define findByPrimaryKey.", (Object)homeName, EjbEntityBean.getFullMethodName("findByPrimaryKey", new Class[]{primKeyClass})));
    }

    @Override
    protected void assembleHomeMethods(BeanAssembler assembler, BaseClass baseClass, String contextClassName, Class homeClass, String prefix) throws NoSuchMethodException {
        Method[] methods = EjbEntityBean.getMethods(homeClass);
        for (int i = 0; i < methods.length; ++i) {
            String name;
            Method beanMethod;
            String className = methods[i].getDeclaringClass().getName();
            String methodName = methods[i].getName();
            if (className.startsWith("javax.ejb.") || EjbEntityBean.isOld(methods, methods[i], i)) continue;
            if (methodName.startsWith("create")) {
                this.assembleCreateMethod(methods[i], baseClass, contextClassName, prefix);
                continue;
            }
            if (methodName.startsWith("find")) {
                beanMethod = null;
                name = new StringBuffer().append("ejb").append(Character.toUpperCase(methodName.charAt(0))).append(methodName.substring(1)).toString();
                try {
                    beanMethod = this.getEJBClass().getMethod(name, methods[i].getParameterTypes());
                }
                catch (Throwable e) {
                    // empty catch block
                }
                if (beanMethod == null) continue;
                EntityFindMethod findMethod = new EntityFindMethod(methods[i], beanMethod, contextClassName, prefix);
                CallChain call = findMethod.getCall();
                call = new EntityHomePoolChain(call);
                findMethod.setCall(call);
                baseClass.addMethod(findMethod);
                continue;
            }
            beanMethod = null;
            name = new StringBuffer().append("ejbHome").append(Character.toUpperCase(methodName.charAt(0))).append(methodName.substring(1)).toString();
            try {
                beanMethod = this.getEJBClass().getMethod(name, methods[i].getParameterTypes());
            }
            catch (Exception e) {
                throw new NoSuchMethodException(new StringBuffer().append("can't find method ").append(name).toString());
            }
            CallChain call = new MethodCallChain(beanMethod);
            call = this.getTransactionChain(call, beanMethod, prefix);
            baseClass.addMethod(new BaseMethod(methods[i], call));
        }
    }

    protected void assembleCreateMethod(Method method, BaseClass baseClass, String contextClassName, String prefix) {
        String methodName = method.getName();
        Method beanCreateMethod = null;
        Method beanPostCreateMethod = null;
        String name = new StringBuffer().append("ejb").append(Character.toUpperCase(methodName.charAt(0))).append(methodName.substring(1)).toString();
        try {
            beanCreateMethod = this.getEJBClass().getMethod(name, method.getParameterTypes());
        }
        catch (Throwable e) {
            // empty catch block
        }
        if (beanCreateMethod == null) {
            throw new IllegalStateException(name);
        }
        name = new StringBuffer().append("ejbPost").append(Character.toUpperCase(methodName.charAt(0))).append(methodName.substring(1)).toString();
        try {
            beanPostCreateMethod = this.getEJBClass().getMethod(name, method.getParameterTypes());
        }
        catch (Throwable e) {
            // empty catch block
        }
        EntityCreateMethod createMethod = new EntityCreateMethod(this, method, beanCreateMethod, beanPostCreateMethod, contextClassName);
        createMethod.setCall(this.getTransactionChain(createMethod.getCall(), method, prefix));
        baseClass.addMethod(createMethod);
    }

    private boolean isPrimaryKeyClass(Class type) {
        return type.equals(this.getPrimKeyClass());
    }

    private Method getMethodField(String fieldName) {
        String getter = new StringBuffer().append("get").append(Character.toUpperCase(fieldName.charAt(0))).append(fieldName.substring(1)).toString();
        Method[] methods = EjbEntityBean.getMethods(this.getEJBClass());
        for (int i = 0; i < methods.length; ++i) {
            if (!getter.equals(methods[i].getName()) || methods[i].getParameterTypes().length != 0) continue;
            return methods[i];
        }
        return null;
    }

    private String findQuery(Method method) throws ConfigException {
        EjbMethodPattern ejbMethod = this.getMethodPattern(method, null);
        if (ejbMethod != null && ejbMethod.getQuery() != null) {
            return ejbMethod.getQuery();
        }
        EjbMethodPattern ejbQuery = this.getQuery(method, null);
        if (ejbQuery != null) {
            return ejbQuery.getQuery();
        }
        return null;
    }

    public boolean dependsOn(EjbEntityBean target) {
        for (CmrRelation rel : this._relations) {
            EjbEntityBean targetBean;
            if (!rel.isId() || target != (targetBean = rel.getTargetBean()) && (targetBean == null || !targetBean.dependsOn(target))) continue;
            return true;
        }
        return false;
    }

    public void generateBeanPrologue(JavaWriter out) throws IOException {
    }

    public void generateAfterCommit(JavaWriter out) throws IOException {
        for (CmrRelation rel : this._relations) {
            rel.generateAfterCommit(out);
        }
    }

    public void generateDestroy(JavaWriter out) throws IOException {
        for (CmrRelation rel : this._relations) {
            rel.generateDestroy(out);
        }
    }

    public String toString() {
        return new StringBuffer().append("EjbEntityBean[").append(this.getEJBName()).append("]").toString();
    }
}

