/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.ejb.cfg;

import com.caucho.config.ConfigException;
import com.caucho.ejb.cfg.EjbAmberFindMethod;
import com.caucho.ejb.cfg.EjbBean;
import com.caucho.ejb.cfg.EjbEntityBean;
import com.caucho.ejb.cfg.EjbEntityCreateMethod;
import com.caucho.ejb.cfg.EjbEntityFindMethod;
import com.caucho.ejb.cfg.EjbHomeView;
import com.caucho.ejb.cfg.EjbMethod;
import com.caucho.ejb.cfg.EjbMethodPattern;
import com.caucho.log.Log;
import com.caucho.util.L10N;
import com.rc.retroweaver.runtime.ClassLiteral;
import java.lang.reflect.Method;
import java.util.logging.Logger;

public class EjbEntityHomeView
extends EjbHomeView {
    private static final Logger log = Log.open(ClassLiteral.getClass((String)"com/caucho/ejb/cfg/EjbEntityHomeView"));
    private static final L10N L = new L10N(ClassLiteral.getClass((String)"com/caucho/ejb/cfg/EjbEntityHomeView"));
    private boolean _hasFindByPrimaryKey;

    public EjbEntityHomeView(EjbBean bean, Class apiClass, String prefix) throws ConfigException {
        super(bean, apiClass, prefix);
    }

    protected boolean isCMP() {
        return ((EjbEntityBean)this.getBean()).isCMP();
    }

    protected void introspect() throws ConfigException {
        super.introspect();
        if (!this._hasFindByPrimaryKey) {
            throw new ConfigException(L.l("{0}: expected 'findByPrimaryKey'.  All entity homes must define findByPrimaryKey.", this.getApiClass().getName()));
        }
    }

    protected EjbMethod introspectEJBMethod(Method method) throws ConfigException {
        String methodName = method.getName();
        Class[] paramTypes = method.getParameterTypes();
        if (methodName.startsWith("ejbCreate")) {
            String apiMethodName = "c" + methodName.substring(4);
            Method apiMethod = EjbBean.getMethod(this.getApiClass(), apiMethodName, paramTypes);
            if (apiMethod == null) {
                log.config(this.errorMissingMethod(this.getApiClass(), apiMethodName, method).getMessage());
                return null;
            }
            String postMethodName = "ejbPost" + methodName.substring(3);
            Method postCreateMethod = EjbBean.getMethod(this.getImplClass(), postMethodName, method.getParameterTypes());
            return new EjbEntityCreateMethod(this, apiMethod, method, postCreateMethod);
        }
        if (methodName.startsWith("ejbFind")) {
            if (methodName.equals("ejbFindByPrimaryKey")) {
                this._hasFindByPrimaryKey = true;
                Class primKeyClass = ((EjbEntityBean)this.getBean()).getPrimKeyClass();
                if (paramTypes.length != 1 || !paramTypes[0].equals(primKeyClass)) {
                    throw this.error(L.l("{0}: '{1}' expected as only argument of {2}. ejbFindByPrimaryKey must take the primary key as its only argument.", method.getDeclaringClass().getName(), EjbEntityHomeView.getClassName(primKeyClass), methodName));
                }
            }
            String apiMethodName = "f" + methodName.substring(4);
            Method apiMethod = EjbBean.getMethod(this.getApiClass(), apiMethodName, paramTypes);
            if (apiMethod != null) {
                return new EjbEntityFindMethod(this, apiMethod, method);
            }
        } else if (methodName.startsWith("ejbHome")) {
            String apiMethodName = Character.toLowerCase(methodName.charAt(7)) + methodName.substring(8);
            Method apiMethod = EjbBean.getMethod(this.getApiClass(), apiMethodName, paramTypes);
            if (apiMethod == null) {
                log.config(this.errorMissingMethod(this.getApiClass(), apiMethodName, method).getMessage());
                return null;
            }
            this.validateImplMethod(method);
            return new EjbMethod(this, apiMethod, method);
        }
        return null;
    }

    protected EjbMethod introspectApiMethod(Method apiMethod) throws ConfigException {
        String methodName = apiMethod.getName();
        Class<?>[] paramTypes = apiMethod.getParameterTypes();
        if (methodName.equals("findByPrimaryKey")) {
            this._hasFindByPrimaryKey = true;
            Class primKeyClass = ((EjbEntityBean)this.getBean()).getPrimKeyClass();
            if (paramTypes.length != 1 || !paramTypes[0].equals(primKeyClass)) {
                throw this.error(L.l("{0}: `{1}' expected as only argument of {2}. findByPrimaryKey must take the primary key as its only argument.", apiMethod.getDeclaringClass().getName(), EjbEntityHomeView.getClassName(primKeyClass), methodName));
            }
            return new EjbEntityFindMethod(this, apiMethod);
        }
        if (methodName.startsWith("find")) {
            if (this.isCMP()) {
                EjbMethodPattern pattern = this.findMethodPattern(apiMethod, this.getPrefix());
                if (pattern == null) {
                    throw this.error(L.l("{0}: '{1}' expects an ejb-ql query.  All find methods need queries defined in the EJB deployment descriptor.", (Object)apiMethod.getDeclaringClass().getName(), EjbEntityHomeView.getFullMethodName(apiMethod)));
                }
                String query = pattern.getQuery();
                EjbAmberFindMethod findMethod = new EjbAmberFindMethod(this, apiMethod, query, pattern.getQueryLocation());
                findMethod.setQueryLoadsBean(pattern.getQueryLoadsBean());
                return findMethod;
            }
            String name = methodName;
            name = Character.toUpperCase(name.charAt(0)) + name.substring(1);
            throw this.errorMissingMethod(this.getImplClass(), "ejb" + name, apiMethod);
        }
        if (methodName.startsWith("create")) {
            String name = apiMethod.getName();
            name = Character.toUpperCase(name.charAt(0)) + name.substring(1);
            throw this.errorMissingMethod(this.getImplClass(), "ejb" + name, apiMethod);
        }
        if (methodName.startsWith("ejb")) {
            throw new ConfigException(L.l("{0}: '{1}' forbidden.  ejbXXX methods are reserved by the EJB specification.", (Object)apiMethod.getDeclaringClass().getName(), EjbEntityHomeView.getFullMethodName(apiMethod)));
        }
        if (methodName.startsWith("remove")) {
            throw new ConfigException(L.l("{0}: '{1}' forbidden.  removeXXX methods are reserved by the EJB specification.", (Object)apiMethod.getDeclaringClass().getName(), EjbEntityHomeView.getFullMethodName(apiMethod)));
        }
        String name = apiMethod.getName();
        name = Character.toUpperCase(name.charAt(0)) + name.substring(1);
        throw this.errorMissingMethod(this.getImplClass(), "ejbHome" + name, apiMethod);
    }
}

