/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.ejb.cfg;

import com.caucho.config.BuilderProgram;
import com.caucho.config.BuilderProgramContainer;
import com.caucho.config.ConfigException;
import com.caucho.config.LineConfigException;
import com.caucho.config.j2ee.InjectIntrospector;
import com.caucho.ejb.AbstractServer;
import com.caucho.ejb.EjbServerManager;
import com.caucho.ejb.cfg.EjbBean;
import com.caucho.ejb.cfg.EjbConfig;
import com.caucho.ejb.cfg.EjbHomeView;
import com.caucho.ejb.cfg.EjbSessionHomeView;
import com.caucho.ejb.cfg.EjbStatelessHomeView;
import com.caucho.ejb.gen.BeanAssembler;
import com.caucho.ejb.gen.SessionAssembler;
import com.caucho.ejb.gen.StatelessAssembler;
import com.caucho.ejb.session.SessionServer;
import com.caucho.ejb.session.StatelessServer;
import com.caucho.java.gen.JavaClassGenerator;
import com.caucho.util.L10N;
import com.rc.retroweaver.runtime.ClassLiteral;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Iterator;

public class EjbSessionBean
extends EjbBean {
    private static final L10N L = new L10N(ClassLiteral.getClass((String)"com/caucho/ejb/cfg/EjbSessionBean"));
    private boolean _isStateless;
    private boolean _isContainerTransaction;

    public EjbSessionBean(EjbConfig ejbConfig) {
        super(ejbConfig);
    }

    public String getEJBKind() {
        return "session";
    }

    public void setEJBClass(Class ejbClass) throws ConfigException {
        super.setEJBClass(ejbClass);
        if (Modifier.isAbstract(ejbClass.getModifiers())) {
            throw this.error(L.l("`{0}' must not be abstract.  Session bean implementations must be fully implemented.", ejbClass.getName()));
        }
        if (!ClassLiteral.getClass((String)"javax/ejb/SessionBean").isAssignableFrom(ejbClass) && !this.isAllowPOJO()) {
            throw this.error(L.l("`{0}' must implement SessionBean.  Session beans must implement javax.ejb.SessionBean.", ejbClass.getName()));
        }
    }

    public boolean isStateless() {
        return this._isStateless;
    }

    public void setSessionType(String type) throws ConfigException {
        if (type.equals("Stateful")) {
            this._isStateless = false;
        } else if (type.equals("Stateless")) {
            this._isStateless = true;
        } else {
            throw new ConfigException(L.l("`{0}' is an unknown session-type.  session-type must be `Stateless' or `Stateful'.", type));
        }
    }

    public boolean isContainerTransaction() {
        return this._isContainerTransaction;
    }

    public void setTransactionType(String type) throws ConfigException {
        if (type.equals("Container")) {
            this._isContainerTransaction = true;
        } else if (type.equals("Bean")) {
            this._isContainerTransaction = false;
        } else {
            throw new ConfigException(L.l("`{0}' is an unknown transaction-type.  transaction-type must be `Container' or `Bean'.", type));
        }
    }

    public void init() throws ConfigException {
        super.init();
        try {
            if (this.getRemoteHome() != null) {
                this.validateHome(this.getRemoteHome(), this.getRemote());
            }
            if (this.getLocalHome() != null) {
                this.validateHome(this.getLocalHome(), this.getLocal());
            }
            if (this.getRemote() != null) {
                this.validateRemote(this.getRemote());
            }
            if (this.getLocal() != null) {
                this.validateRemote(this.getLocal());
            }
            if (ClassLiteral.getClass((String)"javax/ejb/SessionSynchronization").isAssignableFrom(this.getEJBClass())) {
                if (this.isStateless()) {
                    throw this.error(L.l("'{0}' must not implement SessionSynchronization.  Stateless session beans must not implement SessionSynchronization.", this.getEJBClass().getName()));
                }
                if (!this._isContainerTransaction) {
                    throw this.error(L.l("'{0}' must not implement SessionSynchronization.  Session beans with Bean-managed transactions may not use SessionSynchronization.", this.getEJBClass().getName()));
                }
            }
        }
        catch (LineConfigException e) {
            throw e;
        }
        catch (ConfigException e) {
            throw new LineConfigException(this.getLocation() + e.getMessage(), e);
        }
    }

    protected BeanAssembler createAssembler(String fullClassName) {
        if (this.isStateless()) {
            return new StatelessAssembler(this, fullClassName);
        }
        return new SessionAssembler(this, fullClassName);
    }

    protected void addImports(BeanAssembler assembler) {
        super.addImports(assembler);
        if (this.isStateless()) {
            assembler.addImport("com.caucho.ejb.session.StatelessServer");
            assembler.addImport("com.caucho.ejb.session.AbstractStatelessContext");
            assembler.addImport("com.caucho.ejb.session.StatelessHome");
            assembler.addImport("com.caucho.ejb.session.StatelessObject");
        } else {
            assembler.addImport("com.caucho.ejb.session.SessionServer");
            assembler.addImport("com.caucho.ejb.session.AbstractSessionContext");
            assembler.addImport("com.caucho.ejb.session.SessionHome");
            assembler.addImport("com.caucho.ejb.session.SessionObject");
        }
    }

    protected EjbHomeView createHomeView(Class homeClass, String prefix) throws ConfigException {
        if (this.isStateless()) {
            return new EjbStatelessHomeView(this, homeClass, prefix);
        }
        return new EjbSessionHomeView(this, homeClass, prefix);
    }

    public AbstractServer deployServer(EjbServerManager ejbManager, JavaClassGenerator javaGen) throws ClassNotFoundException, ConfigException {
        AbstractServer server = this.isStateless() ? new StatelessServer(ejbManager) : new SessionServer(ejbManager);
        server.setEJBName(this.getEJBName());
        server.setRemoteHomeClass(this.getRemoteHome());
        server.setRemoteObjectClass(this.getRemote());
        Class contextImplClass = javaGen.loadClass(this.getSkeletonName());
        server.setContextImplClass(contextImplClass);
        Class beanClass = javaGen.loadClass(this.getEJBClass().getName());
        ArrayList<BuilderProgram> initList = InjectIntrospector.introspect(beanClass);
        BuilderProgramContainer initContainer = this.getInitProgram();
        if (initList.size() > 0) {
            if (initContainer == null) {
                initContainer = new BuilderProgramContainer();
            }
            Iterator<BuilderProgram> i$ = initList.iterator();
            while (i$.hasNext()) {
                BuilderProgram init = i$.next();
                initContainer.addProgram(init);
            }
        }
        server.setInitProgram(initContainer);
        return server;
    }

    private void validateMethods() throws ConfigException {
    }

    private void validateHome(Class homeClass, Class objectClass) throws ConfigException {
        Class beanClass = this.getEJBClass();
        String beanName = beanClass.getName();
        if (homeClass == null) {
            return;
        }
        String homeName = homeClass.getName();
        String objectName = objectClass.getName();
        boolean hasFindByPrimaryKey = false;
        if (!Modifier.isPublic(homeClass.getModifiers())) {
            throw this.error(L.l("`{0}' must be public", homeName));
        }
        if (Modifier.isFinal(beanClass.getModifiers())) {
            throw this.error(L.l("`{0}' must not be final", beanName));
        }
        if (Modifier.isAbstract(beanClass.getModifiers())) {
            throw this.error(L.l("`{0}' must not be abstract", beanName));
        }
        if (!Modifier.isInterface(homeClass.getModifiers())) {
            throw this.error(L.l("`{0}' must be an interface", homeName));
        }
        boolean hasCreate = false;
        Method[] methods = EjbSessionBean.getMethods(homeClass);
        for (int i = 0; i < methods.length; ++i) {
            Method method = methods[i];
            String name = method.getName();
            Class[] param = method.getParameterTypes();
            Class<?> retType = method.getReturnType();
            if (method.getDeclaringClass().isAssignableFrom(ClassLiteral.getClass((String)"javax/ejb/EJBHome")) || method.getDeclaringClass().isAssignableFrom(ClassLiteral.getClass((String)"javax/ejb/EJBLocalHome"))) continue;
            if (ClassLiteral.getClass((String)"javax/ejb/EJBHome").isAssignableFrom(homeClass)) {
                this.validateException(method, ClassLiteral.getClass((String)"java/rmi/RemoteException"));
            }
            if (name.startsWith("create")) {
                hasCreate = true;
                if (this.isStateless() && (!name.equals("create") || method.getParameterTypes().length != 0)) {
                    throw this.error(L.l("{0}: `{1}' forbidden in stateless session home.  The create() method for a stateless session bean must have zero arguments.", (Object)EjbSessionBean.getFullMethodName(method), homeName));
                }
                if (!this.isAllowPOJO()) {
                    this.validateExceptions(method, new Class[]{ClassLiteral.getClass((String)"javax/ejb/CreateException")});
                }
                if (!retType.equals(objectClass)) {
                    throw this.error(L.l("{0}: `{1}' must return {2}.  Create methods must return the local or remote interface.", homeName, EjbSessionBean.getFullMethodName(method), objectClass.getName()));
                }
                String createName = "ejbC" + name.substring(1);
                Method implMethod = this.validateNonFinalMethod(createName, param, method, homeClass, this.isAllowPOJO());
                if (implMethod == null) continue;
                if (!implMethod.getReturnType().equals(Void.TYPE)) {
                    throw this.error(L.l("`{0}' must return {1} in {2}", EjbSessionBean.getFullMethodName(createName, param), "void", beanName));
                }
                this.validateExceptions(method, implMethod.getExceptionTypes());
                continue;
            }
            if (!name.startsWith("ejb") && !name.startsWith("remove")) continue;
            throw this.error(L.l("`{0}' forbidden in {1}", (Object)EjbSessionBean.getFullMethodName(method), homeClass.getName()));
        }
        if (!hasCreate) {
            throw this.error(L.l("`{0}' needs at least one create method.  Session beans need a create method.", homeClass.getName()));
        }
    }
}

