/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.ejb.cfg;

import com.caucho.config.ConfigException;
import com.caucho.ejb.cfg.EjbBean;
import com.caucho.ejb.cfg.EjbMethod;
import com.caucho.ejb.cfg.EjbMethodPattern;
import com.caucho.ejb.gen.BeanAssembler;
import com.caucho.ejb.gen.ViewClass;
import com.caucho.java.gen.CallChain;
import com.caucho.log.Log;
import com.caucho.util.L10N;
import com.rc.retroweaver.runtime.ClassLiteral;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.logging.Logger;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EjbView {
    private static final Logger log = Log.open(ClassLiteral.getClass((String)"com/caucho/ejb/cfg/EjbView"));
    private static final L10N L = new L10N(ClassLiteral.getClass((String)"com/caucho/ejb/cfg/EjbView"));
    private EjbBean _bean;
    private Class _apiClass;
    private String _prefix;
    private HashMap<String, EjbMethod> _methodMap = new HashMap();

    public EjbView(EjbBean bean, Class apiClass, String prefix) throws ConfigException {
        this._bean = bean;
        this._apiClass = apiClass;
        this._prefix = prefix;
    }

    protected EjbBean getBean() {
        return this._bean;
    }

    protected Class getApiClass() {
        return this._apiClass;
    }

    protected Class getImplClass() {
        return this._bean.getEJBClass();
    }

    protected String getPrefix() {
        return this._prefix;
    }

    protected boolean isLocal() {
        return "Local".equals(this._prefix);
    }

    public ArrayList<EjbMethod> getMethods() {
        ArrayList<EjbMethod> methods = new ArrayList<EjbMethod>();
        methods.addAll(this._methodMap.values());
        return methods;
    }

    protected void introspect() throws ConfigException {
        Method[] implMethods = EjbBean.getMethods(this.getImplClass());
        for (int i = 0; i < implMethods.length; ++i) {
            Method method = implMethods[i];
            EjbMethod ejbMethod = null;
            String name = method.getName();
            if (!(name.equals("equals") && method.getParameterTypes().length == 1 && method.getParameterTypes()[0].equals(ClassLiteral.getClass((String)"java/lang/Object")) || name.equals("hashCode") && method.getParameterTypes().length == 0)) {
                ejbMethod = name.startsWith("ejb") ? this.introspectEJBMethod(method) : this.introspectBusinessMethod(method);
            }
            if (ejbMethod == null) continue;
            this._methodMap.put(EjbView.getFullMethodName(ejbMethod.getApiMethod()), ejbMethod);
        }
        Method[] apiMethods = EjbBean.getMethods(this._apiClass);
        for (int i = 0; i < apiMethods.length; ++i) {
            EjbMethod ejbMethod;
            Method method = apiMethods[i];
            if (method.getDeclaringClass().getName().startsWith("javax.ejb") || method.getName().equals("equals") && method.getParameterTypes().length == 1 && method.getParameterTypes()[0].equals(ClassLiteral.getClass((String)"java/lang/Object")) || method.getName().equals("hashCode") && method.getParameterTypes().length == 0 || (ejbMethod = this._methodMap.get(EjbView.getFullMethodName(method))) != null || (ejbMethod = this.introspectApiMethod(method)) == null) continue;
            this._methodMap.put(EjbView.getFullMethodName(ejbMethod.getApiMethod()), ejbMethod);
            this.validateApiMethod(ejbMethod.getApiMethod());
        }
    }

    protected EjbMethod introspectEJBMethod(Method method) throws ConfigException {
        return null;
    }

    protected EjbMethod introspectBusinessMethod(Method implMethod) throws ConfigException {
        Method apiMethod = EjbBean.getMethod(this._apiClass, implMethod.getName(), implMethod.getParameterTypes());
        if (apiMethod == null) {
            return null;
        }
        return this.createBusinessMethod(apiMethod, implMethod);
    }

    protected EjbMethod createBusinessMethod(Method apiMethod, Method implMethod) throws ConfigException {
        this.validateImplMethod(implMethod);
        return new EjbMethod(this, apiMethod, implMethod);
    }

    protected void validateImplMethod(Method implMethod) throws ConfigException {
        if (!Modifier.isPublic(implMethod.getModifiers())) {
            throw this.error(L.l("{0}: `{1}' must be public.  Business method implementations must be public.", (Object)implMethod.getDeclaringClass().getName(), EjbView.getFullMethodName(implMethod)));
        }
        if (Modifier.isStatic(implMethod.getModifiers())) {
            throw this.error(L.l("{0}: `{1}' must not be static.  Business method implementations must not be static.", (Object)implMethod.getDeclaringClass().getName(), EjbView.getFullMethodName(implMethod)));
        }
        if (Modifier.isAbstract(implMethod.getModifiers())) {
            throw this.error(L.l("{0}: `{1}' must not be abstract.  Business methods must be implemented.", (Object)implMethod.getDeclaringClass().getName(), EjbView.getFullMethodName(implMethod)));
        }
    }

    protected EjbMethod introspectApiMethod(Method apiMethod) throws ConfigException {
        if (apiMethod.getName().startsWith("ejb")) {
            throw this.error(L.l("{0}: '{1}' must not start with 'ejb'. The EJB spec reserves all methods starting with ejb.", (Object)apiMethod.getDeclaringClass().getName(), EjbView.getFullMethodName(apiMethod)));
        }
        throw this.errorMissingMethod(this.getImplClass(), apiMethod.getName(), apiMethod);
    }

    protected void validateApiMethod(Method apiMethod) throws ConfigException {
        if ("Remote".equals(this._prefix)) {
            this.validateException(apiMethod, ClassLiteral.getClass((String)"java/rmi/RemoteException"));
        }
    }

    protected ConfigException errorMissingMethod(Class expectedClass, String expectedName, Method matchMethod) {
        return this.error(L.l("{0}: missing `{1}' method needed to match {2}.{3}", expectedClass.getName(), EjbView.getFullMethodName(expectedName, matchMethod.getParameterTypes()), EjbView.getShortClassName(matchMethod.getDeclaringClass()), EjbView.getFullMethodName(matchMethod)));
    }

    protected void assembleView(BeanAssembler assembler, String fullClassName) throws ConfigException {
    }

    protected void assembleMethods(BeanAssembler assembler, ViewClass viewClass, String fullClassName) throws ConfigException {
        ArrayList<EjbMethod> methods = this.getMethods();
        for (int i = 0; i < methods.size(); ++i) {
            EjbMethod method = methods.get(i);
            method.assembleBean(assembler, fullClassName);
            viewClass.addMethod(method.assemble(viewClass, fullClassName));
        }
    }

    protected EjbMethodPattern findMethodPattern(Method apiMethod, String prefix) {
        return this._bean.getMethodPattern(apiMethod, prefix);
    }

    protected CallChain getTransactionChain(CallChain callChain, Method apiMethod, String prefix) {
        return this._bean.getTransactionChain(callChain, apiMethod, prefix);
    }

    protected CallChain getSecurityChain(CallChain callChain, Method apiMethod, String prefix) {
        return this._bean.getSecurityChain(callChain, apiMethod, prefix);
    }

    protected void validateException(Method method, Class exn) throws ConfigException {
        this.validateExceptions(method, new Class[]{exn});
    }

    protected void validateExceptions(Method method, Class[] exn) throws ConfigException {
        this._bean.validateExceptions(method, exn);
    }

    static String getClassName(Class cl) {
        if (cl != null) {
            return cl.getName();
        }
        return null;
    }

    static String getFullMethodName(Method method) {
        return EjbBean.getFullMethodName(method);
    }

    static String getFullMethodName(String methodName, Class[] paramTypes) {
        return EjbBean.getFullMethodName(methodName, paramTypes);
    }

    static String getShortClassName(Class cl) {
        return EjbBean.getShortClassName(cl);
    }

    public ConfigException error(String msg) {
        return new ConfigException(msg);
    }
}

