/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.ejb.entity2;

import com.caucho.amber.AmberManager;
import com.caucho.amber.field.AmberField;
import com.caucho.amber.field.CompositeId;
import com.caucho.amber.field.DependentEntityOneToOneField;
import com.caucho.amber.field.EntityManyToManyField;
import com.caucho.amber.field.EntityManyToOneField;
import com.caucho.amber.field.EntityOneToManyField;
import com.caucho.amber.field.Id;
import com.caucho.amber.field.IdField;
import com.caucho.amber.field.KeyPropertyField;
import com.caucho.amber.field.PropertyField;
import com.caucho.amber.field.SubId;
import com.caucho.amber.idgen.IdGenerator;
import com.caucho.amber.idgen.SequenceIdGenerator;
import com.caucho.amber.table.ForeignColumn;
import com.caucho.amber.table.LinkColumns;
import com.caucho.amber.table.Table;
import com.caucho.amber.type.EntityType;
import com.caucho.amber.type.GeneratorTableType;
import com.caucho.amber.type.PrimitiveCharType;
import com.caucho.amber.type.PrimitiveIntType;
import com.caucho.amber.type.StringType;
import com.caucho.amber.type.SubEntityType;
import com.caucho.amber.type.Type;
import com.caucho.config.ConfigException;
import com.caucho.ejb.EjbServerManager;
import com.caucho.jdbc.JdbcMetaData;
import com.caucho.util.CharBuffer;
import com.caucho.util.L10N;
import com.rc.retroweaver.runtime.ClassLiteral;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import javax.ejb.AccessType;
import javax.ejb.AssociationTable;
import javax.ejb.Basic;
import javax.ejb.Column;
import javax.ejb.DiscriminatorColumn;
import javax.ejb.DiscriminatorType;
import javax.ejb.Entity;
import javax.ejb.FetchType;
import javax.ejb.GeneratorType;
import javax.ejb.Inheritance;
import javax.ejb.InheritanceJoinColumn;
import javax.ejb.InheritanceType;
import javax.ejb.JoinColumn;
import javax.ejb.JoinColumns;
import javax.ejb.ManyToMany;
import javax.ejb.ManyToOne;
import javax.ejb.OneToMany;
import javax.ejb.OneToOne;
import javax.ejb.SecondaryTable;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EntityIntrospector {
    private static final L10N L = new L10N(ClassLiteral.getClass((String)"com/caucho/ejb/entity2/EntityIntrospector"));
    private EjbServerManager _ejbManager;
    private HashMap<String, EntityType> _entityMap = new HashMap();
    private ArrayList<Completion> _linkCompletions = new ArrayList();
    private ArrayList<Completion> _depCompletions = new ArrayList();

    public EntityIntrospector(EjbServerManager manager) {
        this._ejbManager = manager;
    }

    public EntityType introspect(Class type) throws ConfigException, SQLException {
        EntityType entityType;
        String entityName;
        int p;
        Entity entity = (Entity)type.getAnnotation(ClassLiteral.getClass((String)"javax/ejb/Entity"));
        if (entity == null) {
            throw new ConfigException(L.l("'{0}' is not an @Entity class.", type));
        }
        boolean isField = entity.access() == AccessType.FIELD;
        EjbServerManager serverManager = this._ejbManager;
        AmberManager amberManager = serverManager.getAmberManager();
        Inheritance inheritanceAnn = (Inheritance)type.getAnnotation(ClassLiteral.getClass((String)"javax/ejb/Inheritance"));
        EntityType parentType = null;
        if (inheritanceAnn != null) {
            for (Class parentClass = type.getSuperclass(); parentClass != null; parentClass = parentClass.getSuperclass()) {
                Entity parentEntity = (Entity)parentClass.getAnnotation(ClassLiteral.getClass((String)"javax/ejb/Entity"));
                if (parentEntity == null) continue;
                parentType = this.introspect(parentClass);
                break;
            }
        }
        if ((p = (entityName = type.getName()).lastIndexOf(46)) > 0) {
            entityName = entityName.substring(p + 1);
        }
        if ((entityType = this._entityMap.get(entityName)) != null) {
            return entityType;
        }
        entityType = amberManager.createEntity(entityName, type);
        this._entityMap.put(entityName, entityType);
        if (isField) {
            entityType.setFieldAccess(true);
        }
        entityType.setInstanceClassName(new StringBuffer().append(type.getName()).append("__ResinExt").toString());
        entityType.setEnhanced(true);
        Object table = null;
        javax.ejb.Table tableAnn = (javax.ejb.Table)type.getAnnotation(ClassLiteral.getClass((String)"javax/ejb/Table"));
        String tableName = null;
        if (tableAnn != null) {
            tableName = tableAnn.name();
        }
        if (tableName == null || tableName.equals("")) {
            tableName = entityName;
        }
        if (parentType == null) {
            entityType.setTable(amberManager.createTable(tableName));
        } else if (parentType.isJoinedSubClass()) {
            entityType.setTable(amberManager.createTable(tableName));
        } else {
            entityType.setTable(parentType.getTable());
        }
        SecondaryTable secondaryTableAnn = (SecondaryTable)type.getAnnotation(ClassLiteral.getClass((String)"javax/ejb/SecondaryTable"));
        Table secondaryTable = null;
        if (inheritanceAnn != null) {
            this.introspectInheritance(amberManager, entityType, type);
        }
        if (secondaryTableAnn != null) {
            String secondaryName = secondaryTableAnn.name();
            secondaryTable = amberManager.createTable(secondaryName);
            entityType.addSecondaryTable(secondaryTable);
        }
        if (entityType.getId() == null) {
            if (isField) {
                this.introspectIdField(amberManager, entityType, parentType, type);
            } else {
                this.introspectIdMethod(amberManager, entityType, parentType, type);
            }
        }
        if (isField) {
            this.introspectFields(amberManager, entityType, parentType, type);
        } else {
            this.introspectMethods(amberManager, entityType, parentType, type);
        }
        if (secondaryTableAnn != null) {
            this.linkSecondaryTable(entityType.getTable(), secondaryTable, secondaryTableAnn.join());
        }
        return entityType;
    }

    public void init() throws ConfigException {
        while (this._depCompletions.size() > 0 || this._linkCompletions.size() > 0) {
            Completion completion;
            while (this._linkCompletions.size() > 0) {
                completion = this._linkCompletions.remove(0);
                completion.complete();
            }
            if (this._depCompletions.size() <= 0) continue;
            completion = this._depCompletions.remove(0);
            completion.complete();
        }
    }

    private void introspectInheritance(AmberManager manager, EntityType entityType, Class type) throws ConfigException, SQLException {
        Type columnType;
        String columnName;
        DiscriminatorColumn discriminatorAnn;
        block14: {
            block13: {
                block12: {
                    block11: {
                        block10: {
                            Inheritance inheritanceAnn = (Inheritance)type.getAnnotation(ClassLiteral.getClass((String)"javax/ejb/Inheritance"));
                            String discriminatorValue = inheritanceAnn.discriminatorValue();
                            if (discriminatorValue == null || discriminatorValue.equals("")) {
                                String name = entityType.getBeanClass().getName();
                                int p = name.lastIndexOf(46);
                                if (p > 0) {
                                    name = name.substring(p + 1);
                                }
                                discriminatorValue = name;
                            }
                            entityType.setDiscriminatorValue(discriminatorValue);
                            if (entityType instanceof SubEntityType) {
                                SubEntityType subType = (SubEntityType)entityType;
                                subType.getParentType().addSubClass(subType);
                                InheritanceJoinColumn join = (InheritanceJoinColumn)type.getAnnotation(ClassLiteral.getClass((String)"javax/ejb/InheritanceJoinColumn"));
                                if (subType.isJoinedSubClass()) {
                                    this.linkInheritanceTable(subType.getRootType().getTable(), subType.getTable(), join);
                                    subType.setId(new SubId((EntityType)subType, subType.getRootType()));
                                }
                                return;
                            }
                            InheritanceType inheritanceType = inheritanceAnn.strategy();
                            inheritanceType.getClass();
                            InheritanceType inheritanceType2 = inheritanceType;
                            if (inheritanceType2 == InheritanceType.JOINED) {
                                entityType.setJoinedSubClass(true);
                            }
                            discriminatorAnn = (DiscriminatorColumn)type.getAnnotation(ClassLiteral.getClass((String)"javax/ejb/DiscriminatorColumn"));
                            columnName = null;
                            if (discriminatorAnn != null) {
                                columnName = discriminatorAnn.name();
                            }
                            if (columnName == null || columnName.equals("")) {
                                columnName = "TYPE";
                            }
                            columnType = null;
                            DiscriminatorType discriminatorType = inheritanceAnn.discriminatorType();
                            discriminatorType.getClass();
                            DiscriminatorType discriminatorType2 = discriminatorType;
                            if (discriminatorType2 == DiscriminatorType.STRING) break block10;
                            if (discriminatorType2 == DiscriminatorType.CHAR) break block11;
                            if (discriminatorType2 == DiscriminatorType.INTEGER) break block12;
                            break block13;
                        }
                        columnType = StringType.create();
                        break block14;
                    }
                    columnType = PrimitiveCharType.create();
                    break block14;
                }
                columnType = PrimitiveIntType.create();
                break block14;
            }
            throw new IllegalStateException();
        }
        com.caucho.amber.table.Column column = entityType.getTable().createColumn(columnName, columnType);
        if (discriminatorAnn != null) {
            column.setNotNull(!discriminatorAnn.nullable());
            column.setLength(discriminatorAnn.length());
            if (!"".equals(discriminatorAnn.columnDefinition())) {
                column.setSQLType(discriminatorAnn.columnDefinition());
            }
        } else {
            column.setNotNull(true);
            column.setLength(10);
        }
        entityType.setDiscriminator(column);
    }

    private void introspectIdMethod(AmberManager manager, EntityType entityType, EntityType parentType, Class type) throws ConfigException, SQLException {
        ArrayList<IdField> keys = new ArrayList<IdField>();
        for (Method method : type.getMethods()) {
            IdField idField;
            javax.ejb.Id id;
            String methodName = method.getName();
            Class<?>[] paramTypes = method.getParameterTypes();
            if (!methodName.startsWith("get") || paramTypes.length != 0) continue;
            String fieldName = EntityIntrospector.toFieldName(methodName.substring(3));
            if (parentType != null && parentType.getField(fieldName) != null || (id = (javax.ejb.Id)method.getAnnotation(ClassLiteral.getClass((String)"javax/ejb/Id"))) == null || (idField = this.introspectId(manager, entityType, method, fieldName, method.getReturnType())) == null) continue;
            keys.add(idField);
        }
        if (keys.size() == 1) {
            entityType.setId(new Id(entityType, keys));
        } else {
            entityType.setId(new CompositeId(entityType, keys));
        }
    }

    private void introspectIdField(AmberManager manager, EntityType entityType, EntityType parentType, Class type) throws ConfigException, SQLException {
        ArrayList<IdField> keys = new ArrayList<IdField>();
        for (Field field : type.getDeclaredFields()) {
            IdField idField;
            javax.ejb.Id id;
            String fieldName = field.getName();
            if (parentType != null && parentType.getField(fieldName) != null || (id = (javax.ejb.Id)field.getAnnotation(ClassLiteral.getClass((String)"javax/ejb/Id"))) == null || (idField = this.introspectId(manager, entityType, field, fieldName, field.getType())) == null) continue;
            keys.add(idField);
        }
        if (keys.size() == 1) {
            entityType.setId(new Id(entityType, keys));
        } else {
            entityType.setId(new CompositeId(entityType, keys));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IdField introspectId(AmberManager manager, EntityType entityType, AccessibleObject field, String fieldName, Class fieldType) throws ConfigException, SQLException {
        javax.ejb.Id id = (javax.ejb.Id)field.getAnnotation(ClassLiteral.getClass((String)"javax/ejb/Id"));
        Column column = (Column)field.getAnnotation(ClassLiteral.getClass((String)"javax/ejb/Column"));
        Type amberType = manager.createType(fieldType);
        com.caucho.amber.table.Column keyColumn = this.createColumn(entityType, "ID", column, amberType);
        KeyPropertyField idField = new KeyPropertyField(entityType, fieldName, keyColumn);
        JdbcMetaData metaData = manager.getMetaData();
        Connection conn = manager.getDataSource().getConnection();
        try {
            if (GeneratorType.IDENTITY.equals((Object)id.generate())) {
                if (!metaData.supportsIdentity()) {
                    throw new ConfigException(L.l("'{0}' does not support identity.", metaData.getDatabaseName(conn)));
                }
                keyColumn.setGeneratorType("identity");
                idField.setGenerator("identity");
            } else if (GeneratorType.SEQUENCE.equals((Object)id.generate())) {
                if (!metaData.supportsSequences()) {
                    throw new ConfigException(L.l("'{0}' does not support sequence.", metaData.getDatabaseName(conn)));
                }
                this.addSequenceIdGenerator(manager, idField, id);
            } else if (GeneratorType.TABLE.equals((Object)id.generate())) {
                this.addTableIdGenerator(manager, idField, id);
            } else if (GeneratorType.AUTO.equals((Object)id.generate())) {
                if (metaData.supportsIdentity()) {
                    keyColumn.setGeneratorType("identity");
                    idField.setGenerator("identity");
                } else if (metaData.supportsSequences()) {
                    this.addSequenceIdGenerator(manager, idField, id);
                } else {
                    this.addTableIdGenerator(manager, idField, id);
                }
            }
        }
        finally {
            conn.close();
        }
        return idField;
    }

    private void addSequenceIdGenerator(AmberManager manager, KeyPropertyField idField, javax.ejb.Id id) throws ConfigException {
        idField.setGenerator("sequence");
        idField.getColumn().setGeneratorType("sequence");
        String name = id.generator();
        if (name == null || "".equals(name)) {
            name = new StringBuffer().append(idField.getSourceType().getTable().getName()).append("_cseq").toString();
        }
        SequenceIdGenerator gen = manager.createSequenceGenerator(name, 1);
        idField.getSourceType().setGenerator(idField.getName(), gen);
    }

    private void addTableIdGenerator(AmberManager manager, KeyPropertyField idField, javax.ejb.Id id) throws ConfigException {
        IdGenerator gen;
        idField.setGenerator("table");
        idField.getColumn().setGeneratorType("table");
        String name = id.generator();
        if (name == null || "".equals(name)) {
            name = "caucho";
        }
        if ((gen = manager.getTableGenerator(name)) == null) {
            String genName = "GEN_TABLE";
            GeneratorTableType genTable = manager.createGeneratorTable(genName);
            gen = genTable.createGenerator(name);
            manager.putTableGenerator(name, gen);
        }
        idField.getSourceType().setGenerator(idField.getName(), gen);
    }

    private void linkSecondaryTable(Table primaryTable, Table secondaryTable, JoinColumn[] joinColumns) throws ConfigException {
        ArrayList<ForeignColumn> linkColumns = new ArrayList<ForeignColumn>();
        for (com.caucho.amber.table.Column column : primaryTable.getIdColumns()) {
            JoinColumn join = this.getJoinColumn(joinColumns, column.getName());
            String name = join == null ? column.getName() : join.name();
            ForeignColumn linkColumn = secondaryTable.createForeignColumn(name, column);
            linkColumn.setPrimaryKey(true);
            secondaryTable.addIdColumn(linkColumn);
            linkColumns.add(linkColumn);
        }
        LinkColumns link = new LinkColumns(secondaryTable, primaryTable, linkColumns);
        link.setSourceCascadeDelete(true);
        secondaryTable.setDependentIdLink(link);
    }

    private void linkInheritanceTable(Table primaryTable, Table secondaryTable, InheritanceJoinColumn join) throws ConfigException {
        if (join != null) {
            this.linkInheritanceTable(primaryTable, secondaryTable, new InheritanceJoinColumn[]{join});
        } else {
            this.linkInheritanceTable(primaryTable, secondaryTable, (InheritanceJoinColumn[])null);
        }
    }

    private void linkInheritanceTable(Table primaryTable, Table secondaryTable, InheritanceJoinColumn[] joinColumns) throws ConfigException {
        ArrayList<ForeignColumn> linkColumns = new ArrayList<ForeignColumn>();
        for (com.caucho.amber.table.Column column : primaryTable.getIdColumns()) {
            InheritanceJoinColumn join = this.getJoinColumn(joinColumns, column.getName());
            String name = join == null ? column.getName() : join.name();
            ForeignColumn linkColumn = secondaryTable.createForeignColumn(name, column);
            linkColumn.setPrimaryKey(true);
            secondaryTable.addIdColumn(linkColumn);
            linkColumns.add(linkColumn);
        }
        LinkColumns link = new LinkColumns(secondaryTable, primaryTable, linkColumns);
        link.setSourceCascadeDelete(true);
        secondaryTable.setDependentIdLink(link);
    }

    private void introspectMethods(AmberManager manager, EntityType entityType, EntityType parentType, Class type) throws ConfigException {
        if (entityType.getId() == null) {
            throw new IllegalStateException(L.l("{0} has no key", entityType));
        }
        for (Method method : type.getMethods()) {
            String methodName = method.getName();
            Class<?>[] paramTypes = method.getParameterTypes();
            if (!methodName.startsWith("get") || paramTypes.length != 0) continue;
            String fieldName = EntityIntrospector.toFieldName(methodName.substring(3));
            if (parentType != null && parentType.getField(fieldName) != null) continue;
            Class<?> fieldType = method.getReturnType();
            this.introspectField(manager, entityType, method, fieldName, fieldType);
        }
    }

    private void introspectFields(AmberManager manager, EntityType entityType, EntityType parentType, Class type) throws ConfigException {
        if (entityType.getId() == null) {
            throw new IllegalStateException(L.l("{0} has no key", entityType));
        }
        for (Field field : type.getDeclaredFields()) {
            String fieldName = field.getName();
            if (parentType != null && parentType.getField(fieldName) != null) continue;
            Class<?> fieldType = field.getType();
            this.introspectField(manager, entityType, field, fieldName, fieldType);
        }
    }

    private void introspectField(AmberManager manager, EntityType sourceType, AccessibleObject field, String fieldName, Class fieldType) throws ConfigException {
        if (field.isAnnotationPresent(ClassLiteral.getClass((String)"javax/ejb/Basic"))) {
            this.addBasic(sourceType, field, fieldName, fieldType);
        } else if (field.isAnnotationPresent(ClassLiteral.getClass((String)"javax/ejb/ManyToOne"))) {
            this._linkCompletions.add(new ManyToOneCompletion(sourceType, field, fieldName, fieldType));
        } else if (field.isAnnotationPresent(ClassLiteral.getClass((String)"javax/ejb/OneToMany"))) {
            this._depCompletions.add(new OneToManyCompletion(sourceType, field, fieldName, fieldType));
        } else if (field.isAnnotationPresent(ClassLiteral.getClass((String)"javax/ejb/OneToOne"))) {
            this._depCompletions.add(new OneToOneCompletion(sourceType, field, fieldName, fieldType));
        } else if (field.isAnnotationPresent(ClassLiteral.getClass((String)"javax/ejb/ManyToMany"))) {
            this._depCompletions.add(new ManyToManyCompletion(sourceType, field, fieldName, fieldType));
        }
    }

    private void addBasic(EntityType sourceType, AccessibleObject field, String fieldName, Class fieldType) throws ConfigException {
        AmberManager manager = sourceType.getAmberManager();
        Basic basic = (Basic)field.getAnnotation(ClassLiteral.getClass((String)"javax/ejb/Basic"));
        Column ejbColumn = (Column)field.getAnnotation(ClassLiteral.getClass((String)"javax/ejb/Column"));
        Type amberType = manager.createType(fieldType);
        com.caucho.amber.table.Column fieldColumn = this.createColumn(sourceType, fieldName, ejbColumn, amberType);
        PropertyField property = new PropertyField(sourceType, fieldName);
        property.setColumn(fieldColumn);
        property.setLazy(basic.fetch() == FetchType.LAZY);
        sourceType.addField(property);
    }

    private com.caucho.amber.table.Column createColumn(EntityType entityType, String name, Column ejbColumn, Type amberType) throws ConfigException {
        com.caucho.amber.table.Column column;
        if (ejbColumn != null && !ejbColumn.name().equals("")) {
            name = ejbColumn.name();
        }
        if (ejbColumn != null && !ejbColumn.secondaryTable().equals("")) {
            String tableName = ejbColumn.secondaryTable();
            Table table = entityType.getSecondaryTable(tableName);
            if (table == null) {
                throw new ConfigException(L.l("'{0}' is an unknown secondary table.", tableName));
            }
            column = table.createColumn(name, amberType);
        } else {
            column = entityType.getTable().createColumn(name, amberType);
        }
        if (ejbColumn != null) {
            column.setUnique(ejbColumn.unique());
            column.setNotNull(!ejbColumn.nullable());
            if (!"".equals(ejbColumn.columnDefinition())) {
                column.setSQLType(ejbColumn.columnDefinition());
            }
            column.setLength(ejbColumn.length());
        }
        return column;
    }

    private void addManyToOne(EntityType sourceType, AccessibleObject field, String fieldName, Class fieldType) throws ConfigException {
        AmberManager manager = sourceType.getAmberManager();
        ManyToOne manyToOne = (ManyToOne)field.getAnnotation(ClassLiteral.getClass((String)"javax/ejb/ManyToOne"));
        JoinColumns joinColumns = (JoinColumns)field.getAnnotation(ClassLiteral.getClass((String)"javax/ejb/JoinColumns"));
        JoinColumn joinColumn = (JoinColumn)field.getAnnotation(ClassLiteral.getClass((String)"javax/ejb/JoinColumn"));
        String targetName = manyToOne.targetEntity();
        if (targetName == null || targetName.equals("")) {
            targetName = fieldType.getName();
        }
        EntityManyToOneField manyToOneField = new EntityManyToOneField(sourceType, fieldName);
        EntityType targetType = manager.createEntity(targetName, fieldType);
        manyToOneField.setType(targetType);
        manyToOneField.setLazy(manyToOne.fetch() == FetchType.LAZY);
        sourceType.addField(manyToOneField);
        Table sourceTable = sourceType.getTable();
        ArrayList<ForeignColumn> foreignColumns = new ArrayList<ForeignColumn>();
        for (com.caucho.amber.table.Column keyColumn : targetType.getId().getColumns()) {
            JoinColumn join = this.getJoinColumn(joinColumns, keyColumn.getName());
            if (join == null) {
                join = joinColumn;
            }
            String columnName = keyColumn.getName();
            if (join != null) {
                columnName = join.name();
            }
            ForeignColumn foreignColumn = sourceTable.createForeignColumn(columnName, keyColumn);
            foreignColumns.add(foreignColumn);
        }
        LinkColumns linkColumns = new LinkColumns(sourceType.getTable(), targetType.getTable(), foreignColumns);
        manyToOneField.setLinkColumns(linkColumns);
        manyToOneField.init();
    }

    private JoinColumn getJoinColumn(JoinColumns joinColumns, String keyName) {
        if (joinColumns == null) {
            return null;
        }
        return this.getJoinColumn(joinColumns.value(), keyName);
    }

    private JoinColumn getJoinColumn(JoinColumn[] columns, String keyName) {
        if (columns == null || columns.length == 0) {
            return null;
        }
        for (int i = 0; i < columns.length; ++i) {
            String ref = columns[i].referencedColumnName();
            if (!ref.equals("") && !ref.equals(keyName)) continue;
            return columns[i];
        }
        return null;
    }

    private InheritanceJoinColumn getJoinColumn(InheritanceJoinColumn[] columns, String keyName) {
        if (columns == null || columns.length == 0) {
            return null;
        }
        for (int i = 0; i < columns.length; ++i) {
            String ref = columns[i].referencedColumnName();
            if (!ref.equals("") && !ref.equals(keyName)) continue;
            return columns[i];
        }
        return null;
    }

    private void addManyToMany(EntityType sourceType, AccessibleObject field, String fieldName, Class fieldType) throws ConfigException {
        ManyToMany manyToMany = (ManyToMany)field.getAnnotation(ClassLiteral.getClass((String)"javax/ejb/ManyToMany"));
        AmberManager manager = sourceType.getAmberManager();
        String targetName = manyToMany.targetEntity();
        if (targetName == null || targetName.equals("")) {
            throw new UnsupportedOperationException();
        }
        EntityType targetType = manager.getEntity(targetName);
        EntityManyToManyField manyToManyField = new EntityManyToManyField(sourceType, fieldName);
        manyToManyField.setType(targetType);
        AssociationTable associationTable = (AssociationTable)field.getAnnotation(ClassLiteral.getClass((String)"javax/ejb/AssociationTable"));
        String sqlTable = new StringBuffer().append(sourceType.getTable().getName()).append("_").append(targetType.getTable().getName()).toString();
        Table mapTable = null;
        ArrayList<ForeignColumn> sourceColumns = null;
        ArrayList<ForeignColumn> targetColumns = null;
        if (associationTable != null) {
            javax.ejb.Table table = associationTable.table();
            if (!table.name().equals("")) {
                sqlTable = table.name();
            }
            mapTable = manager.createTable(sqlTable);
            sourceColumns = EntityIntrospector.calculateColumns(mapTable, sourceType, associationTable.joinColumns());
            targetColumns = EntityIntrospector.calculateColumns(mapTable, targetType, associationTable.inverseJoinColumns());
        } else {
            mapTable = manager.createTable(sqlTable);
            sourceColumns = EntityIntrospector.calculateColumns(mapTable, sourceType);
            targetColumns = EntityIntrospector.calculateColumns(mapTable, targetType);
        }
        manyToManyField.setAssociationTable(mapTable);
        manyToManyField.setTable(sqlTable);
        manyToManyField.setSourceLink(new LinkColumns(mapTable, sourceType.getTable(), sourceColumns));
        manyToManyField.setTargetLink(new LinkColumns(mapTable, targetType.getTable(), targetColumns));
        sourceType.addField(manyToManyField);
    }

    static String toFieldName(String name) {
        if (Character.isLowerCase(name.charAt(0))) {
            return name;
        }
        if (name.length() == 1 || Character.isLowerCase(name.charAt(1))) {
            return new StringBuffer().append(Character.toLowerCase(name.charAt(0))).append(name.substring(1)).toString();
        }
        return name;
    }

    static ArrayList<ForeignColumn> calculateColumns(Table mapTable, EntityType type, JoinColumn[] joinColumns) {
        if (joinColumns == null || joinColumns.length == 0) {
            return EntityIntrospector.calculateColumns(mapTable, type);
        }
        ArrayList<ForeignColumn> columns = new ArrayList<ForeignColumn>();
        for (int i = 0; i < joinColumns.length; ++i) {
            ForeignColumn foreignColumn = mapTable.createForeignColumn(joinColumns[i].name(), type.getId().getKey().getColumns().get(0));
            columns.add(foreignColumn);
        }
        return columns;
    }

    static ArrayList<ForeignColumn> calculateColumns(Table mapTable, EntityType type) {
        ArrayList<ForeignColumn> columns = new ArrayList<ForeignColumn>();
        for (com.caucho.amber.table.Column key : type.getId().getColumns()) {
            columns.add(mapTable.createForeignColumn(key.getName(), key));
        }
        return columns;
    }

    static String toSqlName(String name) {
        CharBuffer cb = new CharBuffer();
        for (int i = 0; i < name.length(); ++i) {
            char ch = name.charAt(i);
            if (!Character.isUpperCase(ch)) {
                cb.append(ch);
                continue;
            }
            if (i > 0 && !Character.isUpperCase(name.charAt(i - 1))) {
                cb.append("_");
                cb.append(Character.toLowerCase(ch));
                continue;
            }
            if (i > 0 && i + 1 < name.length() && !Character.isUpperCase(name.charAt(i + 1))) {
                cb.append("_");
                cb.append(Character.toLowerCase(ch));
                continue;
            }
            cb.append(Character.toLowerCase(ch));
        }
        return cb.toString();
    }

    class ManyToOneCompletion
    extends Completion {
        private EntityType _entityType;
        private AccessibleObject _field;
        private String _fieldName;
        private Class _fieldType;

        ManyToOneCompletion(EntityType type, AccessibleObject field, String fieldName, Class fieldType) {
            this._entityType = type;
            this._field = field;
            this._fieldName = fieldName;
            this._fieldType = fieldType;
        }

        void complete() throws ConfigException {
            EntityIntrospector.this.addManyToOne(this._entityType, this._field, this._fieldName, this._fieldType);
        }
    }

    class ManyToManyCompletion
    extends Completion {
        private EntityType _entityType;
        private AccessibleObject _field;
        private String _fieldName;
        private Class _fieldType;

        ManyToManyCompletion(EntityType type, AccessibleObject field, String fieldName, Class fieldType) {
            this._entityType = type;
            this._field = field;
            this._fieldName = fieldName;
            this._fieldType = fieldType;
        }

        void complete() throws ConfigException {
            EntityIntrospector.this.addManyToMany(this._entityType, this._field, this._fieldName, this._fieldType);
        }
    }

    class OneToOneCompletion
    extends Completion {
        private EntityType _entityType;
        private AccessibleObject _field;
        private String _fieldName;
        private Class _fieldType;

        OneToOneCompletion(EntityType type, AccessibleObject field, String fieldName, Class fieldType) {
            this._entityType = type;
            this._field = field;
            this._fieldName = fieldName;
            this._fieldType = fieldType;
        }

        void complete() throws ConfigException {
            OneToOne oneToOneAnn = (OneToOne)this._field.getAnnotation(ClassLiteral.getClass((String)"javax/ejb/OneToOne"));
            AmberManager manager = this._entityType.getAmberManager();
            String targetName = oneToOneAnn.targetEntity();
            if (targetName == null || targetName.equals("")) {
                throw new ConfigException(L.l("can't determine target name"));
            }
            EntityType targetType = manager.getEntity(targetName);
            if (targetType == null) {
                throw new ConfigException(L.l("'{0}' is an unknown entity.", targetName));
            }
            EntityManyToOneField sourceField = this.getSourceField(targetType, this._entityType);
            if (sourceField == null) {
                throw new ConfigException(L.l("'{0}' does not have a matching ManyToOne relation.", targetType.getName()));
            }
            DependentEntityOneToOneField oneToOne = new DependentEntityOneToOneField(this._entityType, this._fieldName);
            oneToOne.setTargetField(sourceField);
            this._entityType.addField(oneToOne);
        }

        private EntityManyToOneField getSourceField(EntityType targetType, EntityType entity) {
            Iterator<AmberField> i$ = targetType.getFields().iterator();
            while (i$.hasNext()) {
                EntityManyToOneField manyToOne;
                AmberField field = i$.next();
                if (!(field instanceof EntityManyToOneField) || !(manyToOne = (EntityManyToOneField)field).getEntityType().equals(entity)) continue;
                return manyToOne;
            }
            return null;
        }
    }

    class OneToManyCompletion
    extends Completion {
        private EntityType _entityType;
        private AccessibleObject _field;
        private String _fieldName;
        private Class _fieldType;

        OneToManyCompletion(EntityType type, AccessibleObject field, String fieldName, Class fieldType) {
            this._entityType = type;
            this._field = field;
            this._fieldName = fieldName;
            this._fieldType = fieldType;
        }

        void complete() throws ConfigException {
            OneToMany oneToManyAnn = (OneToMany)this._field.getAnnotation(ClassLiteral.getClass((String)"javax/ejb/OneToMany"));
            AmberManager manager = this._entityType.getAmberManager();
            String targetName = oneToManyAnn.targetEntity();
            if (targetName == null || targetName.equals("")) {
                throw new ConfigException(L.l("can't determine target name"));
            }
            EntityType targetType = manager.getEntity(targetName);
            if (targetType == null) {
                throw new ConfigException(L.l("'{0}' is an unknown entity.", targetName));
            }
            EntityManyToOneField sourceField = this.getSourceField(targetType, this._entityType);
            if (sourceField == null) {
                throw new ConfigException(L.l("'{0}' does not have a matching ManyToOne relation.", targetType.getName()));
            }
            EntityOneToManyField oneToMany = new EntityOneToManyField(this._entityType, this._fieldName);
            oneToMany.setSourceField(sourceField);
            this._entityType.addField(oneToMany);
        }

        private EntityManyToOneField getSourceField(EntityType targetType, EntityType entity) {
            Iterator<AmberField> i$ = targetType.getFields().iterator();
            while (i$.hasNext()) {
                EntityManyToOneField manyToOne;
                AmberField field = i$.next();
                if (!(field instanceof EntityManyToOneField) || !(manyToOne = (EntityManyToOneField)field).getEntityType().equals(entity)) continue;
                return manyToOne;
            }
            return null;
        }
    }

    class Completion {
        Completion() {
        }

        void complete() throws ConfigException {
        }
    }
}

