/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.ejb.gen;

import com.caucho.amber.field.IdField;
import com.caucho.amber.type.EntityType;
import com.caucho.config.ConfigException;
import com.caucho.ejb.cfg.EjbConfig;
import com.caucho.ejb.cfg.EjbEntityBean;
import com.caucho.ejb.gen.IdFieldCompare;
import com.caucho.ejb.ql.EjbSelectQuery;
import com.caucho.java.JavaWriter;
import com.caucho.java.gen.BaseMethod;
import com.caucho.util.L10N;
import com.rc.retroweaver.runtime.ClassLiteral;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;

public abstract class AbstractQueryMethod
extends BaseMethod {
    private static final L10N L = new L10N(ClassLiteral.getClass((String)"com/caucho/ejb/gen/AbstractQueryMethod"));
    private Method _method;
    private EjbEntityBean _bean;
    private EjbSelectQuery _query;
    private boolean _queryLoadsBean = true;

    protected AbstractQueryMethod(EjbEntityBean bean, Method method, EjbSelectQuery query) throws ConfigException {
        super(method);
        this._bean = bean;
        this._query = query;
        this._method = method;
    }

    public void setQueryLoadsBean(boolean queryLoadsBean) {
        this._queryLoadsBean = queryLoadsBean;
    }

    public Class[] getParameterTypes() {
        return this._method.getParameterTypes();
    }

    public Class getReturnType() {
        return this._method.getReturnType();
    }

    protected String generateBeanId() {
        return "bean.__caucho_getPrimaryKey()";
    }

    void generatePrepareQuery(JavaWriter out, String[] args) throws IOException {
        out.println("com.caucho.amber.AmberQuery query;");
        out.print("query = trans.getAmberConnection().prepareQuery(\"");
        out.print(this._query.toAmberQuery(args));
        out.println("\");");
        int len = args.length;
        if (this._query.getMaxArg() < len) {
            len = this._query.getMaxArg();
        }
        if (len > 0 || this._query.getThisExpr() != null) {
            out.println("int index = 1;");
        }
        Class[] paramTypes = this.getParameterTypes();
        for (int i = 0; i < len; ++i) {
            this.generateSetParameter(out, paramTypes[i], args[i]);
        }
        if (this._query.getThisExpr() != null) {
            AbstractQueryMethod.generateSetThis(out, this._bean, "query");
        }
        if (this._query.getOffsetValue() > 0) {
            out.println("query.setFirstResult(" + this._query.getOffsetValue() + ");");
        } else if (this._query.getOffsetArg() > 0) {
            out.println("query.setFirstResult(" + args[this._query.getOffsetArg() - 1] + ");");
        }
        if (this._query.getLimitValue() > 0) {
            out.println("query.setMaxResults(" + this._query.getLimitValue() + ");");
        } else if (this._query.getLimitArg() > 0) {
            out.println("query.setMaxResults(" + args[this._query.getLimitArg() - 1] + ");");
        }
        if (!this._queryLoadsBean) {
            out.println("query.setLoadOnQuery(false);");
        }
    }

    public static void generateSetThis(JavaWriter out, EjbEntityBean bean, String query) throws IOException {
        EntityType amberType = bean.getEntityType();
        ArrayList<IdField> keys = new ArrayList<IdField>();
        keys.addAll(amberType.getId().getKeys());
        Collections.sort(keys, new IdFieldCompare());
        Iterator i$ = keys.iterator();
        while (i$.hasNext()) {
            IdField field = (IdField)i$.next();
            field.generateSet(out, query + "", "index", "super");
        }
    }

    public void generateSetParameter(JavaWriter out, Class type, String arg) throws IOException {
        AbstractQueryMethod.generateSetParameter(out, this._bean.getConfig(), type, "query", arg);
    }

    public static void generateSetParameter(JavaWriter out, EjbConfig config, Class type, String query, String arg) throws IOException {
        if (type.equals(Boolean.TYPE)) {
            out.println(query + ".setBoolean(index++, " + arg + ");");
        } else if (type.equals(Byte.TYPE)) {
            out.println(query + ".setInt(index++, " + arg + ");");
        } else if (type.equals(Short.TYPE)) {
            out.println(query + ".setInt(index++, " + arg + ");");
        } else if (type.equals(Integer.TYPE)) {
            out.println(query + ".setInt(index++, " + arg + ");");
        } else if (type.equals(Long.TYPE)) {
            out.println(query + ".setLong(index++, " + arg + ");");
        } else if (type.equals(Character.TYPE)) {
            out.println(query + ".setString(index++, String.valueOf(" + arg + "));");
        } else if (type.equals(Float.TYPE)) {
            out.println(query + ".setFloat(index++, " + arg + ");");
        } else if (type.equals(Double.TYPE)) {
            out.println(query + ".setDouble(index++, " + arg + ");");
        } else if (ClassLiteral.getClass((String)"java/sql/Timestamp").isAssignableFrom(type)) {
            out.println(query + ".setTimestamp(index++, " + arg + ");");
        } else if (ClassLiteral.getClass((String)"java/sql/Date").isAssignableFrom(type)) {
            out.println(query + ".setDate(index++, " + arg + ");");
        } else if (ClassLiteral.getClass((String)"java/sql/Time").isAssignableFrom(type)) {
            out.println(query + ".setTime(index++, " + arg + ");");
        } else if (ClassLiteral.getClass((String)"java/util/Date").isAssignableFrom(type)) {
            out.println("{");
            out.println("  java.util.Date _caucho_tmp_date = " + arg + ";");
            out.println("  if (_caucho_tmp_date == null)");
            out.println("    " + query + ".setNull(index++, java.sql.Types.TIMESTAMP);");
            out.println("  else");
            out.println("    " + query + ".setTimestamp(index++, new java.sql.Timestamp(_caucho_tmp_date.getTime()));");
            out.println("}");
        } else if (type.equals(ClassLiteral.getClass((String)"java/lang/Boolean"))) {
            out.println("if (" + arg + " == null)");
            out.println("  " + query + ".setNull(index++, java.sql.Types.BIT);");
            out.println("else");
            out.println("  " + query + ".setBoolean(index++, " + arg + ".booleanValue());");
        } else if (type.equals(ClassLiteral.getClass((String)"java/lang/Character"))) {
            out.println("if (" + arg + " == null)");
            out.println("  " + query + ".setNull(index++, java.sql.Types.VARCHAR);");
            out.println("else");
            out.println("  " + query + ".setString(index++, " + arg + ".toString());");
        } else if (ClassLiteral.getClass((String)"java/lang/String").equals(type)) {
            out.println("  " + query + ".setString(index++, " + arg + ");");
        } else if (type.equals(ClassLiteral.getClass((String)"java/lang/Byte"))) {
            out.println("if (" + arg + " == null)");
            out.println("  " + query + ".setNull(index++, java.sql.Types.TINYINT);");
            out.println("else");
            out.println("  " + query + ".setInt(index++, " + arg + ".byteValue());");
        } else if (type.equals(ClassLiteral.getClass((String)"java/lang/Short"))) {
            out.println("if (" + arg + " == null)");
            out.println("  " + query + ".setNull(index++, java.sql.Types.SMALLINT);");
            out.println("else");
            out.println("  " + query + ".setInt(index++, " + arg + ".shortValue());");
        } else if (type.equals(ClassLiteral.getClass((String)"java/lang/Integer"))) {
            out.println("if (" + arg + " == null)");
            out.println("  " + query + ".setNull(index++, java.sql.Types.INTEGER);");
            out.println("else");
            out.println("  " + query + ".setInt(index++, " + arg + ".intValue());");
        } else if (type.equals(ClassLiteral.getClass((String)"java/lang/Long"))) {
            out.println("if (" + arg + " == null)");
            out.println("  " + query + ".setNull(index++, java.sql.Types.BIGINT);");
            out.println("else");
            out.println("  " + query + ".setLong(index++, " + arg + ".longValue());");
        } else if (type.equals(ClassLiteral.getClass((String)"java/lang/Float"))) {
            out.println("if (" + arg + " == null)");
            out.println("  " + query + ".setNull(index++, java.sql.Types.REAL);");
            out.println("else");
            out.println("  " + query + ".setDouble(index++, " + arg + ".floatValue());");
        } else if (type.equals(ClassLiteral.getClass((String)"java/lang/Double"))) {
            out.println("if (" + arg + " == null)");
            out.println("  " + query + ".setNull(index++, java.sql.Types.DOUBLE);");
            out.println("else");
            out.println("  " + query + ".setDouble(index++, " + arg + ".doubleValue());");
        } else if (type.equals(ClassLiteral.getClass((String)"java/math/BigDecimal"))) {
            out.println("if (" + arg + " == null)");
            out.println("  " + query + ".setNull(index++, java.sql.Types.NUMERIC);");
            out.println("else");
            out.println("  " + query + ".setBigDecimal(index++, " + arg + ");");
        } else if (type.getName().equals("[B")) {
            out.println("if (" + arg + " == null)");
            out.println("  " + query + ".setNull(index++, java.sql.Types.VARBINARY);");
            out.println("else {");
            out.println("  byte []bArray = (byte []) " + arg + ";");
            out.println("  " + query + ".setBinaryStream(index++, new java.io.ByteArrayInputStream(bArray), bArray.length);");
            out.println("}");
        } else if (ClassLiteral.getClass((String)"javax/ejb/EJBLocalObject").isAssignableFrom(type)) {
            IdField field;
            EjbEntityBean bean = config.findEntityByLocal(type);
            if (bean == null) {
                throw new IllegalStateException(L.l("can't find bean for {0}", type.getName()));
            }
            EntityType amberType = bean.getEntityType();
            ArrayList<IdField> keys = new ArrayList<IdField>();
            keys.addAll(amberType.getId().getKeys());
            Collections.sort(keys, new IdFieldCompare());
            String var = "_expr" + out.generateId();
            out.printClass(type);
            out.println(" " + var + " = " + arg + ";");
            out.println("if (" + var + " != null) {");
            out.pushDepth();
            Iterator i$ = keys.iterator();
            while (i$.hasNext()) {
                field = (IdField)i$.next();
                field.generateSet(out, query + "", "index", arg);
            }
            out.popDepth();
            out.println("} else {");
            out.pushDepth();
            i$ = keys.iterator();
            while (i$.hasNext()) {
                field = (IdField)i$.next();
                field.generateSet(out, query + "", "index", null);
            }
            out.popDepth();
            out.println("}");
        } else {
            int i;
            Field[] fields = type.getFields();
            String var = "_expr" + out.generateId();
            out.printClass(type);
            out.println(" " + var + " = " + arg + ";");
            out.println("if (" + var + " != null) {");
            out.pushDepth();
            for (i = 0; i < fields.length; ++i) {
                Field field = fields[i];
                AbstractQueryMethod.generateSetParameter(out, config, field.getType(), query, arg + "." + field.getName());
            }
            out.popDepth();
            out.println("} else {");
            out.pushDepth();
            for (i = 0; i < fields.length; ++i) {
                out.println(query + ".setNull(index++, 0);");
            }
            out.popDepth();
            out.println("}");
        }
    }
}

