/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.ejb.hessian;

import com.caucho.ejb.hessian.HessianHandle;
import com.caucho.ejb.hessian.HessianHomeHandle;
import com.caucho.ejb.hessian.HessianReader;
import com.caucho.ejb.hessian.QSerializerFactory;
import com.caucho.hessian.io.HessianInput;
import com.caucho.hessian.io.HessianProtocolException;
import com.caucho.hessian.io.HessianRemoteResolver;
import com.caucho.hessian.io.HessianSerializerOutput;
import com.caucho.util.CharBuffer;
import com.caucho.vfs.ReadStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.ejb.EJBHome;
import javax.ejb.EJBObject;
import javax.ejb.Handle;
import javax.ejb.HomeHandle;

public class HessianWriter
extends HessianSerializerOutput {
    private InputStream _is;
    private HessianRemoteResolver _resolver;

    public HessianWriter(InputStream is, OutputStream os) {
        super(os);
        this._is = is;
    }

    public HessianWriter(OutputStream os) {
        super(os);
    }

    public HessianWriter() {
    }

    public void init(OutputStream os) {
        this._serializerFactory = new QSerializerFactory();
        super.init(os);
    }

    public void setRemoteResolver(HessianRemoteResolver resolver) {
        this._resolver = resolver;
    }

    public HessianInput doCall() throws Throwable {
        this.completeCall();
        if (!(this._is instanceof ReadStream)) {
            throw new IllegalStateException("Hessian call requires ReadStream");
        }
        ReadStream is = (ReadStream)this._is;
        String status = (String)is.getAttribute("status");
        if (!"200".equals(status)) {
            int ch;
            CharBuffer cb = new CharBuffer();
            while ((ch = is.readChar()) >= 0) {
                cb.append((char)ch);
            }
            throw new HessianProtocolException("exception: " + cb);
        }
        HessianReader in = new HessianReader();
        in.setSerializerFactory(this._serializerFactory);
        in.setRemoteResolver(this._resolver);
        ((HessianInput)in).init(this._is);
        in.startReply();
        return in;
    }

    public void close() {
        try {
            this.os.close();
            this._is.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void writeObjectImpl(Object obj) throws IOException {
        EJBHome ejbHome;
        HomeHandle handle;
        if (obj instanceof EJBObject) {
            EJBObject ejbObject = (EJBObject)obj;
            EJBHome ejbHome2 = ejbObject.getEJBHome();
            Handle handle2 = ejbObject.getHandle();
            if (handle2 instanceof HessianHandle) {
                HessianHandle hessianHandle = (HessianHandle)handle2;
                Class api = ejbHome2.getEJBMetaData().getRemoteInterfaceClass();
                this.writeRemote(api.getName(), hessianHandle.getURL());
                return;
            }
        } else if (obj instanceof EJBHome && (handle = (ejbHome = (EJBHome)obj).getHomeHandle()) instanceof HessianHomeHandle) {
            HessianHomeHandle hessianHandle = (HessianHomeHandle)handle;
            Class api = ejbHome.getEJBMetaData().getHomeInterfaceClass();
            this.writeRemote(api.getName(), hessianHandle.getURL("hessian"));
            return;
        }
        super.writeObjectImpl(obj);
    }
}

