/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.ejb.ql;

import com.caucho.amber.field.IdField;
import com.caucho.amber.field.KeyManyToOneField;
import com.caucho.amber.type.EntityType;
import com.caucho.config.ConfigException;
import com.caucho.ejb.cfg.EjbEntityBean;
import com.caucho.ejb.ql.FieldExpr;
import com.caucho.ejb.ql.Query;
import com.caucho.util.CharBuffer;
import com.caucho.util.L10N;
import com.caucho.util.Log;
import com.rc.retroweaver.runtime.ClassLiteral;
import java.util.ArrayList;
import java.util.Collections;
import java.util.logging.Logger;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Expr {
    static final Logger log = Log.open(ClassLiteral.getClass((String)"com/caucho/ejb/ql/Expr"));
    static final L10N L = new L10N(ClassLiteral.getClass((String)"com/caucho/ejb/ql/Expr"));
    protected Query _query;
    private Class _javaType;

    public Class getJavaType() {
        return this._javaType;
    }

    void setJavaType(Class javaType) {
        this._javaType = javaType;
    }

    String getReturnEJB() {
        return null;
    }

    boolean isKey() {
        return this.getReturnEJB() != null;
    }

    boolean isNumeric() {
        Class type = this.getJavaType();
        if (type == null) {
            return false;
        }
        if (ClassLiteral.getClass((String)"java/lang/Byte").equals(type) || ClassLiteral.getClass((String)"java/lang/Short").equals(type) || ClassLiteral.getClass((String)"java/lang/Integer").equals(type) || ClassLiteral.getClass((String)"java/lang/Long").equals(type) || ClassLiteral.getClass((String)"java/lang/Float").equals(type) || ClassLiteral.getClass((String)"java/lang/Double").equals(type)) {
            return true;
        }
        if (!type.isPrimitive()) {
            return false;
        }
        return !type.equals(Boolean.TYPE) && !type.equals(Character.TYPE);
    }

    boolean isInteger() {
        Class type = this.getJavaType();
        return ClassLiteral.getClass((String)"java/lang/Byte").equals(type) || ClassLiteral.getClass((String)"java/lang/Short").equals(type) || ClassLiteral.getClass((String)"java/lang/Integer").equals(type) || ClassLiteral.getClass((String)"java/lang/Long").equals(type) || Byte.TYPE.equals(type) || Short.TYPE.equals(type) || Integer.TYPE.equals(type) || Long.TYPE.equals(type);
    }

    int getComponentCount() {
        return 1;
    }

    boolean isString() {
        Class type = this.getJavaType();
        return ClassLiteral.getClass((String)"java/lang/String").equals(type) || Character.TYPE.equals(type) || ClassLiteral.getClass((String)"java/lang/Character").equals(type);
    }

    boolean isBoolean() {
        Class type = this.getJavaType();
        return Boolean.TYPE.equals(type) || ClassLiteral.getClass((String)"java/lang/Boolean").equals(type);
    }

    boolean isDate() {
        Class type = this.getJavaType();
        return ClassLiteral.getClass((String)"java/util/Date").equals(type) || ClassLiteral.getClass((String)"java/sql/Timestamp").equals(type) || ClassLiteral.getClass((String)"java/sql/Date").equals(type) || ClassLiteral.getClass((String)"java/sql/Time").equals(type);
    }

    boolean canCoerce() {
        return false;
    }

    boolean isCollection() {
        Class type = this.getJavaType();
        return ClassLiteral.getClass((String)"java/util/Collection").isAssignableFrom(type);
    }

    boolean isExternal() {
        return false;
    }

    EjbEntityBean getItemBean() {
        return null;
    }

    Expr newField(String field) throws ConfigException {
        throw this.error(L.l("`{0}' can't have field `{1}'.  Only path expressions referring to a single bean have fields.", (Object)this, field));
    }

    FieldExpr newReference(String field) throws ConfigException {
        throw this.error(L.l("`{0}' can't have reference `{1}'", (Object)this, field));
    }

    void evalTypes() throws ConfigException {
        if (this.getJavaType() == null) {
            throw this.error(new StringBuffer().append(L.l("'{0}' has no type.", this)).append(this.getClass()).toString());
        }
    }

    void generateSelect(CharBuffer cb) {
        this.generateWhere(cb);
    }

    String getSelectTable(CharBuffer cb) throws ConfigException {
        throw new IllegalStateException(L.l("`{0}' can't be used in a SELECT expression", this));
    }

    void generateWhere(CharBuffer cb) {
        throw new IllegalStateException(L.l("{0}: '{1}' can't be used in a WHERE expression", (Object)this.getClass().getName(), this));
    }

    void generateWhereSubExpr(CharBuffer cb) {
        this.generateWhere(cb);
    }

    void generateComponent(CharBuffer cb, int i) {
        if (i != 0) {
            throw new IllegalStateException(L.l("`{0}' can't be used in a WHERE multi-component", this));
        }
        this.generateWhereSubExpr(cb);
    }

    protected String keyComponent(EntityType type, int index) {
        ArrayList<String> names = new ArrayList<String>();
        this.addKeys(names, type, "");
        Collections.sort(names);
        return names.get(index);
    }

    protected void addKeys(ArrayList<String> names, EntityType type, String prefix) {
        for (IdField key : type.getId().getKeys()) {
            if (key instanceof KeyManyToOneField) {
                KeyManyToOneField manyToOne = (KeyManyToOneField)key;
                this.addKeys(names, manyToOne.getEntityType(), new StringBuffer().append(prefix).append(key.getName()).append(".").toString());
                continue;
            }
            names.add(new StringBuffer().append(prefix).append(key.getName()).toString());
        }
    }

    ConfigException error(String msg) {
        if (this._query != null) {
            return this._query.error(msg);
        }
        return new ConfigException(msg);
    }

    ConfigException error(Query query, String msg) {
        return query.error(msg);
    }
}

