/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.ejb.ql;

import com.caucho.config.ConfigException;
import com.caucho.ejb.ql.Expr;
import com.caucho.ejb.ql.Query;
import com.caucho.util.CharBuffer;

class IsExpr
extends Expr {
    private Expr _value;
    private int _op;
    private boolean _isNot;

    IsExpr(Query query, Expr value, int op, boolean isNot) throws ConfigException {
        this._query = query;
        this._value = value;
        this._op = op;
        this._isNot = isNot;
        this.evalTypes();
    }

    void evalTypes() throws ConfigException {
        if (this.getJavaType() != null) {
            return;
        }
        if (this._op == 138 && !this._value.isCollection()) {
            throw this.error(L.l("IS EMPTY requires a collection at `{0}'", this._value));
        }
        if (this._op == 139 && this._value.isCollection()) {
            throw this.error(L.l("IS NULL requires a single value at `{0}'", this._value));
        }
        this.setJavaType(Boolean.TYPE);
    }

    void generateWhere(CharBuffer cb) {
        this._value.generateWhereSubExpr(cb);
        Class valueType = this._value.getJavaType();
        if (this._isNot) {
            cb.append(" IS NOT ");
        } else {
            cb.append(" IS ");
        }
        switch (this._op) {
            case 139: {
                cb.append("NULL");
                break;
            }
            case 138: {
                cb.append("EMPTY");
            }
        }
    }

    public String toString() {
        String str = this._value.toString();
        str = this._isNot ? str + " IS NOT " : str + " IS ";
        switch (this._op) {
            case 139: {
                return str + "NULL";
            }
            case 138: {
                return str + "EMPTY";
            }
        }
        return super.toString();
    }
}

