/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.ejb.ql;

import com.caucho.amber.type.EntityType;
import com.caucho.config.ConfigException;
import com.caucho.ejb.cfg.CmrRelation;
import com.caucho.ejb.cfg.EjbEntityBean;
import com.caucho.ejb.ql.PathExpr;
import com.caucho.ejb.ql.Query;
import com.caucho.util.CharBuffer;

class RelationExpr
extends PathExpr {
    private PathExpr _base;
    private String _fieldName;
    private CmrRelation _relation;
    private String _keyTable;
    private String[] _keyColumns;
    private boolean _usesField;

    RelationExpr(Query query, PathExpr base, String field, CmrRelation relation) throws ConfigException {
        super(relation.getTargetBean());
        this._query = query;
        this._base = base;
        this._fieldName = field;
        this._relation = relation;
    }

    public Class getJavaType() {
        return this._relation.getTargetType();
    }

    void setUsesField() {
        if (this._usesField) {
            return;
        }
        this._usesField = true;
    }

    String getKeyTable() {
        return this._keyTable;
    }

    String[] getKeyFields() {
        return this._keyColumns;
    }

    String getTable() {
        return this._keyTable;
    }

    String getName() {
        return this._keyTable;
    }

    EjbEntityBean getBean() {
        return this._bean;
    }

    EjbEntityBean getItemBean() {
        return this._bean;
    }

    String getReturnEJB() {
        return this._bean.getEJBName();
    }

    int getComponentCount() {
        return this.getItemBean().getEntityType().getId().getKeyCount();
    }

    void generateSelect(CharBuffer cb) {
        this.generateWhere(cb);
    }

    String getSelectTable(CharBuffer cb) {
        return this.getKeyTable();
    }

    void generateWhere(CharBuffer cb) {
        this._base.generateWhere(cb);
        cb.append(".");
        cb.append(this._fieldName);
    }

    void generateComponent(CharBuffer cb, int index) {
        EjbEntityBean bean = this.getItemBean();
        EntityType type = bean.getEntityType();
        this._base.generateWhere(cb);
        cb.append(".");
        cb.append(this._fieldName);
        cb.append(".");
        cb.append(this.keyComponent(type, index));
    }

    public boolean equals(Object bObj) {
        if (!(bObj instanceof RelationExpr)) {
            return false;
        }
        RelationExpr b = (RelationExpr)bObj;
        return this._fieldName.equals(b._fieldName) && this._base.equals(b._base);
    }

    public int hashCode() {
        return 65531 * this._fieldName.hashCode() + this._base.hashCode();
    }

    public String toString() {
        return String.valueOf(this._base) + '.' + this._fieldName;
    }
}

