/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.el;

import com.caucho.el.Expr;
import com.caucho.vfs.WriteStream;
import java.io.IOException;
import javax.servlet.jsp.el.ELException;
import javax.servlet.jsp.el.VariableResolver;

public class AbstractBooleanExpr
extends Expr {
    public Object evalObject(VariableResolver env) throws ELException {
        return this.evalBoolean(env) ? Boolean.TRUE : Boolean.FALSE;
    }

    public String evalString(VariableResolver env) throws ELException {
        return this.evalBoolean(env) ? "true" : "false";
    }

    public long evalLong(VariableResolver env) throws ELException {
        ELException e = new ELException(L.l("`{0}': boolean expressions can not be converted to long values.", this));
        AbstractBooleanExpr.error(e, env);
        return 0L;
    }

    public double evalDouble(VariableResolver env) throws ELException {
        ELException e = new ELException(L.l("`{0}': boolean expressions can not be converted to double values.", this));
        AbstractBooleanExpr.error(e, env);
        return 0.0;
    }

    public void print(WriteStream out, VariableResolver env) throws IOException, ELException {
        if (this.evalBoolean(env)) {
            out.print("true");
        } else {
            out.print("false");
        }
    }

    public void printEscaped(WriteStream out, VariableResolver env) throws IOException, ELException {
        if (this.evalBoolean(env)) {
            out.print("true");
        } else {
            out.print("false");
        }
    }
}

