/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.el;

import com.caucho.el.Expr;
import com.caucho.el.MethodExpr;
import com.caucho.el.StringLiteral;
import com.caucho.util.BeanUtil;
import com.caucho.vfs.WriteStream;
import com.rc.retroweaver.runtime.ClassLiteral;
import java.io.IOException;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import javax.servlet.jsp.el.ELException;
import javax.servlet.jsp.el.VariableResolver;

public class ArrayExpr
extends Expr {
    private Expr _left;
    private Expr _right;
    private Class _lastClass;
    private String _lastField;
    private Method _lastMethod;

    public ArrayExpr(Expr left, Expr right) {
        this._left = left;
        this._right = right;
    }

    public Expr createMethod(Expr[] args) {
        if (!(this._right instanceof StringLiteral)) {
            return null;
        }
        StringLiteral literal = (StringLiteral)this._right;
        return new MethodExpr(this._left, literal.getValue(), args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object evalObject(VariableResolver env) throws ELException {
        Class<?> aClass;
        Object aObj = this._left.evalObject(env);
        if (aObj == null) {
            return null;
        }
        Object fieldObj = this._right.evalObject(env);
        if (fieldObj == null) {
            return null;
        }
        if (aObj instanceof Map) {
            return ((Map)aObj).get(fieldObj);
        }
        if (aObj instanceof List) {
            int ref = (int)ArrayExpr.toLong(fieldObj, env);
            try {
                List list = (List)aObj;
                if (ref < 0 || list.size() < ref) {
                    return null;
                }
                return list.get(ref);
            }
            catch (IndexOutOfBoundsException e) {
            }
            catch (Exception e) {
                return ArrayExpr.invocationError(e);
            }
        }
        if ((aClass = aObj.getClass()).isArray()) {
            int ref = (int)ArrayExpr.toLong(fieldObj, env);
            try {
                return Array.get(aObj, ref);
            }
            catch (IndexOutOfBoundsException e) {
            }
            catch (Exception e) {
                return ArrayExpr.error(e, env);
            }
        }
        String fieldName = ArrayExpr.toString(fieldObj, env);
        Method getMethod = null;
        try {
            ArrayExpr arrayExpr = this;
            synchronized (arrayExpr) {
                if (this._lastClass == aClass && this._lastField.equals(fieldName)) {
                    getMethod = this._lastMethod;
                } else {
                    getMethod = BeanUtil.getGetMethod(aClass, fieldName);
                    this._lastClass = aClass;
                    this._lastField = fieldName;
                    this._lastMethod = getMethod;
                }
            }
            if (getMethod != null) {
                return getMethod.invoke(aObj, (Object[])null);
            }
        }
        catch (Exception e) {
            return ArrayExpr.invocationError(e);
        }
        try {
            getMethod = aClass.getMethod("get", ClassLiteral.getClass((String)"java/lang/String"));
            if (getMethod != null) {
                return getMethod.invoke(aObj, fieldName);
            }
        }
        catch (NoSuchMethodException e) {
            return null;
        }
        catch (Exception e) {
            return ArrayExpr.invocationError(e);
        }
        try {
            getMethod = aClass.getMethod("get", ClassLiteral.getClass((String)"java/lang/Object"));
            if (getMethod != null) {
                return getMethod.invoke(aObj, fieldObj);
            }
        }
        catch (Exception e) {
            return ArrayExpr.invocationError(e);
        }
        ELException e = new ELException(L.l("no get method {0} for class {1}", (Object)fieldName, aClass.getName()));
        ArrayExpr.error(e, env);
        return null;
    }

    public void printCreate(WriteStream os) throws IOException {
        os.print("new com.caucho.el.ArrayExpr(");
        this._left.printCreate(os);
        os.print(", ");
        this._right.printCreate(os);
        os.print(")");
    }

    public boolean equals(Object o) {
        if (!(o instanceof ArrayExpr)) {
            return false;
        }
        ArrayExpr expr = (ArrayExpr)o;
        return this._left.equals(expr._left) && this._right.equals(expr._right);
    }

    public String toString() {
        return this._left + "[" + this._right + "]";
    }
}

