/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.es;

import com.caucho.es.Global;
import com.caucho.java.LineMap;
import com.caucho.util.CharBuffer;
import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;

public class ESException
extends Exception {
    public ESException() {
    }

    public ESException(String name) {
        super(name);
    }

    public ESException(Throwable e) {
        super(e);
    }

    public static void staticPrintESTrace(Exception e, OutputStream os) {
        CharArrayWriter writer = new CharArrayWriter();
        PrintWriter pw = new PrintWriter(writer);
        e.printStackTrace(pw);
        pw.close();
        char[] array = writer.toCharArray();
        CharBuffer cb = ESException.filter(array);
        if (os != null) {
            byte[] b = cb.toString().getBytes();
            try {
                os.write(b, 0, b.length);
            }
            catch (IOException e1) {}
        } else {
            System.out.println(cb);
        }
    }

    public static void staticPrintESTrace(Exception e, PrintWriter os) {
        CharArrayWriter writer = new CharArrayWriter();
        PrintWriter pw = new PrintWriter(writer);
        e.printStackTrace(pw);
        pw.close();
        char[] array = writer.toCharArray();
        CharBuffer cb = ESException.filter(array);
        if (os != null) {
            os.print(cb.toString());
        } else {
            System.out.println(cb);
        }
    }

    public void printESStackTrace(OutputStream os) {
        ESException.staticPrintESTrace((Exception)this, os);
    }

    public void printESStackTrace() {
        this.printESStackTrace(System.out);
    }

    public void printESStackTrace(PrintWriter out) {
        CharArrayWriter writer = new CharArrayWriter();
        PrintWriter pw = new PrintWriter(writer);
        this.printStackTrace(pw);
        pw.close();
        char[] array = writer.toCharArray();
        CharBuffer cb = ESException.filter(array);
        out.print(cb.toString());
    }

    private static CharBuffer filter(char[] array) {
        CharBuffer buf = new CharBuffer();
        CharBuffer fun = new CharBuffer();
        CharBuffer file = new CharBuffer();
        boolean hasJavaScript = false;
        int i = 0;
        while (i < array.length) {
            String function;
            String className;
            int end;
            fun.clear();
            file.clear();
            int start = i;
            for (end = i; end < array.length && array[end] != '\n'; ++end) {
            }
            while (i < end && Character.isWhitespace(array[i])) {
                fun.append(array[i]);
                ++i;
            }
            while (i < end && !Character.isWhitespace(array[i])) {
                fun.append(array[i]);
                ++i;
            }
            if (!fun.endsWith("at")) {
                for (i = start; i < end; ++i) {
                    buf.append(array[i]);
                }
                i = end + 1;
                buf.append('\n');
                continue;
            }
            while (i < end && Character.isWhitespace(array[i])) {
                ++i;
            }
            fun.clear();
            while (i < end && !Character.isWhitespace(array[i]) && array[i] != '(') {
                fun.append(array[i]);
                ++i;
            }
            if (fun.startsWith("com.caucho.es.")) {
                i = end + 1;
                continue;
            }
            if (i < end && array[i] == '(') {
                ++i;
            }
            while (i < end && array[i] != ')') {
                file.append(array[i]);
                ++i;
            }
            i = end + 1;
            if (fun.endsWith(".call")) continue;
            int p = fun.lastIndexOf('.');
            if (p > 0) {
                className = fun.substring(0, p);
                function = fun.substring(p + 1);
            } else {
                className = "";
                function = fun.toString();
            }
            Global global = Global.getGlobalProto();
            LineMap lineMap = global != null ? global.getLineMap(className) : null;
            String line = file.toString();
            if (lineMap != null) {
                p = file.indexOf(':');
                if (p > 0) {
                    try {
                        String filename = file.substring(0, p);
                        int lineNo = Integer.parseInt(file.substring(p + 1));
                        line = lineMap.convertLine(filename, lineNo);
                    }
                    catch (Exception e) {}
                } else {
                    line = lineMap.convertLine(file.toString(), 1);
                }
            }
            buf.append("\tat ");
            buf.append(fun);
            buf.append("(");
            buf.append(line);
            buf.append(")");
            buf.append("\n");
            hasJavaScript = true;
        }
        return buf;
    }
}

