/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.es;

import com.caucho.es.ESBase;
import com.caucho.es.ESException;
import com.caucho.es.ESObject;
import com.caucho.es.ESString;
import com.caucho.es.ESWrapper;
import com.caucho.es.Global;
import com.caucho.vfs.VfsWriteObject;
import com.caucho.vfs.WriteStream;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public class ESNumber
extends ESBase
implements VfsWriteObject,
Externalizable {
    public static ESNumber ZERO = new ESNumber(0.0);
    public static ESNumber ONE = new ESNumber(1.0);
    public static ESNumber NaN = new ESNumber(Double.NaN);
    static ESNumber[] ints = new ESNumber[128];
    private double value;

    public ESNumber() {
        this.prototype = esNull;
    }

    private ESNumber(double value) {
        this.prototype = esNull;
        this.value = value;
    }

    public static ESNumber create(double value) {
        try {
            if (value >= 128.0 || value <= 0.0) {
                return new ESNumber(value);
            }
            int intValue = (int)value;
            if ((double)intValue == value) {
                return ints[intValue];
            }
            return new ESNumber(value);
        }
        catch (Exception e) {
            return new ESNumber(value);
        }
    }

    public boolean toBoolean() {
        return !Double.isNaN(this.value) && this.value != 0.0;
    }

    public boolean isNum() {
        return true;
    }

    public double toNum() {
        return this.value;
    }

    public ESObject toObject() throws ESException {
        return new ESWrapper("Number", (ESBase)Global.getGlobalProto().numProto, this);
    }

    public Object toJavaObject() {
        return new Double(this.value);
    }

    public ESBase typeof() throws ESException {
        return ESString.create("number");
    }

    public Class getJavaType() {
        if ((double)((int)this.value) == this.value) {
            return Integer.TYPE;
        }
        return Double.TYPE;
    }

    public ESBase getProperty(ESString key) throws Throwable {
        return Global.getGlobalProto().numProto.getProperty(key);
    }

    public ESString toStr() {
        int intValue = (int)this.value;
        if ((double)intValue == this.value) {
            return ESString.create(intValue);
        }
        return ESString.create(this.toString());
    }

    public String toString() {
        int intValue = (int)this.value;
        if ((double)intValue == this.value) {
            return String.valueOf(intValue);
        }
        if ((double)((long)this.value) == this.value) {
            return String.valueOf((long)this.value);
        }
        if (Double.isNaN(this.value)) {
            return "NaN";
        }
        if (Double.isInfinite(this.value)) {
            return this.value < 0.0 ? "-Infinity" : "Infinity";
        }
        return String.valueOf(this.value).toLowerCase();
    }

    public void print(WriteStream os) throws IOException {
        int intValue = (int)this.value;
        if ((double)intValue == this.value) {
            os.print(intValue);
        } else if ((double)((long)this.value) == this.value) {
            os.print((long)this.value);
        } else if (Double.isNaN(this.value)) {
            os.print("NaN");
        } else if (Double.isInfinite(this.value)) {
            os.print(this.value < 0.0 ? "-Infinity" : "Infinity");
        } else {
            os.print(this.value);
        }
    }

    public int hashCode() {
        long bits = Double.doubleToLongBits(this.value);
        return (int)bits + 65517 * (int)(bits >> 32);
    }

    public boolean equals(Object b) {
        return b instanceof ESNumber && this.value == ((ESNumber)b).value;
    }

    public boolean ecmaEquals(ESBase b) throws Throwable {
        return b != esNull && this.value == b.toNum();
    }

    public boolean lessThan(ESBase b, boolean neg) throws Throwable {
        double db = b.toNum();
        if (Double.isNaN(this.value) || Double.isNaN(db)) {
            return false;
        }
        return this.value < db != neg;
    }

    public ESBase plus(ESBase b) throws Throwable {
        if (b instanceof ESNumber) {
            return ESNumber.create(this.value + ((ESNumber)b).value);
        }
        ESBase primB = b.toPrimitive(0);
        if (primB instanceof ESString) {
            return ESString.create(this.toString() + primB.toString());
        }
        return ESNumber.create(this.value + primB.toNum());
    }

    public void writeExternal(ObjectOutput os) throws IOException {
        os.writeDouble(this.value);
    }

    public void readExternal(ObjectInput is) throws IOException {
        this.value = is.readDouble();
    }

    static {
        for (int i = 0; i < ints.length; ++i) {
            ESNumber.ints[i] = new ESNumber(i);
        }
    }
}

