/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.es.parser;

import com.caucho.es.ESException;
import com.caucho.es.ESId;
import com.caucho.es.parser.Block;
import com.caucho.es.parser.Expr;
import com.caucho.es.parser.Function;
import com.caucho.es.parser.IdExpr;
import java.io.IOException;

class DeleteExpr
extends Expr {
    private Expr lhs;
    private IdExpr var;
    private ESId id;
    private Expr field;
    private boolean isTop;

    DeleteExpr(Block block, IdExpr var) {
        super(block);
        this.var = var;
        var.setUsed();
    }

    DeleteExpr(Block block, Expr lhs, ESId id) {
        super(block);
        this.lhs = lhs;
        this.id = id;
        if (lhs != null) {
            lhs.setUsed();
        }
    }

    DeleteExpr(Block block, Expr lhs, Expr field) {
        super(block);
        this.lhs = lhs;
        this.field = field;
        if (lhs != null) {
            lhs.setUsed();
        }
        if (field != null) {
            field.setUsed();
        }
    }

    void exprStatement(Function fun) throws ESException {
        this.isTop = true;
        fun.addExpr(this);
    }

    void print() throws IOException {
        if (this.var != null && this.var.isLocal()) {
            if (!this.isTop) {
                this.cl.print("ESBoolean.FALSE");
            }
        } else if (this.var != null) {
            if (this.function.isGlobalScope()) {
                this.cl.print("_env.global.delete(");
            } else {
                this.cl.print("_env.deleteScopeProperty(");
            }
            this.printLiteral(this.var.getId());
            this.cl.print(")");
            if (this.isTop) {
                this.cl.println(";");
            }
        } else if (this.id != null) {
            this.lhs.print();
            this.cl.print(".delete(");
            this.printLiteral(this.id);
            this.cl.print(")");
            if (this.isTop) {
                this.cl.println(";");
            }
        } else {
            this.lhs.print();
            this.cl.print(".delete(");
            this.field.printStr();
            this.cl.print(")");
            if (this.isTop) {
                this.cl.println(";");
            }
        }
    }
}

