/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.es.parser;

import com.caucho.es.ESBase;
import com.caucho.es.ESBoolean;
import com.caucho.es.ESId;
import com.caucho.es.ESNumber;
import com.caucho.es.ESParseException;
import com.caucho.es.ESString;
import com.caucho.es.Global;
import com.caucho.java.LineMap;
import com.caucho.util.CharBuffer;
import com.caucho.util.L10N;
import com.caucho.vfs.ReadStream;
import com.rc.retroweaver.runtime.ClassLiteral;
import java.io.CharConversionException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.regex.Pattern;

class Lexer {
    private static final L10N L = new L10N(ClassLiteral.getClass((String)"com/caucho/es/parser/Lexer"));
    static final int ERROR = -3;
    static final int START = -2;
    static final int EOF = -1;
    static final int RESERVED = 256;
    static final int LITERAL = 257;
    static final int REGEXP = 258;
    static final int IDENTIFIER = 259;
    static final int THIS = 260;
    static final int HASH_DEF = 261;
    static final int HASH_REF = 262;
    static final int BIN_OP = 263;
    static final int UNARY_OP = 264;
    static final int BANDU_OP = 265;
    static final int RSHIFT = 266;
    static final int URSHIFT = 267;
    static final int LSHIFT = 268;
    static final int BITAND = 269;
    static final int BITOR = 270;
    static final int GEQ = 271;
    static final int LEQ = 272;
    static final int EQ = 273;
    static final int NEQ = 274;
    static final int STRICT_EQ = 275;
    static final int STRICT_NEQ = 276;
    static final int AND = 277;
    static final int OR = 278;
    static final int ASSIGN_OP = 279;
    static final int PREFIX = 280;
    static final int POSTFIX = 281;
    static final int DELETE = 282;
    static final int VOID = 283;
    static final int TYPEOF = 284;
    static final int IF = 285;
    static final int ELSE = 286;
    static final int SWITCH = 287;
    static final int CASE = 288;
    static final int DEFAULT = 289;
    static final int WHILE = 290;
    static final int DO = 291;
    static final int FOR = 292;
    static final int IN = 293;
    static final int BREAK = 294;
    static final int CONTINUE = 295;
    static final int FUNCTION = 296;
    static final int CONSTRUCTOR = 296;
    static final int RETURN = 297;
    static final int NEW = 298;
    static final int VAR = 299;
    static final int WITH = 300;
    static final int NULL = 301;
    static final int UNDEFINED = 302;
    static final int TRUE = 303;
    static final int FALSE = 304;
    static final int EVAL = 305;
    static final int CLASS = 306;
    static final int EXTENDS = 307;
    static final int SYNCHRONIZED = 308;
    static final int TRY = 309;
    static final int CATCH = 310;
    static final int FINALLY = 311;
    static final int THROW = 312;
    static final int IMPORT = 313;
    static final int STATIC = 314;
    static final int LAST_LEXEME = 314;
    static HashMap ops;
    static HashMap reserved;
    Global resin;
    ReadStream is;
    int peek = -1;
    int peek2 = -1;
    ArrayList macros = new ArrayList();
    CharBuffer macroText;
    int macroIndex;
    int macroOldLine;
    int _flags;
    int state;
    int lbrace;
    int stringClose;
    boolean isRegexp;
    LineMap lineMap;
    String filename;
    String lastFilename;
    String beginFilename;
    int lastLine;
    int beginLine;
    int beginLineCh;
    int line;
    int lineCh;
    Op op;
    int lexeme;
    int lastLexeme;
    CharBuffer text;
    CharBuffer lineText = new CharBuffer();
    boolean isEof = false;
    ESId id;
    ESBase literal;
    int intValue;
    boolean hasLf;
    boolean regexpOk;
    String writeln;
    CharBuffer temp = new CharBuffer();

    Lexer(ReadStream is, String filename, int line, LineMap lineMap) {
        this.filename = filename;
        this.line = line;
        this.lastFilename = filename;
        this.lastLine = line;
        this.lineMap = lineMap;
        this.is = is;
        this.peek = -1;
        this.peek2 = -1;
        this.text = new CharBuffer();
        this.lexeme = -2;
        this.lastLexeme = -2;
        this.regexpOk = true;
        this.macroText = null;
        this.macroIndex = 0;
        if (ops == null) {
            ops = new HashMap();
            this.opsPut(".", 46, 46, 1, false);
            this.opsPut("++", 43, 281, 1, false);
            this.opsPut("--", 45, 281, 1, false);
            this.opsPut("@", 64, 64, 1, false);
            this.opsPut("~", 126, 264, 3, false);
            this.opsPut("!", 33, 264, 3, false);
            this.opsPut("*", 42, 263, 4, false);
            this.opsPut("/", 47, 263, 4, false);
            this.opsPut("%", 37, 263, 4, false);
            this.opsPut("+", 43, 265, 5, false);
            this.opsPut("-", 45, 265, 5, false);
            this.opsPut(">>", 266, 263, 6, false);
            this.opsPut(">>>", 267, 263, 6, false);
            this.opsPut("<<", 268, 263, 6, false);
            this.opsPut(">", 62, 263, 7, false);
            this.opsPut(">=", 271, 263, 7, false);
            this.opsPut("<", 60, 263, 7, false);
            this.opsPut("<=", 272, 263, 7, false);
            this.opsPut("==", 273, 263, 7, false);
            this.opsPut("!=", 274, 263, 7, false);
            this.opsPut("===", 275, 263, 7, false);
            this.opsPut("!==", 276, 263, 7, false);
            this.opsPut("&", 38, 263, 9, false);
            this.opsPut("^", 94, 263, 10, false);
            this.opsPut("|", 124, 263, 11, false);
            this.opsPut("&&", 277, 263, 12, false);
            this.opsPut("||", 278, 263, 13, false);
            this.opsPut("?", 63, 63, 14, false);
            this.opsPut("=", 61, 61, 15, true);
            this.opsPut("*=", 42, 61, 15, true);
            this.opsPut("/=", 47, 61, 15, true);
            this.opsPut("%=", 37, 61, 15, true);
            this.opsPut("+=", 43, 61, 15, true);
            this.opsPut("-=", 45, 61, 15, true);
            this.opsPut(">>=", 266, 61, 15, true);
            this.opsPut(">>>=", 267, 61, 15, true);
            this.opsPut("<<=", 268, 61, 15, true);
            this.opsPut("&=", 38, 61, 15, true);
            this.opsPut("^=", 94, 61, 15, true);
            this.opsPut("|=", 124, 61, 15, true);
            this.opsPut(",", 44, 44, 16, false);
            reserved = new HashMap();
            this.resPut("new", 298);
            this.resPut("var", 299);
            this.resPut("delete", 282);
            this.resPut("void", 283);
            this.resPut("typeof", 284);
            this.resPut("if", 285);
            this.resPut("else", 286);
            this.resPut("switch", 287);
            this.resPut("case", 288);
            this.resPut("default", 289);
            this.resPut("while", 290);
            this.resPut("do", 291);
            this.resPut("for", 292);
            this.resPut("in", 293);
            this.resPut("break", 294);
            this.resPut("continue", 295);
            this.resPut("null", 301);
            this.resPut("undefined", 302);
            this.resPut("true", 303);
            this.resPut("false", 304);
            this.resPut("this", 260);
            this.resPut("eval", 305);
            this.resPut("function", 296);
            this.resPut("return", 297);
            this.resPut("with", 300);
            this.resPut("class", 306);
            this.resPut("extends", 307);
            this.resPut("synchronized", 308);
            this.resPut("try", 309);
            this.resPut("catch", 310);
            this.resPut("finally", 311);
            this.resPut("throw", 312);
            this.resPut("import", 313);
            this.resPut("static", 314);
            this.resPut("const", 256);
            this.resPut("debugger", 256);
            this.resPut("enum", 256);
            this.resPut("export", 256);
            this.resPut("super", 256);
            this.resPut("public", 256);
            this.resPut("private", 256);
            this.resPut("protected", 256);
            this.resPut("throws", 256);
        }
    }

    Lexer(ReadStream is, String filename, int line) {
        this(is, filename, line, null);
    }

    Lexer(ReadStream is, LineMap lineMap) {
        this(is, null, 1, lineMap);
    }

    void setLineMap(LineMap lineMap) {
        this.lineMap = lineMap;
    }

    private void opsPut(String name, int code, int lex, int prec, boolean flag) {
        ops.put(new CharBuffer(name), new Op(code, lex, prec, flag));
    }

    private void resPut(String name, int code) {
        reserved.put(new CharBuffer(name), new Integer(code));
    }

    int peek() throws ESParseException {
        try {
            if (this.lexeme == -2) {
                this.lexeme = this.lex();
            }
            this.lastLexeme = this.lexeme;
            return this.lexeme;
        }
        catch (ESParseException e) {
            throw e;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw this.error(e.toString());
        }
    }

    int next() throws ESParseException {
        try {
            int value = this.lexeme;
            if (value == -2) {
                value = this.lex();
            }
            this.lastLexeme = value;
            this.lexeme = -2;
            this.lastFilename = this.beginFilename;
            this.lastLine = this.beginLine;
            return value;
        }
        catch (ESParseException e) {
            throw e;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw this.error(e == null ? "" : e.toString());
        }
    }

    int prev() {
        if (this.lastLexeme == -2) {
            throw new RuntimeException();
        }
        this.lexeme = this.lastLexeme;
        this.lastLexeme = -2;
        return this.lexeme;
    }

    int last() {
        if (this.lastLexeme == -2) {
            throw new RuntimeException();
        }
        return this.lastLexeme;
    }

    private int peekCh() throws ESParseException {
        try {
            int ch = this.read();
            this.ungetc(ch);
            return ch;
        }
        catch (Exception e) {
            return -1;
        }
    }

    private int lex() throws ESParseException {
        this.lastFilename = this.beginFilename;
        this.lastLine = this.beginLine;
        this.hasLf = false;
        block30: while (true) {
            this.beginFilename = this.filename;
            this.beginLine = this.line;
            this.beginLineCh = this.lineCh;
            int ch = this.read();
            block1 : switch (ch) {
                case -1: {
                    this.isEof = true;
                    return -1;
                }
                case 9: 
                case 11: 
                case 12: 
                case 32: {
                    break;
                }
                case 10: {
                    this.newline();
                    this.hasLf = true;
                    break;
                }
                case 33: 
                case 38: 
                case 42: 
                case 43: 
                case 44: 
                case 45: 
                case 60: 
                case 61: 
                case 62: 
                case 63: 
                case 94: 
                case 124: 
                case 126: {
                    this.regexpOk = true;
                    return this.lexOp(ch);
                }
                case 41: 
                case 93: {
                    this.regexpOk = false;
                    return ch;
                }
                case 40: 
                case 58: 
                case 59: 
                case 91: 
                case 123: 
                case 125: {
                    this.regexpOk = true;
                    return ch;
                }
                case 46: {
                    int ch2 = this.read();
                    if (ch2 >= 48 && ch2 <= 57) {
                        this.regexpOk = false;
                        return this.lexFloat(0.0, ch2);
                    }
                    this.regexpOk = true;
                    this.ungetc(ch2);
                    return this.lexOp(ch);
                }
                case 47: {
                    int ch2 = this.read();
                    if (ch2 == 47) {
                        ch2 = this.read();
                        while (ch2 > 0 && ch2 != 10) {
                            ch2 = this.read();
                        }
                        this.ungetc(ch2);
                        break;
                    }
                    if (ch2 == 42) {
                        boolean seenStar = false;
                        ch2 = this.read();
                        while (true) {
                            if (ch2 <= 0 || seenStar && ch2 == 47) continue block30;
                            if (ch2 == 47 && (ch2 = this.read()) == 42) {
                                throw this.error(L.l("comments can't nest"));
                            }
                            boolean bl = seenStar = ch2 == 42;
                            if (ch2 == 10) {
                                this.newline();
                                this.hasLf = true;
                            }
                            ch2 = this.read();
                        }
                    }
                    if (this.regexpOk) {
                        this.regexpOk = false;
                        this.ungetc(ch2);
                        this.lexString('/', null, true, false);
                        this.readRegexpFlags();
                        try {
                            Pattern regexp = Pattern.compile(this.literal.toString(), this._flags);
                        }
                        catch (Exception e) {
                            throw this.error(String.valueOf(e));
                        }
                        return 258;
                    }
                    this.ungetc(ch2);
                    return this.lexOp(ch);
                }
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: {
                    this.regexpOk = false;
                    return this.lexNumber(ch);
                }
                case 34: 
                case 39: {
                    this.regexpOk = false;
                    return this.lexString((char)ch, null, false, false);
                }
                case 64: {
                    int ch2 = this.read();
                    switch (ch2) {
                        case 34: {
                            CharBuffer macro = new CharBuffer();
                            macro.append('(');
                            this.interpolate(macro, 34, null, "\"", "\"", false, false);
                            macro.append(')');
                            this.pushMacro(macro);
                            break block1;
                        }
                        case 39: {
                            CharBuffer macro = new CharBuffer();
                            macro.append('(');
                            this.interpolate(macro, 39, null, "'", "'", false, false);
                            macro.append(')');
                            this.pushMacro(macro);
                            break block1;
                        }
                        case 64: {
                            ch2 = this.read();
                            if (ch2 < 0) {
                                throw this.error(L.l("unexpected end of file"));
                            }
                            switch (ch2) {
                                case 123: {
                                    ch2 = 125;
                                    break;
                                }
                                case 60: {
                                    ch2 = 62;
                                    break;
                                }
                                case 40: {
                                    ch2 = 41;
                                    break;
                                }
                                case 91: {
                                    ch2 = 93;
                                }
                            }
                            return this.lexString((char)ch2, null, true, false);
                        }
                        case 60: {
                            ch2 = this.read();
                            if (ch2 != 60) {
                                throw this.error(L.l("illegal character at `@'"));
                            }
                            if (!this.scanMultiline()) continue block30;
                            return 257;
                        }
                        case 47: {
                            CharBuffer macro = new CharBuffer();
                            macro.append("new RegExp(");
                            this.interpolate(macro, 47, null, "@@/", "/", true, false);
                            macro.append(",");
                            macro.append(this.readRegexpFlags());
                            macro.append(")");
                            this.pushMacro(macro);
                            break block1;
                        }
                        default: {
                            return this.lexOp(64);
                        }
                    }
                }
                case 37: {
                    int ch2 = this.read();
                    this.regexpOk = true;
                    this.ungetc(ch2);
                    return this.lexOp(ch);
                }
                case 35: {
                    int ch2 = this.read();
                    if (this.line == 1 && this.lineCh == 2 && ch2 == 33) {
                        while (ch2 > 0 && ch2 != 10) {
                            ch2 = this.read();
                        }
                        this.ungetc(ch2);
                        break;
                    }
                    if (ch2 >= 97 && ch2 <= 122 || ch2 >= 65 && ch2 <= 90) {
                        this.temp.clear();
                        while (ch2 >= 97 && ch2 <= 122 || ch2 >= 65 && ch2 <= 90) {
                            this.temp.append((char)ch2);
                            ch2 = this.read();
                        }
                        if (this.temp.toString().equals("line")) {
                            this.scanLine(ch2);
                            break;
                        }
                        if (this.temp.toString().equals("file")) {
                            this.scanFile(ch2);
                            break;
                        }
                        throw this.error(L.l("expected pragma at `{0}'", this.temp));
                    }
                    if (ch2 < 48 || ch2 > 57) {
                        throw this.error(L.l("expected digit at {0}", this.badChar(ch2)));
                    }
                    this.intValue = 0;
                    while (ch2 >= 48 && ch2 <= 57) {
                        this.intValue = 10 * this.intValue + ch2 - 48;
                        ch2 = this.read();
                    }
                    if (ch2 == 61) {
                        return 261;
                    }
                    if (ch2 == 35) {
                        return 262;
                    }
                    throw this.error(L.l("expected sharp variable at {0}", this.badChar(ch)));
                }
                default: {
                    if (ch >= 97 && ch <= 122 || ch >= 65 && ch <= 90 || ch == 95 || ch == 36) {
                        this.regexpOk = false;
                        return this.lexId(ch);
                    }
                    throw this.error(L.l("illegal character at {0}", this.badChar(ch)));
                }
            }
        }
    }

    CharBuffer getText() {
        return this.text;
    }

    boolean isEof() {
        return this.isEof;
    }

    String getToken() {
        return this.lineText.substring(this.beginLineCh, this.lineCh);
    }

    ESId getId() {
        return this.id;
    }

    boolean seenLineFeed() {
        return this.hasLf;
    }

    ESParseException error(String text) {
        return new ESParseException(this.filename, this.beginLine, this.beginLineCh, this.line, this.lineCh, text);
    }

    private String hex(int value) {
        CharBuffer cb = new CharBuffer();
        for (int b = 3; b >= 0; --b) {
            int v = value >> 4 * b & 0xF;
            if (v < 10) {
                cb.append((char)(v + 48));
                continue;
            }
            cb.append((char)(v - 10 + 97));
        }
        return cb.toString();
    }

    private String badChar(int ch) {
        if (ch >= 32 && ch <= 127) {
            return "`" + (char)ch + "'";
        }
        if (ch == 10) {
            return L.l("end of line");
        }
        if (ch == -1) {
            return L.l("end of file");
        }
        return "`" + (char)ch + "' (\\u" + this.hex(ch) + ")";
    }

    String getFilename() {
        LineMap.Line map;
        if (this.lineMap != null && (map = this.lineMap.getLine(this.line)) != null) {
            return map.getSourceFilename();
        }
        return this.filename;
    }

    long getLastModified() {
        if (this.is.getPath() == null) {
            return 0L;
        }
        return this.is.getPath().getLastModified();
    }

    int getLine() {
        LineMap.Line map;
        if (this.lineMap != null && (map = this.lineMap.getLine(this.line)) != null) {
            return map.getSourceLine(this.line);
        }
        return this.line;
    }

    String getLastFilename() {
        LineMap.Line map;
        if (this.lineMap != null && (map = this.lineMap.getLine(this.lastLine)) != null) {
            return map.getSourceFilename();
        }
        return this.lastFilename;
    }

    int getLastLine() {
        LineMap.Line map;
        if (this.lineMap != null && (map = this.lineMap.getLine(this.lastLine)) != null) {
            return map.getSourceLine(this.lastLine);
        }
        return this.lastLine;
    }

    private void pushMacro(CharBuffer cb) throws ESParseException {
        if (this.peek >= 0) {
            cb.append((char)this.read());
        }
        if (this.peek >= 0) {
            cb.append((char)this.read());
        }
        if (this.macroText != null) {
            this.macros.add(new Macro(this.macroText, this.macroIndex, this.macroOldLine));
        }
        this.macroText = cb;
        this.macroIndex = 0;
        this.macroOldLine = this.line;
    }

    private void newline() {
        ++this.line;
        this.lineCh = 0;
        this.lineText.clear();
    }

    private int lexFloat(double value, int ch) throws ESParseException {
        int expt = 0;
        while (ch >= 48 && ch <= 57) {
            value = 10.0 * value + (double)ch - 48.0;
            --expt;
            ch = this.read();
        }
        if (ch == 101 || ch == 69) {
            ch = this.read();
            int sign = 1;
            if (ch == 45) {
                sign = -1;
                ch = this.read();
            } else if (ch == 43) {
                ch = this.read();
            }
            if (ch < 48 || ch > 57) {
                throw this.error(L.l("expected exponent at {0}", this.badChar(ch)));
            }
            int userExpt = 0;
            while (ch >= 48 && ch <= 57) {
                userExpt = 10 * userExpt + ch - 48;
                ch = this.read();
            }
            expt += sign * userExpt;
        }
        this.ungetc(ch);
        this.literal = expt >= 0 ? ESNumber.create(value * Math.pow(10.0, expt)) : ESNumber.create(value / Math.pow(10.0, -expt));
        return 257;
    }

    private int lexNumber(int ch) throws ESParseException {
        int radix = 10;
        double value = 0.0;
        boolean hasChar = true;
        if (ch == 48) {
            ch = this.read();
            if (ch >= 48 && ch <= 57) {
                radix = 8;
            } else if (ch == 120 || ch == 88) {
                hasChar = false;
                radix = 16;
                ch = this.read();
            }
        }
        while (ch >= 0) {
            if (ch >= 48 && ch <= 57) {
                value = (double)radix * value + (double)ch - 48.0;
                hasChar = true;
                if (radix == 8 && ch >= 56) {
                    throw this.error(L.l("expected octal digit at {0}", this.badChar(ch)));
                }
            } else if (radix == 16 && ch >= 97 && ch <= 102) {
                hasChar = true;
                value = (double)radix * value + (double)ch - 97.0 + 10.0;
            } else {
                if (radix != 16 || ch < 65 || ch > 70) break;
                hasChar = true;
                value = (double)radix * value + (double)ch - 65.0 + 10.0;
            }
            ch = this.read();
        }
        if (!hasChar) {
            throw this.error(L.l("expected hex digit at {0}", this.badChar(ch)));
        }
        if (radix == 10 && ch == 46) {
            ch = this.read();
            if (ch >= 48 && ch <= 57) {
                return this.lexFloat(value, ch);
            }
            this.ungetc(ch);
            this.literal = ESNumber.create(value);
            return 257;
        }
        if (radix == 10 && (ch == 101 || ch == 69)) {
            return this.lexFloat(value, ch);
        }
        this.ungetc(ch);
        this.literal = ESNumber.create(value);
        return 257;
    }

    private int hexDigit(int ch) throws ESParseException {
        if (ch >= 48 && ch <= 57) {
            return ch - 48;
        }
        if (ch >= 97 && ch <= 102) {
            return ch - 97 + 10;
        }
        if (ch >= 65 && ch <= 70) {
            return ch - 65 + 10;
        }
        throw this.error(L.l("expected hex digit at {0}", this.badChar(ch)));
    }

    private int lexString(char endCh, String endTail, boolean isRegexp, boolean isMultiline) throws ESParseException {
        this.text.setLength(0);
        int ch = this.read();
        while (ch >= 0) {
            if (ch == 10) {
                if (!isMultiline) {
                    if (isRegexp) {
                        throw this.error(L.l("unexpected end of line in regular expression"));
                    }
                    throw this.error(L.l("unexpected end of line in string"));
                }
                this.newline();
            }
            if (ch == endCh) {
                if (endTail == null) {
                    this.literal = ESString.create(this.text.toString());
                    return 257;
                }
                if (this.text.endsWith(endTail)) {
                    if (this.text.length() == endTail.length()) {
                        this.literal = ESString.create("");
                        return 257;
                    }
                    char tailCh = this.text.charAt(this.text.length() - endTail.length() - 1);
                    if (tailCh == '\n') {
                        this.text.setLength(this.text.length() - endTail.length() - 1);
                        this.literal = ESString.create(this.text.toString());
                        return 257;
                    }
                }
            }
            if (ch == 92) {
                ch = this.read();
                switch (ch) {
                    case -1: {
                        if (isRegexp) {
                            throw this.error(L.l("unexpected end of file in regular expression"));
                        }
                        throw this.error(L.l("unexpected end of file in string"));
                    }
                    case 10: {
                        if (isRegexp) {
                            throw this.error(L.l("unexpected end of line in regular expression"));
                        }
                        throw this.error(L.l("unexpected end of line in string"));
                    }
                    case 98: {
                        if (isRegexp) {
                            this.text.append("\\b");
                            break;
                        }
                        this.text.append('\b');
                        break;
                    }
                    case 101: {
                        this.text.append('\u001b');
                        break;
                    }
                    case 102: {
                        this.text.append('\f');
                        break;
                    }
                    case 110: {
                        this.text.append('\n');
                        break;
                    }
                    case 114: {
                        this.text.append('\r');
                        break;
                    }
                    case 116: {
                        this.text.append('\t');
                        break;
                    }
                    case 118: {
                        this.text.append('\u000b');
                        break;
                    }
                    case 99: {
                        ch = this.read();
                        if (ch >= 97 && ch <= 122) {
                            this.text.append((char)(ch - 97 + 1));
                            break;
                        }
                        if (ch >= 65 && ch <= 90) {
                            this.text.append((char)(ch - 65 + 1));
                            break;
                        }
                        if (ch - 64 >= 0 && ch - 64 < 32) {
                            this.text.append((char)(ch - 64));
                            break;
                        }
                        throw this.error(L.l("expected control character at {0}", this.badChar(ch)));
                    }
                    case 111: {
                        int value = 0;
                        while ((ch = this.read()) >= 48 && ch <= 56) {
                            value = 8 * value + ch - 48;
                        }
                        this.ungetc(ch);
                        this.text.append((char)value);
                        break;
                    }
                    case 120: {
                        int value = 16 * this.hexDigit(this.read());
                        this.text.append((char)(value += this.hexDigit(this.read())));
                        break;
                    }
                    case 117: {
                        int value = 4096 * this.hexDigit(this.read());
                        value += 256 * this.hexDigit(this.read());
                        value += 16 * this.hexDigit(this.read());
                        this.text.append((char)(value += this.hexDigit(this.read())));
                        break;
                    }
                    case 48: 
                    case 49: 
                    case 50: 
                    case 51: 
                    case 52: 
                    case 53: 
                    case 54: 
                    case 55: {
                        int value = ch - 48;
                        if (ch != 48 && isRegexp) {
                            this.text.append('\\');
                            this.text.append((char)ch);
                            break;
                        }
                        ch = this.read();
                        if (ch >= 48 && ch <= 55) {
                            if ((value = 8 * value + ch - 48) < 32) {
                                ch = this.read();
                                if (ch >= 48 && ch <= 55) {
                                    value = 8 * value + ch - 48;
                                } else {
                                    this.ungetc(ch);
                                }
                            }
                        } else {
                            this.ungetc(ch);
                        }
                        this.text.append((char)value);
                        break;
                    }
                    default: {
                        if (isRegexp) {
                            this.text.append('\\');
                        }
                        this.text.append((char)ch);
                        break;
                    }
                }
            } else {
                this.text.append((char)ch);
            }
            ch = this.read();
        }
        if (ch == -1) {
            if (isRegexp) {
                throw this.error(L.l("unexpected end of file in regular expression"));
            }
            throw this.error(L.l("unexpected end of file in string"));
        }
        this.literal = ESString.create(this.text.toString());
        return 257;
    }

    private void scanMacroStatement(CharBuffer macro, int end, boolean isRegexp, boolean multiline) throws ESParseException {
        int ch;
        while ((ch = this.read()) >= 0 && ch != end) {
            macro.append((char)ch);
            block0 : switch (ch) {
                case 92: {
                    ch = this.read();
                    macro.append((char)ch);
                    break;
                }
                case 34: 
                case 39: {
                    int testch = ch;
                    while ((ch = this.read()) >= 0) {
                        if (ch == 92) {
                            macro.append((char)ch);
                            ch = this.read();
                        } else {
                            if (ch == testch) {
                                macro.append((char)ch);
                                break block0;
                            }
                            if (ch == 10) {
                                if (!multiline) {
                                    throw this.error("unexpected end of line in " + (isRegexp ? "regular expression" : "string"));
                                }
                                this.newline();
                            }
                        }
                        macro.append((char)ch);
                    }
                    break;
                }
                case 40: {
                    this.scanMacroStatement(macro, 41, isRegexp, multiline);
                    macro.append(')');
                    break;
                }
                case 123: {
                    this.scanMacroStatement(macro, 125, isRegexp, multiline);
                    macro.append('}');
                    break;
                }
                case 10: {
                    if (!multiline) {
                        throw this.error("unexpected end of line in " + (isRegexp ? "regular expression" : "string"));
                    }
                    this.newline();
                    break;
                }
            }
        }
    }

    private void interpolate(CharBuffer macro, int tail, String matchText, String beginStr, String endStr, boolean isRegexp, boolean multiline) throws ESParseException {
        int ch = this.read();
        macro.append(beginStr);
        int start = macro.length();
        block4: while (ch >= 0) {
            switch (ch) {
                case 92: {
                    macro.append((char)ch);
                    ch = this.read();
                    if (ch == -1) break;
                    macro.append((char)ch);
                    break;
                }
                case 36: {
                    ch = this.read();
                    if (ch == -1) break;
                    if (ch >= 97 && ch <= 122 || ch >= 65 && ch <= 90 || ch == 95 || ch == 36) {
                        macro.append(endStr);
                        macro.append("+(");
                        macro.append((char)ch);
                        while ((ch = this.read()) >= 0 && ch >= 97 && ch <= 122 || ch >= 65 && ch <= 90 || ch >= 48 && ch <= 57 || ch == 95 || ch == 36) {
                            macro.append((char)ch);
                        }
                        this.ungetc(ch);
                        macro.append(")+");
                        macro.append(beginStr);
                        break;
                    }
                    if (ch == 123) {
                        macro.append(endStr);
                        macro.append("+(");
                        this.scanMacroStatement(macro, 125, isRegexp, multiline);
                        macro.append(")+");
                        macro.append(beginStr);
                        break;
                    }
                    if (ch == 40) {
                        macro.append(endStr);
                        macro.append("+(");
                        this.scanMacroStatement(macro, 41, isRegexp, multiline);
                        macro.append(")+");
                        macro.append(beginStr);
                        break;
                    }
                    this.ungetc(ch);
                    macro.append('$');
                    break;
                }
                default: {
                    if (ch == 10) {
                        this.newline();
                        if (!multiline) {
                            throw this.error("unexpected end of line in " + (isRegexp ? "regular expression" : "string"));
                        }
                    }
                    if (ch == tail) {
                        if (matchText == null) break block4;
                        if (macro.endsWith(matchText)) {
                            if (macro.length() - start == matchText.length()) {
                                macro.setLength(start);
                                break block4;
                            }
                            if (macro.charAt(macro.length() - matchText.length() - 1) == '\n') {
                                macro.setLength(macro.length() - matchText.length() - 1);
                                break block4;
                            }
                        }
                    }
                    macro.append((char)ch);
                }
            }
            ch = this.read();
        }
        macro.append(endStr);
    }

    private boolean scanMultiline() throws ESParseException {
        CharBuffer end = new CharBuffer();
        boolean interpolate = true;
        boolean endNewline = true;
        int ch = this.read();
        if (ch >= 97 && ch <= 122 || ch >= 65 && ch <= 90 || ch == 95 || ch == 36) {
            while (ch >= 0 && ch >= 97 && ch <= 122 || ch >= 65 && ch <= 90 || ch == 95 || ch == 36 || ch >= 48 && ch <= 57) {
                end.append((char)ch);
                ch = this.read();
            }
        } else if (ch == 39) {
            interpolate = false;
            ch = this.read();
            while (ch >= 0 && ch != 39 && ch != 10) {
                end.append((char)ch);
                ch = this.read();
            }
            if (ch != 39) {
                throw this.error(L.l("multiline escape error at {0}", this.badChar(ch)));
            }
            ch = this.read();
        } else if (ch == 96) {
            interpolate = false;
            ch = this.read();
            while (ch >= 0 && ch != 96 && ch != 10) {
                end.append((char)ch);
                ch = this.read();
            }
            if (ch != 96) {
                throw this.error(L.l("multiline escape error at {0}", this.badChar(ch)));
            }
            endNewline = false;
        } else if (ch == 34) {
            ch = this.read();
            while (ch >= 0 && ch != 34 && ch != 10) {
                end.append((char)ch);
                ch = this.read();
            }
            if (ch != 34) {
                throw this.error(L.l("multiline escape error at {0}", this.badChar(ch)));
            }
            ch = this.read();
        }
        int oldLine = this.line;
        CharBuffer lineTail = null;
        if (endNewline) {
            lineTail = new CharBuffer();
            while (ch >= 0 && ch != 10) {
                lineTail.append((char)ch);
                ch = this.read();
            }
            if (ch == 13) {
                lineTail.append((char)ch);
                ch = this.read();
            }
            if (ch == 10) {
                this.newline();
                lineTail.append((char)ch);
            }
        }
        CharBuffer macro = null;
        String endString = end.toString();
        if (interpolate) {
            macro = new CharBuffer();
            macro.append('(');
            this.interpolate(macro, 10, endString, "@<<`" + endString + "`", "\n" + endString + '\n', false, true);
            macro.append("+'\\n')");
        } else if (endNewline) {
            this.lexString('\n', endString, false, true);
            this.text.append('\n');
            this.literal = ESString.create(this.text);
        } else {
            this.lexString('\n', endString, false, true);
            this.line -= 2;
        }
        if (endNewline) {
            this.pushMacro(lineTail);
            this.line = oldLine;
        }
        if (interpolate) {
            this.pushMacro(macro);
            ++this.line;
            return false;
        }
        return true;
    }

    private int readRegexpFlags() throws ESParseException {
        int ch;
        block7: while (true) {
            ch = this.read();
            switch (ch) {
                case 120: {
                    this._flags |= 4;
                    continue block7;
                }
                case 105: {
                    this._flags |= 2;
                    continue block7;
                }
                case 103: {
                    continue block7;
                }
                case 109: {
                    this._flags |= 8;
                    continue block7;
                }
                case 115: {
                    continue block7;
                }
            }
            break;
        }
        this.ungetc(ch);
        return this._flags;
    }

    private int lexId(int ch) throws ESParseException {
        this.text.setLength(0);
        this.text.append((char)ch);
        while ((ch = this.read()) >= 97 && ch <= 122 || ch >= 65 && ch <= 90 || ch == 95 || ch == 36 || ch >= 48 && ch <= 57) {
            this.text.append((char)ch);
        }
        this.ungetc(ch);
        Integer value = (Integer)reserved.get(this.text);
        if (value == null) {
            this.id = ESId.intern(this.text.toString());
            return 259;
        }
        int intValue = value;
        switch (intValue) {
            case 301: {
                this.literal = ESBase.esNull;
                return 257;
            }
            case 302: {
                this.literal = ESBase.esUndefined;
                return 257;
            }
            case 304: {
                this.literal = ESBoolean.create(false);
                return 257;
            }
            case 303: {
                this.literal = ESBoolean.create(true);
                return 257;
            }
        }
        return value;
    }

    private int lexOp(int ch) throws ESParseException {
        this.text.setLength(0);
        this.text.append((char)ch);
        block3: while ((ch = this.read()) >= 0) {
            switch (ch) {
                case 33: 
                case 37: 
                case 38: 
                case 42: 
                case 43: 
                case 45: 
                case 46: 
                case 47: 
                case 60: 
                case 61: 
                case 62: 
                case 63: 
                case 94: 
                case 124: {
                    this.text.append((char)ch);
                    this.op = (Op)ops.get(this.text);
                    if (this.op != null) continue block3;
                    this.text.setLength(this.text.length() - 1);
                    this.ungetc(ch);
                    break block3;
                }
                default: {
                    this.ungetc(ch);
                    break block3;
                }
            }
        }
        this.op = (Op)ops.get(this.text);
        if (this.op == null) {
            throw this.error(L.l("expected operator at `{0}'", this.text.toString()));
        }
        return this.op.lexeme;
    }

    int getOp() {
        return this.op.op;
    }

    int getPrecedence() {
        return this.op.precedence;
    }

    boolean isRightAssoc() {
        return this.op.isRightAssoc;
    }

    ESBase getLiteral() {
        return this.literal;
    }

    int getFlags() {
        return this._flags;
    }

    private void scanLine(int ch) throws ESParseException {
        while (ch == 32 || ch == 9) {
            ch = this.read();
        }
        if (ch < 48 || ch > 57) {
            throw this.error(L.l("expected digit at {0}", this.badChar(ch)));
        }
        this.line = 0;
        while (ch >= 48 && ch <= 57) {
            this.line = 10 * this.line + ch - 48;
            ch = this.read();
        }
        while (ch == 32 || ch == 9) {
            ch = this.read();
        }
        if (ch != 35) {
            throw this.error(L.l("expected `#' at {0}", this.badChar(ch)));
        }
    }

    private void scanFile(int ch) throws ESParseException {
        while (ch == 32 || ch == 9) {
            ch = this.read();
        }
        this.temp.clear();
        while (ch >= 0 && ch != 32 && ch != 9 && ch != 35) {
            this.temp.append((char)ch);
            ch = this.read();
        }
        if (this.temp.length() == 0) {
            throw this.error(L.l("expected filename at {0}", this.badChar(ch)));
        }
        this.filename = this.temp.toString();
        while (ch == 32 || ch == 9) {
            ch = this.read();
        }
        this.line = 0;
        while (ch >= 48 && ch <= 57) {
            this.line = 10 * this.line + ch - 48;
            ch = this.read();
        }
        if (this.line == 0) {
            this.line = 1;
        }
        while (ch == 32 || ch == 9) {
            ch = this.read();
        }
        if (ch != 35) {
            throw this.error(L.l("expected `#' at {0}", this.badChar(ch)));
        }
    }

    private int read() throws ESParseException {
        ++this.lineCh;
        if (this.peek >= 0) {
            int ch = this.peek;
            this.peek = this.peek2;
            this.peek2 = -1;
            return ch;
        }
        while (this.macroText != null) {
            if (this.macroIndex < this.macroText.length()) {
                char ch = this.macroText.charAt(this.macroIndex++);
                this.lineText.append(ch);
                return ch;
            }
            this.line = this.macroOldLine;
            if (this.macros.size() == 0) {
                this.macroText = null;
                continue;
            }
            Macro macro = (Macro)this.macros.remove(this.macros.size() - 1);
            this.macroText = macro.text;
            this.macroIndex = macro.index;
            this.macroOldLine = macro.oldLine;
        }
        try {
            int ch = this.is.readChar();
            if (ch == 13) {
                ch = this.is.readChar();
                if (ch != 10) {
                    this.peek = ch == 13 ? 10 : ch;
                }
                ch = 10;
            }
            this.lineText.append((char)ch);
            return ch;
        }
        catch (CharConversionException e1) {
            throw this.error(L.l("expected {0} encoded character", this.is.getEncoding()));
        }
        catch (IOException e1) {
            throw new ESParseException(e1);
        }
    }

    private void ungetc(int ch) {
        this.peek2 = this.peek;
        this.peek = ch;
        if (this.lineCh > 0) {
            --this.lineCh;
        }
    }

    class Macro {
        CharBuffer text;
        int index;
        int oldLine;

        void clear() {
            this.text.clear();
            this.index = 0;
        }

        Macro(CharBuffer cb, int index, int oldLine) {
            this.text = cb;
            this.index = index;
            this.oldLine = oldLine;
        }
    }

    static class Op {
        int op;
        int lexeme;
        int precedence;
        boolean isRightAssoc;

        Op(int op, int lexeme, int precedence, boolean isRightAssoc) {
            this.op = op;
            this.lexeme = lexeme;
            this.precedence = precedence;
            this.isRightAssoc = isRightAssoc;
        }
    }
}

