/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.eswrap.com.caucho.vfs;

import com.caucho.es.Call;
import com.caucho.vfs.Path;
import com.caucho.vfs.ReadStream;
import com.caucho.vfs.ReadWritePair;
import com.caucho.vfs.WriteStream;
import java.io.IOException;
import java.io.InputStream;

public class WriteStreamEcmaWrap {
    public static void writeByte(WriteStream os, int ch) throws Throwable {
        os.write(ch);
    }

    public static void write(WriteStream os, Call call, int length) throws Throwable {
        for (int i = 0; i < length; ++i) {
            String string = call.getArgString(i, length);
            if (string == null) {
                string = "null";
            }
            os.print(string);
        }
    }

    public static void writeln(WriteStream os, Call call, int length) throws Throwable {
        for (int i = 0; i < length; ++i) {
            String string = call.getArgString(i, length);
            if (string == null) {
                string = "null";
            }
            if (i + 1 == length) {
                os.println(string);
                continue;
            }
            os.print(string);
        }
        if (length == 0) {
            os.println();
        }
    }

    public static void printf(WriteStream os, Call eval, int length) throws Throwable {
        if (length == 0) {
            return;
        }
        String result = eval.printf(length);
        os.print(result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeFile(WriteStream os, Path path) throws IOException {
        ReadStream stream = path.openRead();
        try {
            os.writeStream(stream);
        }
        finally {
            stream.close();
        }
    }

    public static void writeStream(WriteStream os, Call call, int length) throws Throwable {
        if (length < 1) {
            return;
        }
        char[] buf = new char[256];
        Object obj = call.getArgObject(0, length);
        if (obj instanceof ReadStream) {
            ReadStream is = (ReadStream)obj;
            os.writeStream(is);
        } else if (obj instanceof ReadWritePair) {
            os.writeStream(((ReadWritePair)obj).getReadStream());
        } else if (obj instanceof InputStream) {
            os.writeStream((InputStream)obj);
        } else {
            throw new IllegalArgumentException("expected stream at " + obj.getClass().getName());
        }
    }
}

