/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.eswrap.java.sql;

import com.caucho.es.Call;
import com.caucho.es.ESBase;
import com.caucho.es.Global;
import com.caucho.log.Log;
import com.caucho.util.NullIterator;
import com.rc.retroweaver.runtime.ClassLiteral;
import java.io.InputStream;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Iterator;
import java.util.logging.Logger;

public class ResultSetEcmaWrap {
    private static final Logger log = Log.open(ClassLiteral.getClass((String)"java/sql/ResultSet"));

    public static String getString(ResultSet rs, ESBase col) throws Throwable {
        ESBase key = col.toPrimitive();
        if (key.isString()) {
            return rs.getString(key.toString());
        }
        return rs.getString((int)key.toNum());
    }

    public static boolean getBoolean(ResultSet rs, ESBase col) throws Throwable {
        ESBase key = col.toPrimitive();
        if (key.isString()) {
            return rs.getBoolean(key.toString());
        }
        return rs.getBoolean((int)key.toNum());
    }

    public static byte getByte(ResultSet rs, ESBase col) throws Throwable {
        ESBase key = col.toPrimitive();
        if (key.isString()) {
            return rs.getByte(key.toString());
        }
        return rs.getByte((int)key.toNum());
    }

    public static short getShort(ResultSet rs, ESBase col) throws Throwable {
        ESBase key = col.toPrimitive();
        if (key.isString()) {
            return rs.getShort(key.toString());
        }
        return rs.getShort((int)key.toNum());
    }

    public static int getInt(ResultSet rs, ESBase col) throws Throwable {
        ESBase key = col.toPrimitive();
        if (key.isString()) {
            return rs.getInt(key.toString());
        }
        return rs.getInt((int)key.toNum());
    }

    public static long getLong(ResultSet rs, ESBase col) throws Throwable {
        ESBase key = col.toPrimitive();
        if (key.isString()) {
            return rs.getLong(key.toString());
        }
        return rs.getLong((int)key.toNum());
    }

    public static float getFloat(ResultSet rs, ESBase col) throws Throwable {
        ESBase key = col.toPrimitive();
        if (key.isString()) {
            return rs.getFloat(key.toString());
        }
        return rs.getFloat((int)key.toNum());
    }

    public static double getDouble(ResultSet rs, ESBase col) throws Throwable {
        ESBase key = col.toPrimitive();
        if (key.isString()) {
            return rs.getDouble(key.toString());
        }
        return rs.getDouble((int)key.toNum());
    }

    public static BigDecimal getBigDecimal(ResultSet rs, ESBase col, int i) throws Throwable {
        ESBase key = col.toPrimitive();
        if (key.isString()) {
            return rs.getBigDecimal(key.toString(), i);
        }
        return rs.getBigDecimal((int)key.toNum(), i);
    }

    public static byte[] getBytes(ResultSet rs, ESBase col) throws Throwable {
        ESBase key = col.toPrimitive();
        if (key.isString()) {
            return rs.getBytes(key.toString());
        }
        return rs.getBytes((int)key.toNum());
    }

    public static ESBase getDate(ResultSet rs, Call call, int len) throws Throwable {
        ESBase col = call.getArg(0, len);
        ESBase key = col.toPrimitive();
        Date date = key.isString() ? rs.getDate(key.toString()) : rs.getDate((int)key.toNum());
        return call.createDate(date.getTime());
    }

    public static ESBase getTime(ResultSet rs, Call call, int len) throws Throwable {
        ESBase col = call.getArg(0, len);
        ESBase key = col.toPrimitive();
        Time date = key.isString() ? rs.getTime(key.toString()) : rs.getTime((int)key.toNum());
        return call.createDate(date.getTime());
    }

    public static ESBase getTimestamp(ResultSet rs, Call call, int len) throws Throwable {
        ESBase col = call.getArg(0, len);
        ESBase key = col.toPrimitive();
        Timestamp date = key.isString() ? rs.getTimestamp(key.toString()) : rs.getTimestamp((int)key.toNum());
        return call.createDate(((java.util.Date)date).getTime());
    }

    public static InputStream getAsciiStream(ResultSet rs, ESBase col) throws Throwable {
        ESBase key = col.toPrimitive();
        if (key.isString()) {
            return rs.getAsciiStream(key.toString());
        }
        return rs.getAsciiStream((int)key.toNum());
    }

    public static InputStream getUnicodeStream(ResultSet rs, ESBase col) throws Throwable {
        ESBase key = col.toPrimitive();
        if (key.isString()) {
            return rs.getUnicodeStream(key.toString());
        }
        return rs.getUnicodeStream((int)key.toNum());
    }

    public static InputStream getBinaryStream(ResultSet rs, ESBase col) throws Throwable {
        ESBase key = col.toPrimitive();
        if (key.isString()) {
            return rs.getBinaryStream(key.toString());
        }
        return rs.getBinaryStream((int)key.toNum());
    }

    public static Object getObject(ResultSet rs, ESBase col) throws Throwable {
        ESBase key = col.toPrimitive();
        if (key.isString()) {
            return rs.getObject(key.toString());
        }
        return rs.getObject((int)key.toNum());
    }

    public static String getByname(ResultSet rs, String string) throws SQLException {
        return rs.getString(string);
    }

    public static Object get(ResultSet rs, String key) throws Throwable {
        return ResultSetEcmaWrap.get(rs, rs.findColumn(key));
    }

    public static Object get(ResultSet rs, int index) throws Throwable {
        ResultSetMetaData md = rs.getMetaData();
        switch (md.getColumnType(index)) {
            case -7: {
                return new Boolean(rs.getInt(index) == 1);
            }
            case -6: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                return new Double(rs.getDouble(index));
            }
            case 1: 
            case 12: {
                return rs.getString(index);
            }
            case 0: {
                return null;
            }
            case -5: 
            case 2: 
            case 3: {
                return rs.getString(index);
            }
            case -1: {
                return rs.getAsciiStream(index);
            }
            case 91: {
                return rs.getDate(index);
            }
            case 92: {
                return rs.getTime(index);
            }
            case 93: {
                return rs.getTimestamp(index);
            }
            case -3: 
            case -2: {
                return rs.getBytes(index);
            }
            case -4: {
                return rs.getBinaryStream(index);
            }
        }
        return rs.getString(index);
    }

    public static Object toObject(ResultSet rs, Call call, int length) throws Throwable {
        ResultSetMetaData md = rs.getMetaData();
        Global global = Global.getGlobalProto();
        ESBase obj = length > 0 ? call.getArg(0, length) : global.createObject();
        int nColumns = md.getColumnCount();
        for (int i = 0; i < nColumns; ++i) {
            String name = md.getColumnName(i + 1);
            Object value = ResultSetEcmaWrap.get(rs, i + 1);
            obj.setProperty(name, Global.wrap(value));
        }
        return obj;
    }

    public static Iterator keys(ResultSet rs) {
        try {
            return new ResultSetIterator(rs);
        }
        catch (Exception e) {
            return NullIterator.create();
        }
    }

    private ResultSetEcmaWrap() {
    }

    static class ResultSetIterator
    implements Iterator {
        ResultSet rs;
        ResultSetMetaData md;
        int nColumns;
        int i;

        public boolean hasNext() {
            return this.i < this.nColumns;
        }

        public Object next() {
            try {
                return this.md.getColumnName(++this.i);
            }
            catch (SQLException e) {
                return null;
            }
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }

        ResultSetIterator(ResultSet rs) throws SQLException {
            this.rs = rs;
            this.md = rs.getMetaData();
            this.nColumns = this.md.getColumnCount();
        }
    }
}

