/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.filters;

import com.caucho.config.types.Period;
import com.caucho.util.Alarm;
import com.caucho.util.RegistryNode;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletResponse;

public class AnonymousExpiresFilter
implements Filter {
    private long _cacheTime = 2000L;

    public void setCacheTime(Period period) {
        this._cacheTime = period.getPeriod();
    }

    public void init(FilterConfig config) throws ServletException {
        String time = config.getInitParameter("cache-time");
        if (time != null) {
            try {
                this._cacheTime = RegistryNode.calculatePeriod(time);
            }
            catch (Exception e) {
                throw new ServletException(e);
            }
        }
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain nextFilter) throws ServletException, IOException {
        if (this._cacheTime > 0L) {
            HttpServletResponse res = (HttpServletResponse)response;
            res.addHeader("Cache-Control", "x-anonymous");
            res.setDateHeader("Expires", Alarm.getCurrentTime() + this._cacheTime);
        }
        nextFilter.doFilter(request, response);
    }

    public void destroy() {
    }
}

