/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.filters;

import com.caucho.filters.CauchoResponseWrapper;
import com.caucho.loader.DynamicClassLoader;
import com.caucho.log.Log;
import com.caucho.server.connection.CauchoRequest;
import com.caucho.server.connection.RequestAdapter;
import com.caucho.util.CompileException;
import com.caucho.util.L10N;
import com.caucho.vfs.MergePath;
import com.caucho.vfs.Path;
import com.caucho.vfs.ReadStream;
import com.caucho.vfs.TempStream;
import com.caucho.vfs.Vfs;
import com.caucho.vfs.WriteStream;
import com.caucho.xml.Xml;
import com.caucho.xml.XmlUtil;
import com.caucho.xpath.XPath;
import com.caucho.xpath.XPathException;
import com.caucho.xsl.AbstractStylesheetFactory;
import com.caucho.xsl.StyleScript;
import com.caucho.xsl.TransformerImpl;
import com.rc.retroweaver.runtime.ClassLiteral;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.w3c.dom.Document;
import org.w3c.dom.ProcessingInstruction;

public class XsltFilter
implements Filter {
    private static final L10N L = new L10N(ClassLiteral.getClass((String)"com/caucho/filters/XsltFilter"));
    private static final Logger log = Log.open(ClassLiteral.getClass((String)"com/caucho/filters/XsltFilter"));
    private String _mimeType = "x-application/xslt";
    private MergePath _stylePath;
    private ServletContext _application;
    private boolean _isConditional = true;

    public void setMimeType(String mimeType) {
        this._mimeType = mimeType;
    }

    public void setUnconditional(boolean isUnconditional) {
        this._isConditional = !isUnconditional;
    }

    public void init(FilterConfig config) throws ServletException {
        this._stylePath = new MergePath();
        this._stylePath.addMergePath(Vfs.lookup());
        DynamicClassLoader loader = (DynamicClassLoader)Thread.currentThread().getContextClassLoader();
        String resourcePath = loader.getResourcePathSpecificFirst();
        this._stylePath.addClassPath(resourcePath);
        this._application = config.getServletContext();
        if ("true".equals(config.getInitParameter("unconditional"))) {
            this._isConditional = false;
        }
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain nextFilter) throws ServletException, IOException {
        HttpServletRequest req = (HttpServletRequest)request;
        HttpServletResponse res = (HttpServletResponse)response;
        XsltResponse xsltResponse = new XsltResponse(req, res);
        nextFilter.doFilter(req, xsltResponse);
        xsltResponse.finish(req, res);
    }

    public void destroy() {
    }

    static class XsltTempStream
    extends OutputStream {
        private ServletResponse _response;
        private OutputStream _os;
        private TempStream _tempStream;

        XsltTempStream(ServletResponse response) {
            this._response = response;
        }

        void setChaining() {
            if (this._os != null) {
                throw new IllegalStateException(L.l("setContentType for XSLT chaining must be before any data."));
            }
            this._tempStream = new TempStream(null);
            this._tempStream.openWrite();
            this._os = new WriteStream(this._tempStream);
        }

        TempStream getTempStream() throws IOException {
            if (this._tempStream != null) {
                this._os.close();
                this._os = null;
            }
            return this._tempStream;
        }

        public void write(int ch) throws IOException {
            if (this._os == null) {
                this._os = this._response.getOutputStream();
            }
            this._os.write(ch);
        }

        public void write(byte[] buffer, int offset, int length) throws IOException {
            if (this._os == null) {
                this._os = this._response.getOutputStream();
            }
            this._os.write(buffer, offset, length);
        }

        public void flush() throws IOException {
            if (this._os == null) {
                this._os = this._response.getOutputStream();
            }
            this._os.flush();
        }
    }

    class XsltResponse
    extends CauchoResponseWrapper {
        private HttpServletRequest _request;
        private XsltTempStream _xsltStream;
        private String _chainingType;

        XsltResponse(HttpServletRequest request, HttpServletResponse response) {
            super(response);
            this._request = request;
        }

        public void setContentLength(int length) {
        }

        public void setContentType(String contentType) {
            super.setContentType(contentType);
            int p = contentType.indexOf(59);
            if (p > 0) {
                contentType = contentType.substring(0, p);
            }
            if (!XsltFilter.this._isConditional || contentType.equals("x-application/xslt") || contentType.equals("x-application/xsl") || contentType.equals("x-application/stylescript")) {
                this._chainingType = contentType;
                if (log.isLoggable(Level.FINER)) {
                    log.finer(L.l("'{0}' chaining xslt with {1}", (Object)this._request.getRequestURI(), contentType));
                }
                if (this._xsltStream == null) {
                    this._xsltStream = new XsltTempStream(this._response);
                }
                this._xsltStream.setChaining();
            }
        }

        protected OutputStream getStream() throws IOException {
            if (this._xsltStream == null) {
                this._xsltStream = new XsltTempStream(this._response);
            }
            return this._xsltStream;
        }

        public void flushBuffer() throws IOException {
            super.flushBuffer();
            if (this._stream != null) {
                this._stream.flush();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void finish(HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
            try {
                Path newPath;
                Thread thread;
                ClassLoader loader;
                URL url;
                this.flushBuffer();
                if (this._chainingType == null) {
                    return;
                }
                TempStream ts = this._xsltStream.getTempStream();
                Document doc = null;
                ReadStream is = ts.openRead(true);
                Path userPath = Vfs.lookup();
                if (req instanceof CauchoRequest) {
                    userPath.setUserPath(((CauchoRequest)req).getPageURI());
                } else {
                    userPath.setUserPath(req.getRequestURI());
                }
                is.setPath(userPath);
                try {
                    doc = new Xml().parseDocument(is);
                }
                finally {
                    is.close();
                }
                String href = (String)req.getAttribute("caucho.xsl.stylesheet");
                if (href == null) {
                    href = this.getStylesheetHref(doc);
                }
                if (href == null) {
                    href = "default.xsl";
                }
                Templates stylesheet = null;
                TransformerFactory factory = this._chainingType.equals("x-application/stylescript") ? new StyleScript() : TransformerFactory.newInstance();
                if (factory instanceof AbstractStylesheetFactory) {
                    ((AbstractStylesheetFactory)factory).setStylePath(XsltFilter.this._stylePath);
                }
                Path path = null;
                if (href.startsWith("/")) {
                    path = Vfs.getPwd().lookup(XsltFilter.this._application.getRealPath(href));
                } else {
                    String servletPath = RequestAdapter.getPageServletPath(req);
                    Path pwd = Vfs.getPwd();
                    pwd = pwd.lookup(XsltFilter.this._application.getRealPath(servletPath));
                    path = pwd.getParent().lookup(href);
                }
                if (!path.canRead() && (url = (loader = (thread = Thread.currentThread()).getContextClassLoader()).getResource(href)) != null && (newPath = Vfs.getPwd().lookup(url.toString())).canRead()) {
                    path = newPath;
                }
                StreamSource source = path.canRead() ? new StreamSource(path.getURL()) : new StreamSource(href);
                if (log.isLoggable(Level.FINE)) {
                    log.fine(L.l("'{0}' XSLT filter using stylesheet {1}", (Object)req.getRequestURI(), source.getSystemId()));
                }
                stylesheet = factory.newTemplates(source);
                Transformer transformer = null;
                transformer = stylesheet.newTransformer();
                TransformerImpl cauchoTransformer = null;
                if (transformer instanceof TransformerImpl) {
                    cauchoTransformer = (TransformerImpl)transformer;
                }
                String mediaType = transformer.getOutputProperty("media-type");
                String encoding = transformer.getOutputProperty("encoding");
                String method = transformer.getOutputProperty("method");
                if (encoding == null && method != null && method.equals("xml")) {
                    encoding = "UTF-8";
                }
                if (encoding != null) {
                    if (mediaType == null) {
                        mediaType = "text/html";
                    }
                    res.setContentType(mediaType + "; charset=" + encoding);
                } else if (mediaType != null) {
                    res.setContentType(mediaType);
                } else {
                    res.setContentType("text/html");
                }
                if (encoding == null) {
                    encoding = "ISO-8859-1";
                }
                transformer.setOutputProperty("encoding", encoding);
                ArrayList params = null;
                if (cauchoTransformer != null) {
                    params = (ArrayList)cauchoTransformer.getProperty("caucho.global.param");
                }
                for (int i = 0; params != null && i < params.size(); ++i) {
                    String param = (String)params.get(i);
                    transformer.setParameter(param, req.getParameter(param));
                }
                DOMSource domSource = new DOMSource(doc);
                domSource.setSystemId(userPath.getUserPath());
                StreamResult result = new StreamResult(res.getOutputStream());
                transformer.transform(domSource, result);
            }
            catch (IOException e) {
                throw e;
            }
            catch (Exception e) {
                if (e instanceof CompileException) {
                    throw new ServletException(e.getMessage(), e);
                }
                throw new ServletException(e.toString(), e);
            }
        }

        private String getStylesheetHref(Document doc) throws XPathException {
            ProcessingInstruction pi = null;
            pi = (ProcessingInstruction)XPath.find("//processing-instruction('xml-stylesheet')", doc);
            if (pi == null) {
                return null;
            }
            String value = pi.getNodeValue();
            return XmlUtil.getPIAttribute(value, "href");
        }
    }
}

