/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.hessian.io;

import com.caucho.hessian.io.AbstractHessianInput;
import com.caucho.hessian.io.ArrayDeserializer;
import com.caucho.hessian.io.ArraySerializer;
import com.caucho.hessian.io.BasicDeserializer;
import com.caucho.hessian.io.BasicSerializer;
import com.caucho.hessian.io.ClassDeserializer;
import com.caucho.hessian.io.ClassSerializer;
import com.caucho.hessian.io.CollectionDeserializer;
import com.caucho.hessian.io.CollectionSerializer;
import com.caucho.hessian.io.Deserializer;
import com.caucho.hessian.io.EnumerationDeserializer;
import com.caucho.hessian.io.EnumerationSerializer;
import com.caucho.hessian.io.HessianProtocolException;
import com.caucho.hessian.io.InputStreamSerializer;
import com.caucho.hessian.io.IteratorSerializer;
import com.caucho.hessian.io.JavaDeserializer;
import com.caucho.hessian.io.JavaSerializer;
import com.caucho.hessian.io.MapDeserializer;
import com.caucho.hessian.io.MapSerializer;
import com.caucho.hessian.io.RemoteSerializer;
import com.caucho.hessian.io.Serializer;
import com.caucho.hessian.io.SqlDateDeserializer;
import com.caucho.hessian.io.SqlDateSerializer;
import com.caucho.hessian.io.StackTraceElementDeserializer;
import com.caucho.hessian.io.StringValueDeserializer;
import com.caucho.hessian.io.StringValueSerializer;
import com.caucho.hessian.io.ThrowableSerializer;
import com.rc.retroweaver.runtime.ClassLiteral;
import java.io.IOException;
import java.util.HashMap;

public class SerializerFactory {
    private static HashMap _serializerMap = new HashMap();
    private static HashMap _deserializerMap = new HashMap();
    private static HashMap _typeMap = new HashMap();
    protected Serializer _defaultSerializer;
    protected CollectionSerializer _collectionSerializer;
    private Deserializer _hashMapDeserializer;
    private HashMap _cachedSerializerMap;
    private HashMap _cachedDeserializerMap;
    private HashMap _cachedTypeDeserializerMap;

    public void setSendCollectionType(boolean isSendType) {
        if (this._collectionSerializer == null) {
            this._collectionSerializer = new CollectionSerializer();
        }
        this._collectionSerializer.setSendJavaType(isSendType);
    }

    public Serializer getSerializer(Class cl) throws HessianProtocolException {
        Serializer serializer = (Serializer)_serializerMap.get(cl);
        if (serializer != null) {
            return serializer;
        }
        if (this._cachedSerializerMap != null && (serializer = (Serializer)this._cachedSerializerMap.get(cl)) != null) {
            return serializer;
        }
        if (ClassLiteral.getClass((String)"com/caucho/hessian/io/HessianRemoteObject").isAssignableFrom(cl)) {
            serializer = new RemoteSerializer();
        } else if (ClassLiteral.getClass((String)"com/caucho/burlap/io/BurlapRemoteObject").isAssignableFrom(cl)) {
            serializer = new RemoteSerializer();
        } else if (ClassLiteral.getClass((String)"java/util/Map").isAssignableFrom(cl)) {
            serializer = new MapSerializer();
        } else if (ClassLiteral.getClass((String)"java/util/Collection").isAssignableFrom(cl)) {
            if (this._collectionSerializer == null) {
                this._collectionSerializer = new CollectionSerializer();
            }
            serializer = this._collectionSerializer;
        } else if (cl.isArray()) {
            serializer = new ArraySerializer();
        } else if (ClassLiteral.getClass((String)"java/lang/Throwable").isAssignableFrom(cl)) {
            serializer = new ThrowableSerializer();
        } else if (ClassLiteral.getClass((String)"java/io/InputStream").isAssignableFrom(cl)) {
            serializer = new InputStreamSerializer();
        } else if (ClassLiteral.getClass((String)"java/util/Iterator").isAssignableFrom(cl)) {
            serializer = IteratorSerializer.create();
        } else if (ClassLiteral.getClass((String)"java/util/Enumeration").isAssignableFrom(cl)) {
            serializer = EnumerationSerializer.create();
        }
        if (serializer == null) {
            serializer = this.getDefaultSerializer(cl);
        }
        if (this._cachedSerializerMap == null) {
            this._cachedSerializerMap = new HashMap(8);
        }
        this._cachedSerializerMap.put(cl, serializer);
        return serializer;
    }

    protected Serializer getDefaultSerializer(Class cl) {
        if (this._defaultSerializer != null) {
            return this._defaultSerializer;
        }
        return new JavaSerializer(cl);
    }

    public Deserializer getDeserializer(Class cl) throws HessianProtocolException {
        Deserializer deserializer = (Deserializer)_deserializerMap.get(cl);
        if (deserializer != null) {
            return deserializer;
        }
        if (this._cachedDeserializerMap != null && (deserializer = (Deserializer)this._cachedDeserializerMap.get(cl)) != null) {
            return deserializer;
        }
        deserializer = ClassLiteral.getClass((String)"java/util/Collection").isAssignableFrom(cl) ? new CollectionDeserializer(cl) : (ClassLiteral.getClass((String)"java/util/Map").isAssignableFrom(cl) ? new MapDeserializer(cl) : (cl.isArray() ? new ArrayDeserializer(this.getDeserializer(cl.getComponentType())) : (ClassLiteral.getClass((String)"java/util/Enumeration").isAssignableFrom(cl) ? EnumerationDeserializer.create() : this.getDefaultDeserializer(cl))));
        if (this._cachedDeserializerMap == null) {
            this._cachedDeserializerMap = new HashMap(8);
        }
        this._cachedDeserializerMap.put(cl, deserializer);
        return deserializer;
    }

    protected Deserializer getDefaultDeserializer(Class cl) {
        return new JavaDeserializer(cl);
    }

    public Object readList(AbstractHessianInput in, int length, String type) throws HessianProtocolException, IOException {
        Deserializer deserializer = this.getDeserializer(type);
        if (deserializer != null) {
            return deserializer.readList(in, length);
        }
        return new CollectionDeserializer(ClassLiteral.getClass((String)"java/util/ArrayList")).readList(in, length);
    }

    public Object readMap(AbstractHessianInput in, String type) throws HessianProtocolException, IOException {
        Deserializer deserializer = this.getDeserializer(type);
        if (deserializer != null) {
            return deserializer.readMap(in);
        }
        if (this._hashMapDeserializer != null) {
            return this._hashMapDeserializer.readMap(in);
        }
        this._hashMapDeserializer = new MapDeserializer(ClassLiteral.getClass((String)"java/util/HashMap"));
        return this._hashMapDeserializer.readMap(in);
    }

    public Deserializer getObjectDeserializer(String type) throws HessianProtocolException {
        Deserializer deserializer = this.getDeserializer(type);
        if (deserializer != null) {
            return deserializer;
        }
        if (this._hashMapDeserializer != null) {
            return this._hashMapDeserializer;
        }
        this._hashMapDeserializer = new MapDeserializer(ClassLiteral.getClass((String)"java/util/HashMap"));
        return this._hashMapDeserializer;
    }

    public Deserializer getDeserializer(String type) throws HessianProtocolException {
        Deserializer deserializer;
        if (type == null || type.equals("")) {
            return null;
        }
        if (this._cachedTypeDeserializerMap != null) {
            deserializer = (Deserializer)this._cachedTypeDeserializerMap.get(type);
        }
        if ((deserializer = (Deserializer)_typeMap.get(type)) != null) {
            return deserializer;
        }
        if (type.startsWith("[")) {
            Deserializer subDeserializer = this.getDeserializer(type.substring(1));
            deserializer = new ArrayDeserializer(subDeserializer);
        } else {
            try {
                ClassLoader loader = Thread.currentThread().getContextClassLoader();
                Class<?> cl = Class.forName(type, false, loader);
                deserializer = this.getDeserializer(cl);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (deserializer != null) {
            if (this._cachedTypeDeserializerMap == null) {
                this._cachedTypeDeserializerMap = new HashMap(8);
            }
            this._cachedTypeDeserializerMap.put(type, deserializer);
        }
        return deserializer;
    }

    private static void addBasic(Class cl, String typeName, int type) {
        _serializerMap.put(cl, new BasicSerializer(type));
        BasicDeserializer deserializer = new BasicDeserializer(type);
        _deserializerMap.put(cl, deserializer);
        _typeMap.put(typeName, deserializer);
    }

    static {
        SerializerFactory.addBasic(ClassLiteral.getClass((String)"java/lang/Boolean"), "boolean", 1);
        SerializerFactory.addBasic(ClassLiteral.getClass((String)"java/lang/Byte"), "byte", 2);
        SerializerFactory.addBasic(ClassLiteral.getClass((String)"java/lang/Short"), "short", 3);
        SerializerFactory.addBasic(ClassLiteral.getClass((String)"java/lang/Integer"), "int", 4);
        SerializerFactory.addBasic(ClassLiteral.getClass((String)"java/lang/Long"), "long", 5);
        SerializerFactory.addBasic(ClassLiteral.getClass((String)"java/lang/Float"), "float", 6);
        SerializerFactory.addBasic(ClassLiteral.getClass((String)"java/lang/Double"), "double", 7);
        SerializerFactory.addBasic(ClassLiteral.getClass((String)"java/lang/Character"), "char", 8);
        SerializerFactory.addBasic(ClassLiteral.getClass((String)"java/lang/String"), "string", 9);
        SerializerFactory.addBasic(ClassLiteral.getClass((String)"java/util/Date"), "date", 10);
        SerializerFactory.addBasic(Boolean.TYPE, "boolean", 1);
        SerializerFactory.addBasic(Byte.TYPE, "byte", 2);
        SerializerFactory.addBasic(Short.TYPE, "short", 3);
        SerializerFactory.addBasic(Integer.TYPE, "int", 4);
        SerializerFactory.addBasic(Long.TYPE, "long", 5);
        SerializerFactory.addBasic(Float.TYPE, "float", 6);
        SerializerFactory.addBasic(Double.TYPE, "double", 7);
        SerializerFactory.addBasic(Character.TYPE, "char", 8);
        SerializerFactory.addBasic(ClassLiteral.getClass((String)"[Z"), "[boolean", 11);
        SerializerFactory.addBasic(ClassLiteral.getClass((String)"[B"), "[byte", 12);
        SerializerFactory.addBasic(ClassLiteral.getClass((String)"[S"), "[short", 13);
        SerializerFactory.addBasic(ClassLiteral.getClass((String)"[I"), "[int", 14);
        SerializerFactory.addBasic(ClassLiteral.getClass((String)"[J"), "[long", 15);
        SerializerFactory.addBasic(ClassLiteral.getClass((String)"[F"), "[float", 16);
        SerializerFactory.addBasic(ClassLiteral.getClass((String)"[D"), "[double", 17);
        SerializerFactory.addBasic(ClassLiteral.getClass((String)"[C"), "[char", 18);
        SerializerFactory.addBasic(ClassLiteral.getClass((String)"[Ljava/lang/String;"), "[string", 19);
        SerializerFactory.addBasic(ClassLiteral.getClass((String)"[Ljava/lang/Object;"), "[object", 20);
        _serializerMap.put(ClassLiteral.getClass((String)"java/lang/Class"), new ClassSerializer());
        _deserializerMap.put(ClassLiteral.getClass((String)"java/lang/Class"), new ClassDeserializer());
        _serializerMap.put(ClassLiteral.getClass((String)"java/math/BigDecimal"), new StringValueSerializer());
        try {
            _deserializerMap.put(ClassLiteral.getClass((String)"java/math/BigDecimal"), new StringValueDeserializer(ClassLiteral.getClass((String)"java/math/BigDecimal")));
        }
        catch (Throwable e) {
            // empty catch block
        }
        _serializerMap.put(ClassLiteral.getClass((String)"java/io/File"), new StringValueSerializer());
        try {
            _deserializerMap.put(ClassLiteral.getClass((String)"java/io/File"), new StringValueDeserializer(ClassLiteral.getClass((String)"java/io/File")));
        }
        catch (Throwable e) {
            // empty catch block
        }
        _serializerMap.put(ClassLiteral.getClass((String)"java/sql/Date"), new SqlDateSerializer());
        _serializerMap.put(ClassLiteral.getClass((String)"java/sql/Time"), new SqlDateSerializer());
        _serializerMap.put(ClassLiteral.getClass((String)"java/sql/Timestamp"), new SqlDateSerializer());
        try {
            _deserializerMap.put(ClassLiteral.getClass((String)"java/sql/Date"), new SqlDateDeserializer(ClassLiteral.getClass((String)"java/sql/Date")));
            _deserializerMap.put(ClassLiteral.getClass((String)"java/sql/Time"), new SqlDateDeserializer(ClassLiteral.getClass((String)"java/sql/Time")));
            _deserializerMap.put(ClassLiteral.getClass((String)"java/sql/Timestamp"), new SqlDateDeserializer(ClassLiteral.getClass((String)"java/sql/Timestamp")));
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        try {
            Class<?> stackTrace = Class.forName("java.lang.StackTraceElement");
            _deserializerMap.put(stackTrace, new StackTraceElementDeserializer());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

