/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.iiop;

import com.caucho.iiop.CosServer;
import com.caucho.iiop.IOR;
import com.caucho.iiop.Iiop10Writer;
import com.caucho.iiop.Iiop11Writer;
import com.caucho.iiop.Iiop12Writer;
import com.caucho.iiop.IiopProtocol;
import com.caucho.iiop.IiopReader;
import com.caucho.iiop.IiopSkeleton;
import com.caucho.iiop.IiopWriter;
import com.caucho.iiop.MarshallObject;
import com.caucho.iiop.StreamMessageWriter;
import com.caucho.log.Log;
import com.caucho.server.connection.Connection;
import com.caucho.server.port.ServerRequest;
import com.caucho.vfs.ReadStream;
import com.caucho.vfs.WriteStream;
import com.rc.retroweaver.runtime.ClassLiteral;
import java.io.IOException;
import java.net.InetAddress;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.omg.CORBA.SystemException;

public class IiopRequest
implements ServerRequest {
    private static final Logger log = Log.open(ClassLiteral.getClass((String)"com/caucho/iiop/IiopRequest"));
    Connection _conn;
    IiopProtocol _server;
    IiopReader _reader;
    StreamMessageWriter _messageWriter;
    IiopWriter _writer10;
    IiopWriter _writer11;
    IiopWriter _writer12;
    ReadStream _readStream;
    WriteStream _writeStream;
    CosServer _cos;
    IiopSkeleton _cosSkel;
    String _hostName;
    int _port;

    IiopRequest(IiopProtocol server, Connection conn) {
        this._server = server;
        this._conn = conn;
        this._reader = new IiopReader();
        this._messageWriter = new StreamMessageWriter();
        this._writer10 = new Iiop10Writer();
        this._writer10.init(this._messageWriter);
        this._writer11 = new Iiop11Writer();
        this._writer11.init(this._messageWriter);
        this._writer12 = new Iiop12Writer();
        this._writer12.init(this._messageWriter);
        this._cos = this._server.getCos();
    }

    public void init() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean handleRequest() throws IOException {
        log.finer("IIOP[" + this._conn.getId() + "]: handle request");
        this._readStream = this._conn.getReadStream();
        this._writeStream = this._conn.getWriteStream();
        Thread thread = Thread.currentThread();
        ClassLoader loader = thread.getContextClassLoader();
        if (this._cosSkel == null) {
            InetAddress local = this._conn.getLocalAddress();
            this._hostName = local.getHostName();
            this._port = this._conn.getLocalPort();
            this._cos.setHost(this._hostName);
            this._cos.setPort(this._port);
            this._cosSkel = new IiopSkeleton(this._cos, this._cos.getClass(), loader, this._hostName, this._port, "/NameService");
        }
        try {
            int ch = this._readStream.read();
            if (ch < 0) {
                log.finer("IIOP[" + this._conn.getId() + "]: end of stream");
                boolean bl = false;
                return bl;
            }
            this._readStream.unread();
            this._reader.init(this._readStream);
            this._messageWriter.init(this._writeStream);
            IiopWriter writer = this._writer10;
            this._reader.readRequest();
            switch (this._reader.getMinorVersion()) {
                case 0: {
                    writer = this._writer10;
                    break;
                }
                case 1: {
                    writer = this._writer11;
                    break;
                }
                case 2: {
                    writer = this._writer12;
                    break;
                }
                default: {
                    writer = this._writer10;
                }
            }
            writer.setHost(this._hostName);
            writer.setPort(this._port);
            String oid = this._reader.getObjectKey().toString();
            if (log.isLoggable(Level.FINER)) {
                log.finer("IIOP[" + this._conn.getId() + "] OID: " + oid);
            }
            try {
                if (oid.equals("INIT")) {
                    String str = this._reader.readString();
                    writer.startReplyOk(this._reader.getRequestId());
                    if (str.equals("NameService")) {
                        String nameService = "IDL:omg.org/CosNaming/NamingContext:1.0";
                        IOR ior = new IOR(nameService, this._hostName, this._port, "/NameService");
                        byte[] bytes = ior.getByteArray();
                        writer.write(bytes, 0, bytes.length);
                    } else {
                        writer.writeNullIOR();
                    }
                } else if (oid.equals("/NameService")) {
                    this._cosSkel.service(this._cosSkel.getObject(), this._reader, writer);
                } else {
                    IiopSkeleton skel = this._server.getService(this._hostName, this._port, oid);
                    if (skel == null) {
                        log.fine("IIOP[" + this._conn.getId() + "] can't find service: " + oid);
                        throw new IOException("bad oid: " + oid);
                    }
                    skel.service(skel.getObject(), this._reader, writer);
                    log.fine("IIOP[" + this._conn.getId() + "] complete request");
                }
            }
            catch (SystemException e) {
                log.log(Level.WARNING, e.toString(), e);
                writer.startReplySystemException(this._reader.getRequestId(), e.toString(), e.minor, e.completed.value());
            }
            catch (Throwable e) {
                log.log(Level.WARNING, e.toString(), e);
                writer.startReplyUserException(this._reader.getRequestId());
                MarshallObject marshall = MarshallObject.create(e.getClass(), false);
                marshall.marshall(e, writer);
            }
            this._messageWriter.close();
            this._reader.completeRead();
        }
        catch (Throwable e) {
            log.log(Level.WARNING, "IIOP[" + this._conn.getId() + "] " + e.toString(), e);
            e.printStackTrace();
            boolean bl = false;
            return bl;
        }
        finally {
            thread.setContextClassLoader(loader);
        }
        if (log.isLoggable(Level.FINER)) {
            log.finer("IIOP[" + this._conn.getId() + "]: recycle");
        }
        return true;
    }
}

