/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.iiop;

import com.caucho.config.ConfigException;
import com.caucho.ejb.AbstractStubLoader;
import com.caucho.iiop.IiopStubCompiler;
import com.caucho.loader.DynamicClassLoader;
import com.caucho.log.Log;
import com.caucho.util.CauchoSystem;
import com.caucho.util.CharBuffer;
import com.caucho.vfs.Path;
import com.rc.retroweaver.runtime.ClassLiteral;
import java.net.URL;
import java.security.CodeSource;
import java.security.cert.Certificate;
import java.util.HashSet;
import java.util.logging.Level;
import java.util.logging.Logger;

public class IiopStubLoader
extends AbstractStubLoader {
    private static final Logger log = Log.open(ClassLiteral.getClass((String)"com/caucho/iiop/IiopStubLoader"));
    private HashSet<String> _stubClassNames = new HashSet();
    private CodeSource _codeSource;

    public IiopStubLoader() {
    }

    public IiopStubLoader(Path path) {
        this.setPath(path);
    }

    public void setLoader(DynamicClassLoader loader) {
        super.setLoader(loader);
        loader.addURL(this.getPath());
    }

    public void init() throws ConfigException {
        try {
            this._codeSource = new CodeSource(new URL(this.getPath().getURL()), (Certificate[])null);
        }
        catch (Exception e) {
            log.log(Level.FINE, e.toString(), e);
        }
    }

    public void addStubClass(String className) {
        int p = className.lastIndexOf(46);
        if (p > 0) {
            String tail = className.substring(p + 1);
            tail = "_" + tail + "_Stub";
            className = className.substring(0, p) + '.' + tail;
        } else {
            className = "_" + className + "_Stub";
        }
        className = "org.omg.stub." + className;
        className = className.replace('.', '/') + ".class";
        System.out.println("CL: " + className);
        this._stubClassNames.add(className);
    }

    public Path getPath(String name) {
        if (!this._stubClassNames.contains(name)) {
            return null;
        }
        Path stubClassPath = this.getPath().lookup(name);
        if (stubClassPath.canRead()) {
            return stubClassPath;
        }
        String fullClassName = name.substring(0, name.length() - ".class".length());
        fullClassName = fullClassName.replace('/', '.');
        String className = fullClassName.substring("org.omg.stub.".length());
        int p = (className = className.replace('/', '.')).lastIndexOf(46);
        if (p > 0) {
            String tail = className.substring(p + 1);
            tail = tail.substring(1, tail.length() - "_Stub".length());
            className = className.substring(0, p) + '.' + tail;
        }
        Thread thread = Thread.currentThread();
        ClassLoader loader = thread.getContextClassLoader();
        try {
            System.out.println("ZOOM: " + className);
            Class<?> cl = Class.forName(className, false, loader);
            System.out.println("CL: " + cl);
            IiopStubCompiler compiler = new IiopStubCompiler(cl);
            compiler.setFullClassName(fullClassName);
            compiler.setClassDir(this.getPath());
            compiler.generate();
            compiler.compileJava();
            System.out.println("OOK-OOK-OOK");
            if (stubClassPath.canRead()) {
                return stubClassPath;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            log.log(Level.WARNING, e.toString(), e);
        }
        return null;
    }

    protected CodeSource getCodeSource(Path path) {
        return this._codeSource;
    }

    protected String getClassPath(String head) {
        CharBuffer cb = new CharBuffer();
        if (!head.equals("")) {
            cb.append(head);
            cb.append(CauchoSystem.getPathSeparatorChar());
        }
        if (this.getPath().isDirectory()) {
            cb.append(this.getPath().getNativePath());
        }
        return cb.toString();
    }

    public String toString() {
        return "IiopStubLoader[" + this.getPath() + "]";
    }
}

