/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.iiop;

import com.caucho.iiop.MessageWriter;
import com.caucho.vfs.WriteStream;
import java.io.IOException;

public class StreamMessageWriter
extends MessageWriter {
    private WriteStream _out;
    private byte[] _buffer;
    private int _bufferLength;
    private int _offset;
    private int _length;
    private int _version;

    public StreamMessageWriter() {
    }

    public StreamMessageWriter(WriteStream out) {
        this.init(out);
    }

    public void init(WriteStream out) {
        this._out = out;
        this._buffer = this._out.getBuffer();
        this._bufferLength = this._buffer.length;
        this._buffer[0] = 71;
        this._buffer[1] = 73;
        this._buffer[2] = 79;
        this._buffer[3] = 80;
    }

    public void start10Message(int type) {
        this._version = 0;
        this._offset = 0;
        this._length = 12;
        this._buffer[4] = 1;
        this._buffer[5] = 0;
        this._buffer[6] = 0;
        this._buffer[7] = (byte)type;
    }

    public void start11Message(int type) {
        this._version = 1;
        this._offset = 0;
        this._length = 12;
        this._buffer[4] = 1;
        this._buffer[5] = 1;
        this._buffer[6] = 0;
        this._buffer[7] = (byte)type;
    }

    public void start12Message(int type, int requestId) {
        this._version = 2;
        this._offset = 4;
        this._length = 16;
        this._buffer[4] = 1;
        this._buffer[5] = 2;
        this._buffer[6] = 0;
        this._buffer[7] = (byte)type;
        this._buffer[12] = (byte)(requestId >> 24);
        this._buffer[13] = (byte)(requestId >> 16);
        this._buffer[14] = (byte)(requestId >> 8);
        this._buffer[15] = (byte)requestId;
    }

    public int getOffset() {
        if (this._bufferLength <= this._length + 4) {
            this.flushBuffer();
        }
        return this._offset;
    }

    public void write(int v) {
        if (this._bufferLength <= this._length) {
            this.flushBuffer();
        }
        ++this._offset;
        this._buffer[this._length++] = (byte)v;
    }

    public void write(byte[] buffer, int offset, int length) {
        while (length > 0) {
            int sublen = this._bufferLength - this._length;
            if (length < sublen) {
                sublen = length;
            }
            System.arraycopy(buffer, offset, this._buffer, this._length, sublen);
            this._offset += sublen;
            this._length += sublen;
            if ((length -= sublen) <= 0) continue;
            this.flushBuffer();
        }
    }

    public void writeShort(int v) {
        if (this._bufferLength <= this._length + 1) {
            this.flushBuffer();
        }
        this._offset += 2;
        this._buffer[this._length++] = (byte)(v >> 8);
        this._buffer[this._length++] = (byte)v;
    }

    public void writeInt(int v) {
        if (this._bufferLength <= this._length + 3) {
            this.flushBuffer();
        }
        this._offset += 4;
        this._buffer[this._length++] = (byte)(v >> 24);
        this._buffer[this._length++] = (byte)(v >> 16);
        this._buffer[this._length++] = (byte)(v >> 8);
        this._buffer[this._length++] = (byte)v;
    }

    public void align(int v) {
        int delta = v - this._length % v;
        if (delta == v) {
            return;
        }
        this._offset += delta;
        while (delta > 0) {
            this._buffer[this._length++] = 0;
            --delta;
        }
    }

    public void flushBuffer() {
        try {
            int size = this._length - 12;
            this._buffer[6] = 2;
            this._buffer[8] = (byte)(size >> 24);
            this._buffer[9] = (byte)(size >> 16);
            this._buffer[10] = (byte)(size >> 8);
            this._buffer[11] = (byte)(size >> 0);
            if (this._version == 2) {
                this._length += (8 - this._length % 8) % 8;
            }
            this._out.setBufferOffset(this._length);
            this._out.flushBuffer();
            this._buffer[7] = 7;
            if (this._version == 2) {
                this._offset += 4;
                this._length = 16;
            } else {
                this._length = 12;
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void close() throws IOException {
        int size = this._length - 12;
        this._buffer[6] = 0;
        this._buffer[8] = (byte)(size >> 24);
        this._buffer[9] = (byte)(size >> 16);
        this._buffer[10] = (byte)(size >> 8);
        this._buffer[11] = (byte)(size >> 0);
        this._out.setBufferOffset(this._length);
        this._out.flushBuffer();
        this._length = 0;
    }

    public void debugData() {
        for (int tail = 0; tail < this._length; tail += 16) {
            int j;
            for (j = 0; j < 16; ++j) {
                System.out.print(" ");
                if (tail + j < this._length) {
                    this.printHex(this._buffer[tail + j]);
                    continue;
                }
                System.out.print("  ");
            }
            System.out.print(" ");
            for (j = 0; j < 16; ++j) {
                if (tail + j < this._length) {
                    this.printCh(this._buffer[tail + j]);
                    continue;
                }
                System.out.print(" ");
            }
            System.out.println();
        }
        System.out.println();
    }

    private void printHex(int d) {
        int ch1 = d >> 4 & 0xF;
        int ch2 = d & 0xF;
        if (ch1 >= 10) {
            System.out.print((char)(97 + ch1 - 10));
        } else {
            System.out.print((char)(48 + ch1));
        }
        if (ch2 >= 10) {
            System.out.print((char)(97 + ch2 - 10));
        } else {
            System.out.print((char)(48 + ch2));
        }
    }

    private void printCh(int d) {
        if (d >= 32 && d <= 127) {
            System.out.print("" + (char)d);
        } else {
            System.out.print(".");
        }
    }

    private String toCh(int d) {
        if (d >= 32 && d <= 127) {
            return "" + (char)d;
        }
        return "" + d;
    }

    private static String toHex(int v) {
        String s = "";
        for (int i = 28; i >= 0; i -= 4) {
            int h = v >> i & 0xF;
            s = h >= 10 ? s + (char)(97 + h - 10) : s + h;
        }
        return s;
    }
}

