/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.j2ee.deployserver;

import com.caucho.config.NodeBuilder;
import com.caucho.hessian.io.HessianInput;
import com.caucho.hessian.io.HessianOutput;
import com.caucho.j2ee.deployclient.ProgressObjectImpl;
import com.caucho.j2ee.deployclient.TargetImpl;
import com.caucho.j2ee.deployclient.TargetModuleIDImpl;
import com.caucho.j2ee.deployserver.DeploymentPlan;
import com.caucho.jmx.Jmx;
import com.caucho.log.Log;
import com.caucho.server.host.mbean.HostMBean;
import com.caucho.util.IntMap;
import com.caucho.util.L10N;
import com.caucho.vfs.Path;
import com.caucho.vfs.WriteStream;
import com.caucho.xml.XmlPrinter;
import com.rc.retroweaver.runtime.ClassLiteral;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.logging.Logger;
import javax.enterprise.deploy.spi.TargetModuleID;
import javax.enterprise.deploy.spi.status.ProgressObject;
import javax.management.ObjectName;
import javax.servlet.GenericServlet;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.w3c.dom.Node;

public class DeployServlet
extends GenericServlet {
    private static final L10N L = new L10N(ClassLiteral.getClass((String)"com/caucho/j2ee/deployserver/DeployServlet"));
    private static final Logger log = Log.open(ClassLiteral.getClass((String)"com/caucho/j2ee/deployserver/DeployServlet"));
    private static final int GET_TARGETS = 1;
    private static final int DISTRIBUTE = 2;
    private static final int GET_AVAILABLE_MODULES = 3;
    private static final int UNDEPLOY = 4;
    private static final IntMap _methodMap = new IntMap();
    private TargetImpl _target;
    private TargetImpl[] _targets;
    private Path _deployPath;
    private HostMBean _hostMBean;

    public void setDeployPath(Path path) {
        this._deployPath = path;
    }

    public void init() throws ServletException {
        try {
            this._target = new TargetImpl("Resin-target", "default target");
            this._targets = new TargetImpl[]{this._target};
            if (this._deployPath == null) {
                throw new ServletException(L.l("<deploy-path> is required."));
            }
            this._deployPath.mkdirs();
            ObjectName hostName = new ObjectName("resin:type=Host,name=current");
            this._hostMBean = (HostMBean)Jmx.find(hostName);
        }
        catch (ServletException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ServletException(e);
        }
    }

    public void service(ServletRequest req, ServletResponse res) throws IOException, ServletException {
        ServletInputStream is = req.getInputStream();
        ServletOutputStream os = res.getOutputStream();
        HessianInput in = new HessianInput(is);
        HessianOutput out = new HessianOutput(os);
        in.readCall();
        String method = in.readMethod();
        try {
            switch (_methodMap.get(method)) {
                case 1: {
                    in.completeCall();
                    out.startReply();
                    out.writeObject(this._targets);
                    out.completeReply();
                    break;
                }
                case 3: {
                    String type = in.readString();
                    in.completeCall();
                    out.startReply();
                    out.writeObject(this.getAvailableModules(type));
                    out.completeReply();
                    break;
                }
                case 2: {
                    TargetImpl[] targets = (TargetImpl[])in.readObject(ClassLiteral.getClass((String)"[Lcom/caucho/j2ee/deployclient/TargetImpl;"));
                    InputStream planIs = in.readInputStream();
                    DeploymentPlan plan = new DeploymentPlan();
                    new NodeBuilder().configure((Object)plan, planIs);
                    planIs.close();
                    InputStream archiveIs = in.readInputStream();
                    ProgressObject po = this.distribute(targets, plan, archiveIs);
                    in.completeCall();
                    out.startReply();
                    out.writeObject(po);
                    out.completeReply();
                    break;
                }
                case 4: {
                    TargetModuleID[] targetIDs = (TargetModuleID[])in.readObject(ClassLiteral.getClass((String)"[Lcom/caucho/j2ee/deployclient/TargetModuleIDImpl;"));
                    ProgressObject po = this.undeploy(targetIDs);
                    in.completeCall();
                    out.startReply();
                    out.writeObject(po);
                    out.completeReply();
                    break;
                }
                default: {
                    out.startReply();
                    out.writeFault("UnknownMethod", "UnknownMethod: " + method, null);
                    out.completeReply();
                    break;
                }
            }
        }
        catch (Exception e) {
            out.startReply();
            out.writeFault(e.toString(), e.toString(), e);
            out.completeReply();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ProgressObject distribute(TargetImpl[] targets, DeploymentPlan plan, InputStream archiveIs) throws IOException {
        if (archiveIs == null) {
            return null;
        }
        Path path = this._deployPath.lookup(plan.getArchiveName());
        WriteStream os = path.openWrite();
        try {
            os.writeStream(archiveIs);
        }
        finally {
            os.close();
        }
        Path metaPath = this._deployPath.lookup(plan.getMetaPathName());
        ArrayList<DeploymentPlan.ExtFile> _extFileList = plan.getExtFileList();
        for (int i = 0; i < _extFileList.size(); ++i) {
            DeploymentPlan.ExtFile extFile = _extFileList.get(i);
            Path filePath = metaPath.lookup(extFile.getName());
            Node node = extFile.getData();
            filePath.getParent().mkdirs();
            XmlPrinter.print(filePath, node);
        }
        log.info("deploying: " + plan.getName());
        this._hostMBean.updateEarDeploy(plan.getName());
        this._hostMBean.updateWebAppDeploy(plan.getName());
        TargetModuleIDImpl id = new TargetModuleIDImpl(targets[0], plan.getArchiveName());
        return new ProgressObjectImpl(new TargetModuleID[]{id});
    }

    private TargetModuleID[] getAvailableModules(String type) throws IOException {
        TargetImpl target = this._targets[0];
        System.out.println("MODES: " + type);
        ArrayList<TargetModuleIDImpl> idList = new ArrayList<TargetModuleIDImpl>();
        String[] list = this._deployPath.list();
        for (int i = 0; i < list.length; ++i) {
            TargetModuleIDImpl id;
            String name = list[i];
            Path path = this._deployPath.lookup(name);
            if (type.equals("war") && name.endsWith(".war")) {
                id = new TargetModuleIDImpl(target, name);
                if (idList.contains(id)) continue;
                idList.add(id);
                continue;
            }
            if (type.equals("war") && path.isDirectory() && !name.startsWith("_")) {
                id = new TargetModuleIDImpl(target, name = name + ".war");
                if (idList.contains(id)) continue;
                idList.add(id);
                continue;
            }
            if (type.equals("rar") && name.endsWith(".rar")) {
                id = new TargetModuleIDImpl(target, name);
                if (idList.contains(id)) continue;
                idList.add(id);
                continue;
            }
            if (!type.equals("rar") || !path.isDirectory() || !name.startsWith("_rar_") || idList.contains(id = new TargetModuleIDImpl(target, name = name.substring(5) + ".rar"))) continue;
            idList.add(id);
        }
        TargetModuleID[] idArray = new TargetModuleID[idList.size()];
        idList.toArray(idArray);
        return idArray;
    }

    private ProgressObject undeploy(TargetModuleID[] ids) throws IOException {
        if (ids == null || ids.length == 0) {
            return null;
        }
        this.stop(ids);
        for (int i = 0; i < ids.length; ++i) {
            String name = ids[i].getModuleID();
            this._deployPath.lookup(name).remove();
            if (name.endsWith(".war")) {
                name = name.substring(0, name.length() - 4);
                this._deployPath.lookup(name).removeAll();
            } else if (name.endsWith(".ear")) {
                name = "_ear_" + name.substring(0, name.length() - 4);
                this._deployPath.lookup(name).removeAll();
            } else if (name.endsWith(".rar")) {
                name = "_rar_" + name.substring(0, name.length() - 4);
                this._deployPath.lookup(name).removeAll();
            }
            this._hostMBean.updateWebAppDeploy(name);
        }
        return new ProgressObjectImpl(ids);
    }

    private void stop(TargetModuleID[] targets) throws IOException {
    }

    static {
        _methodMap.put("getTargets", 1);
        _methodMap.put("distribute", 2);
        _methodMap.put("getAvailableModules", 3);
        _methodMap.put("undeploy", 4);
    }
}

