/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.java;

import com.caucho.java.AbstractJavaCompiler;
import com.caucho.java.ErrorParser;
import com.caucho.java.JavaCompileException;
import com.caucho.java.JavaCompiler;
import com.caucho.java.JavacErrorParser;
import com.caucho.java.LineMap;
import com.caucho.loader.ClassLoaderContext;
import com.caucho.log.Log;
import com.caucho.util.Alarm;
import com.caucho.util.CauchoSystem;
import com.caucho.util.CharBuffer;
import com.caucho.vfs.Encoding;
import com.caucho.vfs.IOExceptionWrapper;
import com.caucho.vfs.MemoryStream;
import com.caucho.vfs.Path;
import com.caucho.vfs.ReadStream;
import com.caucho.vfs.Vfs;
import com.caucho.vfs.WriteStream;
import com.rc.retroweaver.runtime.ClassLiteral;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExternalCompiler
extends AbstractJavaCompiler {
    protected static final Logger log = Log.open(ClassLiteral.getClass((String)"com/caucho/java/ExternalCompiler"));
    Process _process;
    String _userPrefix;
    boolean _isDead;

    public ExternalCompiler(JavaCompiler compiler) {
        super(compiler);
    }

    @Override
    protected void compileInt(String[] paths, LineMap lineMap) throws IOException {
        MemoryStream tempStream = new MemoryStream();
        WriteStream error = new WriteStream(tempStream);
        InputStream inputStream = null;
        InputStream errorStream = null;
        boolean chdir = CauchoSystem.isUnix();
        this._process = null;
        try {
            String msg;
            ReadStream read;
            String javac = this._compiler.getCompiler();
            String sourceExt = this._compiler.getSourceExtension();
            String path = paths[0];
            int tail = path.length() - sourceExt.length();
            String className = path.substring(0, tail);
            Path classFile = this._compiler.getClassDir().lookup(new StringBuffer().append(className).append(".class").toString());
            ArrayList<String> argList = new ArrayList<String>();
            argList.add(javac);
            ArrayList<String> args = this._compiler.getArgs();
            if (args != null) {
                argList.addAll(args);
            }
            if (javac.endsWith("jikes") || javac.endsWith("jikes.exe")) {
                argList.add("+E");
                chdir = false;
                if (this._compiler.getEncoding() != null) {
                    argList.add("-encoding");
                    argList.add(this._compiler.getEncoding());
                }
            } else if (this._compiler.getEncoding() != null) {
                String encoding = Encoding.getJavaName(this._compiler.getEncoding());
                argList.add("-encoding");
                argList.add(encoding);
            }
            if (this._compiler.getCompiler().endsWith("groovyc")) {
                argList.add("--classpath");
                argList.add(this.normalizeClassPath(this._compiler.getClassPath(), !chdir));
            } else {
                argList.add("-classpath");
                argList.add(this.normalizeClassPath(this._compiler.getClassPath(), !chdir));
            }
            argList.add("-d");
            argList.add(this.normalizePath(this._compiler.getClassDirName(), !chdir));
            for (int i = 0; i < paths.length; ++i) {
                if (chdir) {
                    argList.add(paths[i]);
                    continue;
                }
                Path javaPath = this._compiler.getSourceDir().lookup(paths[i]);
                argList.add(javaPath.getNativePath());
            }
            if (log.isLoggable(Level.FINE)) {
                log.fine(String.valueOf(argList));
            }
            this._process = this.executeCompiler(argList, chdir);
            if (this._process != null) {
                inputStream = this._process.getInputStream();
                errorStream = this._process.getErrorStream();
            }
            int status = 666;
            try {
                this.waitForErrors(error, inputStream, errorStream);
                if (this._process != null) {
                    status = this._process.waitFor();
                    this._process = null;
                }
            }
            catch (Throwable e) {
                if (this._isDead) {
                    throw new JavaCompileException(L.l("The compilation has timed out.  You can increase the timeout value by changing the max-compile-time."));
                }
                throw new IOExceptionWrapper(e);
            }
            if (this._process != null) {
                status = 666;
                try {
                    this._process.destroy();
                }
                catch (Throwable e) {
                    log.log(Level.FINE, e.toString(), e);
                }
            }
            error.close();
            tempStream.close();
            if (log.isLoggable(Level.FINE)) {
                int ch;
                read = tempStream.openRead();
                CharBuffer cb = new CharBuffer();
                while ((ch = read.read()) >= 0) {
                    cb.append((char)ch);
                }
                read.close();
                msg = cb.toString();
                new ClassLoaderContext(this._compiler.getClassLoader()){

                    public void run() {
                        log.fine(msg);
                    }
                };
            }
            read = tempStream.openRead();
            JavacErrorParser parser = new JavacErrorParser();
            String errors = ((ErrorParser)parser).parseErrors(read, lineMap);
            read.close();
            if (errors != null) {
                errors = errors.trim();
            }
            if (status == 0 && classFile.getLength() > 0L) {
                if (errors != null && !errors.equals("")) {
                    msg = errors;
                    new ClassLoaderContext(this._compiler.getClassLoader()){

                        public void run() {
                            log.warning(msg);
                        }
                    };
                }
                return;
            }
            if (errors == null || errors.equals("")) {
                int ch;
                CharBuffer cb = new CharBuffer();
                if (status == 0) {
                    cb.append(new StringBuffer().append("Compilation for '").append(className).append("' did not generate a .class file.\n").toString());
                    cb.append("Make sure the `package' matches the directory.\n");
                } else {
                    cb.append("Unknown compiler error executing:\n");
                }
                for (int i = 0; i < argList.size(); ++i) {
                    cb.append(new StringBuffer().append(" ").append(argList.get(i)).append("\n").toString());
                }
                read = tempStream.openRead();
                while ((ch = read.read()) >= 0) {
                    cb.append((char)ch);
                }
                read.close();
                errors = cb.toString();
            } else if (errors.indexOf("command not found") >= 0) {
                throw new JavaCompileException(L.l("Resin can't execute the compiler `{0}'.  This usually means that the compiler is not in the operating system's PATH or the compiler is incorrectly specified in the configuration.  You may need to add the full path to <java compiler='{0}'/>.\n\n{1}", (Object)argList.get(0), errors));
            }
            throw new JavaCompileException(errors);
        }
        finally {
            if (inputStream != null) {
                inputStream.close();
            }
            if (errorStream != null) {
                errorStream.close();
            }
            tempStream.destroy();
        }
    }

    private void waitForErrors(WriteStream error, InputStream inputStream, InputStream errorStream) throws IOException {
        byte[] buffer = new byte[256];
        if (inputStream == null || errorStream == null) {
            return;
        }
        while (true) {
            int stdoutLen;
            int stderrLen;
            if ((stderrLen = errorStream.available()) > 0 && (stderrLen = errorStream.read(buffer, 0, buffer.length)) > 0) {
                error.write(buffer, 0, stderrLen);
                continue;
            }
            while ((stdoutLen = inputStream.available()) > 0 && (stdoutLen = inputStream.read(buffer, 0, buffer.length)) > 0) {
                error.write(buffer, 0, stdoutLen);
            }
            if (stderrLen < 0 && stdoutLen < 0) {
                return;
            }
            if (stderrLen == 0 && (stderrLen = errorStream.read(buffer, 0, buffer.length)) > 0) {
                error.write(buffer, 0, stderrLen);
            }
            if (stderrLen < 0 && stdoutLen == 0 && (stdoutLen = inputStream.read(buffer, 0, buffer.length)) > 0) {
                error.write(buffer, 0, stdoutLen);
            }
            if (this._isDead || stderrLen < 0 && stdoutLen < 0) break;
        }
    }

    public void handleAlarm(Alarm alarm) {
        this._isDead = true;
        if (this._process != null) {
            try {
                this._process.destroy();
            }
            catch (Throwable e) {
                log.log(Level.WARNING, e.toString(), e);
            }
        }
    }

    private Process executeCompiler(ArrayList<String> argList, boolean chdir) throws IOException {
        String[] args;
        int i;
        CharBuffer cb;
        if (chdir) {
            cb = new CharBuffer();
            cb.append("cd ");
            cb.append(this._compiler.getSourceDirName());
            cb.append(";");
            for (i = 0; i < argList.size(); ++i) {
                cb.append(" ");
                cb.append(argList.get(i));
            }
            args = new String[]{"/bin/sh", "-c", cb.toString()};
        } else {
            args = new String[argList.size()];
            argList.toArray(args);
        }
        if (log.isLoggable(Level.FINE)) {
            cb = CharBuffer.allocate();
            for (i = 0; i < args.length; ++i) {
                if (i != 0) {
                    cb.append(" ");
                }
                cb.append(args[i]);
            }
            log.fine(cb.close());
        }
        Runtime runtime = Runtime.getRuntime();
        try {
            return runtime.exec(args);
        }
        catch (Exception e) {
            throw new JavaCompileException(L.l("Resin can't execute the compiler `{0}'.  This usually means that the compiler is not in the operating system's PATH or the compiler is incorrectly specified in the configuration.  You may need to add the full path to <java compiler='{0}'/>.\n\n{1}", (Object)args[0], String.valueOf(e)));
        }
    }

    String normalizeClassPath(String classPath, boolean generateRelative) {
        char sep = CauchoSystem.getPathSeparatorChar();
        int head = 0;
        int tail = 0;
        CharBuffer cb = CharBuffer.allocate();
        while (head < classPath.length()) {
            tail = classPath.indexOf(sep, head);
            if (tail < 0) {
                tail = classPath.length();
            }
            if (tail > head) {
                String segment = classPath.substring(head, tail);
                if (Vfs.lookup(segment = this.normalizePath(segment, generateRelative)).exists()) {
                    if (cb.length() != 0) {
                        cb.append(sep);
                    }
                    cb.append(segment);
                }
            }
            head = tail + 1;
        }
        return cb.close();
    }

    String normalizePath(String segment, boolean generateRelative) {
        if (this._userPrefix == null) {
            Path userPath = Vfs.lookup(CauchoSystem.getUserDir());
            char sep = CauchoSystem.getFileSeparatorChar();
            this._userPrefix = userPath.getNativePath();
            if (this._userPrefix.length() == 0 || this._userPrefix.charAt(this._userPrefix.length() - 1) != sep) {
                this._userPrefix = new StringBuffer().append(this._userPrefix).append(sep).toString();
            }
        }
        Path path = Vfs.lookup(segment);
        String nativePath = path.getNativePath();
        if (!generateRelative) {
            return nativePath;
        }
        if (nativePath.startsWith(this._userPrefix)) {
            nativePath = nativePath.substring(this._userPrefix.length());
        }
        if (nativePath.equals("")) {
            return ".";
        }
        return nativePath;
    }

    public static class CompilerThread
    implements Runnable {
        private volatile boolean _isDone;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            this._isDone = true;
            CompilerThread compilerThread = this;
            synchronized (compilerThread) {
                this.notifyAll();
            }
        }
    }
}

